/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.passthru.config.BaseConfiguration;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.util.ControlledByteBuffer;

public class Pipe {
    public static final int DEFAULT_TIME_OUT_VALUE = 180000;
    private IOControl producerIoControl;
    private IOControl consumerIoControl;
    private ControlledByteBuffer buffer;
    private ControlledByteBuffer outputBuffer;
    private boolean producerCompleted = false;
    private Lock lock = new ReentrantLock();
    private Condition readCondition = this.lock.newCondition();
    private Condition writeCondition = this.lock.newCondition();
    private String name = "Buffer";
    private boolean consumerError = false;
    private boolean producerError = false;
    private boolean discardable = false;
    private static long socketTimeOut = PassThroughConfiguration.getInstance().getIntProperty("http.socket.timeout", 180000).intValue();
    private boolean awaitInterrupted = true;
    boolean isStale = false;
    private BaseConfiguration baseConfig;
    private boolean serializationComplete = false;
    private boolean rawSerializationComplete = false;
    private boolean hasHttpProducer = true;
    private ByteBufferInputStream inputStream;
    private ByteBufferOutputStream outputStream;

    public boolean isProducerCompleted() {
        return this.producerCompleted;
    }

    public Pipe(IOControl producerIoControl, ControlledByteBuffer buffer, String name, BaseConfiguration baseConfig) {
        this.producerIoControl = producerIoControl;
        this.buffer = buffer;
        this.name = this.name + "_" + name;
        this.baseConfig = baseConfig;
    }

    public Pipe(ControlledByteBuffer buffer, String name, BaseConfiguration baseConfig) {
        this.buffer = buffer;
        this.name = this.name + "_" + name;
        this.baseConfig = baseConfig;
        this.hasHttpProducer = false;
    }

    public void attachConsumer(IOControl consumerIoControl) {
        this.consumerIoControl = consumerIoControl;
    }

    private ControlledByteBuffer getConsumerBuffer() {
        return this.outputBuffer != null ? this.outputBuffer : this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consume(ContentEncoder encoder) throws IOException {
        if (this.consumerIoControl == null) {
            throw new IllegalStateException("Consumer cannot be null when calling consume");
        }
        if (this.hasHttpProducer && this.producerIoControl == null) {
            throw new IllegalStateException("Producer cannot be null when calling consume");
        }
        this.lock.lock();
        ControlledByteBuffer consumerBuffer = this.getConsumerBuffer();
        try {
            if (this.producerError) {
                encoder.complete();
                int n = -1;
                return n;
            }
            this.setOutputMode(consumerBuffer);
            int bytesWritten = encoder.write(consumerBuffer.getByteBuffer());
            this.consumePostActions(consumerBuffer, encoder, bytesWritten);
            int n = bytesWritten;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer copyAndConsume(ContentEncoder encoder) throws IOException {
        if (this.consumerIoControl == null) {
            throw new IllegalStateException("Consumer cannot be null when calling consume");
        }
        if (this.hasHttpProducer && this.producerIoControl == null) {
            throw new IllegalStateException("Producer cannot be null when calling consume");
        }
        this.lock.lock();
        ControlledByteBuffer consumerBuffer = this.getConsumerBuffer();
        try {
            if (this.producerError) {
                encoder.complete();
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            this.setOutputMode(consumerBuffer);
            ByteBuffer originalBuffer = consumerBuffer.getByteBuffer();
            int bytesWritten = encoder.write(originalBuffer);
            ByteBuffer duplicate = originalBuffer.duplicate();
            int position = originalBuffer.position();
            duplicate.limit(position);
            if (bytesWritten > 0) {
                duplicate.position(position - bytesWritten);
            }
            this.consumePostActions(consumerBuffer, encoder, bytesWritten);
            ByteBuffer byteBuffer = duplicate;
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void consumePostActions(ControlledByteBuffer consumerBuffer, ContentEncoder encoder, int bytesWritten) throws IOException {
        this.setInputMode(consumerBuffer);
        if (consumerBuffer.position() == 0) {
            if (this.outputBuffer == null) {
                if (this.producerCompleted) {
                    encoder.complete();
                } else {
                    this.consumerIoControl.suspendOutput();
                }
            } else if (this.serializationComplete || this.rawSerializationComplete) {
                encoder.complete();
            }
        }
        if (bytesWritten > 0 && !encoder.isCompleted() && !this.producerCompleted && this.hasHttpProducer) {
            this.producerIoControl.requestInput();
        }
        this.writeCondition.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int produce(ContentDecoder decoder) throws IOException {
        if (this.producerIoControl == null) {
            throw new IllegalStateException("Producer cannot be null when calling produce");
        }
        this.lock.lock();
        try {
            int bytesRead;
            this.setInputMode(this.buffer);
            try {
                bytesRead = decoder.read(this.buffer.getByteBuffer());
            }
            catch (MalformedChunkCodingException ignore) {
                this.buffer.putInt(-1);
                bytesRead = this.buffer.position();
            }
            this.producePostActions(decoder);
            int n = bytesRead;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer copyAndProduce(ContentDecoder decoder) throws IOException {
        if (this.producerIoControl == null) {
            throw new IllegalStateException("Producer cannot be null when calling produce");
        }
        this.lock.lock();
        try {
            ByteBuffer duplicate = null;
            this.setInputMode(this.buffer);
            try {
                ByteBuffer originalBuffer = this.buffer.getByteBuffer();
                int bytesRead = decoder.read(originalBuffer);
                duplicate = originalBuffer.duplicate();
                int position = originalBuffer.position();
                duplicate.limit(position);
                if (bytesRead > 0) {
                    duplicate.position(position - bytesRead);
                }
            }
            catch (MalformedChunkCodingException ignore) {
                this.buffer.putInt(-1);
                duplicate.putInt(-1);
            }
            this.producePostActions(decoder);
            ByteBuffer byteBuffer = duplicate;
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void producePostActions(ContentDecoder decoder) {
        if (this.consumerError) {
            this.buffer.clear();
        }
        if (!this.buffer.hasRemaining()) {
            this.producerIoControl.suspendInput();
        }
        if (this.buffer.position() > 0 || decoder.isCompleted()) {
            if (this.consumerIoControl != null) {
                this.consumerIoControl.requestOutput();
            }
            this.readCondition.signalAll();
        }
        if (decoder.isCompleted()) {
            this.producerCompleted = true;
        }
    }

    public void forceProducerComplete(ContentDecoder decoder) {
        if (!decoder.isCompleted()) {
            this.lock.lock();
            try {
                this.producerCompleted = true;
                this.readCondition.signalAll();
                if (this.consumerIoControl != null) {
                    this.consumerIoControl.requestOutput();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public void consumerError() {
        this.lock.lock();
        try {
            this.consumerError = true;
            this.writeCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void producerError() {
        this.lock.lock();
        try {
            this.producerError = true;
            this.readCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized InputStream getInputStream() {
        if (this.inputStream == null) {
            this.inputStream = new ByteBufferInputStream();
        }
        return this.inputStream;
    }

    public synchronized OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputBuffer = this.baseConfig.getBufferFactory().getBuffer();
            this.outputStream = new ByteBufferOutputStream();
        }
        return this.outputStream;
    }

    public synchronized OutputStream resetOutputStream() {
        this.outputBuffer = this.baseConfig.getBufferFactory().getBuffer();
        this.outputStream = new ByteBufferOutputStream();
        return this.outputStream;
    }

    public synchronized void setSerializationComplete(boolean serializationComplete) {
        if (!this.serializationComplete) {
            this.serializationComplete = serializationComplete;
            if (this.consumerIoControl != null) {
                this.consumerIoControl.requestOutput();
            }
        }
    }

    public void setRawSerializationComplete(boolean rawSerializationComplete) {
        this.rawSerializationComplete = rawSerializationComplete;
    }

    public void forceSetSerializationRest() {
        this.consumerError = false;
        if (this.serializationComplete) {
            this.serializationComplete = false;
        }
    }

    public boolean isSerializationComplete() {
        return this.serializationComplete;
    }

    public ControlledByteBuffer getBuffer() {
        return this.buffer;
    }

    public boolean hasHttpProducer() {
        return this.hasHttpProducer;
    }

    private void setInputMode(ControlledByteBuffer buffer) {
        if (buffer.setInputMode()) {
            if (buffer.hasRemaining()) {
                buffer.compact();
            } else {
                buffer.clear();
            }
        }
    }

    private void setOutputMode(ControlledByteBuffer buffer) {
        if (buffer.setOutputMode()) {
            buffer.flip();
        }
    }

    private boolean hasData(ControlledByteBuffer buffer) {
        this.lock.lock();
        try {
            this.setOutputMode(buffer);
            boolean bl = buffer.hasRemaining();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDiscardable() {
        return this.discardable;
    }

    public void setDiscardable(boolean discardable) {
        this.discardable = discardable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumeRequired() throws IOException {
        this.lock.lock();
        boolean isInputMode = this.buffer.isInputMode();
        try {
            if (isInputMode) {
                this.setOutputMode(this.buffer);
            }
            int readRemaining = this.buffer.remaining();
            int readPosition = this.buffer.position();
            this.setInputMode(this.buffer);
            int writePosition = this.buffer.position();
            int writeRemaining = this.buffer.remaining();
            boolean bl = readRemaining == 0 && writeRemaining == readPosition || writePosition == this.buffer.capacity() && readPosition == 0;
            return bl;
        }
        finally {
            if (isInputMode) {
                this.setInputMode(this.buffer);
            }
            this.lock.unlock();
        }
    }

    public boolean isProducerError() {
        return this.producerError;
    }

    private class ByteBufferOutputStream
    extends OutputStream {
        private ByteBufferOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            Pipe.this.lock.lock();
            try {
                Pipe.this.setInputMode(Pipe.this.outputBuffer);
                if (!Pipe.this.outputBuffer.hasRemaining()) {
                    this.flushContent();
                    if (Pipe.this.consumerError || Pipe.this.isStale) {
                        Pipe.this.buffer.clear();
                        return;
                    }
                    if (!Pipe.this.awaitInterrupted) {
                        Pipe.this.buffer.clear();
                        throw new IOException("Output buffer write time out exceeded");
                    }
                    Pipe.this.setInputMode(Pipe.this.outputBuffer);
                }
                Pipe.this.outputBuffer.put((byte)b);
            }
            finally {
                Pipe.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                return;
            }
            Pipe.this.lock.lock();
            try {
                Pipe.this.setInputMode(Pipe.this.outputBuffer);
                int remaining = len;
                if (Pipe.this.consumerError || Pipe.this.isStale) {
                    Pipe.this.buffer.clear();
                    Pipe.this.isStale = false;
                    throw new IOException("Consumer error or stale connection has occurred.");
                }
                if (Pipe.this.consumerIoControl instanceof NHttpServerConnection) {
                    if (((NHttpServerConnection)Pipe.this.consumerIoControl).isStale()) {
                        Pipe.this.isStale = true;
                        Pipe.this.writeCondition.signalAll();
                        Pipe.this.buffer.clear();
                        return;
                    }
                } else if (Pipe.this.consumerIoControl instanceof NHttpClientConnection && ((NHttpClientConnection)Pipe.this.consumerIoControl).isStale()) {
                    Pipe.this.isStale = true;
                    Pipe.this.writeCondition.signalAll();
                    Pipe.this.buffer.clear();
                    return;
                }
                while (remaining > 0 && !Pipe.this.consumerError && !Pipe.this.isStale && Pipe.this.awaitInterrupted) {
                    if (!Pipe.this.outputBuffer.hasRemaining()) {
                        this.flushContent();
                        if (Pipe.this.consumerError || Pipe.this.isStale) {
                            Pipe.this.buffer.clear();
                            break;
                        }
                        if (!Pipe.this.awaitInterrupted) {
                            Pipe.this.buffer.clear();
                            throw new IOException("Output buffer write time out exceeded");
                        }
                        Pipe.this.setInputMode(Pipe.this.outputBuffer);
                    }
                    int chunk = Math.min(remaining, Pipe.this.outputBuffer.remaining());
                    Pipe.this.outputBuffer.put(b, off, chunk);
                    remaining -= chunk;
                    off += chunk;
                }
            }
            finally {
                Pipe.this.lock.unlock();
            }
        }

        private void flushContent() throws IOException {
            if (Pipe.this.rawSerializationComplete) {
                return;
            }
            Pipe.this.lock.lock();
            try {
                try {
                    while (Pipe.this.hasData(Pipe.this.outputBuffer) && !Pipe.this.consumerError && !Pipe.this.isStale) {
                        if (Pipe.this.consumerError) {
                        } else {
                            if (Pipe.this.consumerIoControl == null || Pipe.this.writeCondition == null) continue;
                            Pipe.this.consumerIoControl.requestOutput();
                            if (Pipe.this.consumerIoControl instanceof NHttpServerConnection) {
                                if (((NHttpServerConnection)Pipe.this.consumerIoControl).isStale()) {
                                    Pipe.this.isStale = true;
                                    Pipe.this.writeCondition.signalAll();
                                }
                            } else if (Pipe.this.consumerIoControl instanceof NHttpClientConnection && ((NHttpClientConnection)Pipe.this.consumerIoControl).isStale()) {
                                Pipe.this.isStale = true;
                                Pipe.this.writeCondition.signalAll();
                            }
                            Pipe.this.awaitInterrupted = Pipe.this.writeCondition.await(socketTimeOut, TimeUnit.MILLISECONDS);
                            if (Pipe.this.awaitInterrupted) continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    throw new IOException("Interrupted while flushing the content buffer");
                }
            }
            finally {
                Pipe.this.lock.unlock();
            }
        }
    }

    private class ByteBufferInputStream
    extends InputStream {
        private ByteBufferInputStream() {
        }

        @Override
        public int read() throws IOException {
            Pipe.this.lock.lock();
            try {
                if (!Pipe.this.hasData(Pipe.this.buffer)) {
                    this.waitForData();
                    if (Pipe.this.producerError) {
                        int n = -1;
                        return n;
                    }
                }
                if (this.isEndOfStream()) {
                    int n = -1;
                    return n;
                }
                int n = Pipe.this.buffer.get() & 0xFF;
                return n;
            }
            finally {
                Pipe.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                return 0;
            }
            Pipe.this.lock.lock();
            try {
                if (!Pipe.this.hasData(Pipe.this.buffer)) {
                    this.waitForData();
                    if (Pipe.this.producerError) {
                        int n = -1;
                        return n;
                    }
                }
                if (this.isEndOfStream()) {
                    int n = -1;
                    return n;
                }
                Pipe.this.setOutputMode(Pipe.this.buffer);
                int chunk = len;
                if (chunk > Pipe.this.buffer.remaining()) {
                    chunk = Pipe.this.buffer.remaining();
                }
                Pipe.this.buffer.get(b, off, chunk);
                int n = chunk;
                return n;
            }
            finally {
                Pipe.this.lock.unlock();
            }
        }

        private void waitForData() throws IOException {
            Pipe.this.lock.lock();
            try {
                try {
                    while (!Pipe.this.hasData(Pipe.this.buffer) && !Pipe.this.producerCompleted) {
                        if (Pipe.this.producerError) {
                            break;
                        }
                        Pipe.this.producerIoControl.requestInput();
                        Pipe.this.readCondition.await();
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted while waiting for data");
                }
            }
            finally {
                Pipe.this.lock.unlock();
            }
        }

        private boolean isEndOfStream() {
            return !Pipe.this.hasData(Pipe.this.buffer) && Pipe.this.producerCompleted;
        }
    }
}

