/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.util.blob.BlobOutputStream;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.synapse.transport.exceptions.InvalidConfigurationException;
import org.apache.synapse.transport.http.conn.ClientConnFactory;
import org.apache.synapse.transport.http.conn.ProxyConfig;
import org.apache.synapse.transport.http.conn.Scheme;
import org.apache.synapse.transport.nhttp.config.ClientConnFactoryBuilder;
import org.apache.synapse.transport.nhttp.config.ProxyConfigBuilder;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;
import org.apache.synapse.transport.passthru.ClientIODispatch;
import org.apache.synapse.transport.passthru.ConnectCallback;
import org.apache.synapse.transport.passthru.DeliveryAgent;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.ServerWorker;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.StreamInterceptor;
import org.apache.synapse.transport.passthru.TargetHandler;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.connections.TargetConnections;
import org.apache.synapse.transport.passthru.core.PassThroughSenderManager;
import org.apache.synapse.transport.passthru.jmx.MBeanRegistrar;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.apache.synapse.transport.passthru.jmx.TransportView;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.transport.passthru.util.SourceResponseFactory;
import org.apache.synapse.transport.passthru.util.StreamInterceptorsLoader;
import org.wso2.caching.CachingConstants;
import org.wso2.caching.digest.DigestGenerator;

public class PassThroughHttpSender
extends AbstractHandler
implements TransportSender {
    protected Log log;
    private DefaultConnectingIOReactor ioReactor;
    private TargetHandler handler;
    private ClientIODispatch ioEventDispatch;
    private ClientConnFactory connFactory;
    private DeliveryAgent deliveryAgent;
    private Scheme scheme;
    private TargetConfiguration targetConfiguration;
    private ProxyConfig proxyConfig;
    private TargetConnections targetConnections;
    private volatile int state = 0;
    private String namePrefix;
    private DigestGenerator digestGenerator = CachingConstants.DEFAULT_XML_IDENTIFIER;
    private ConfigurationContext configurationContext;
    private List<StreamInterceptor> interceptors;

    public PassThroughHttpSender() {
        this.log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    }

    protected Scheme getScheme() {
        return new Scheme("http", 80, false);
    }

    protected ClientConnFactoryBuilder initConnFactoryBuilder(TransportOutDescription transportOut, ConfigurationContext configurationContext) throws AxisFault {
        return new ClientConnFactoryBuilder(transportOut, configurationContext);
    }

    public void init(ConfigurationContext configurationContext, TransportOutDescription transportOutDescription) throws AxisFault {
        this.log.info((Object)"Initializing Pass-through HTTP/S Sender...");
        this.configurationContext = configurationContext;
        this.namePrefix = transportOutDescription.getName().toUpperCase(Locale.US);
        this.scheme = this.getScheme();
        WorkerPool workerPool = null;
        Object obj = configurationContext.getProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL");
        if (obj != null) {
            workerPool = (WorkerPool)obj;
        }
        PassThroughTransportMetricsCollector metrics = new PassThroughTransportMetricsCollector(false, this.scheme.getName());
        TransportView view = new TransportView(null, this, metrics, null);
        MBeanRegistrar.getInstance().registerMBean(view, "Transport", "passthru-" + this.namePrefix.toLowerCase() + "-sender");
        this.proxyConfig = new ProxyConfigBuilder().build(transportOutDescription);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.proxyConfig.logProxyConfig());
        }
        this.targetConfiguration = new TargetConfiguration(configurationContext, (ParameterInclude)transportOutDescription, workerPool, metrics, this.proxyConfig.createProxyAuthenticator());
        this.targetConfiguration.build();
        PassThroughSenderManager.registerPassThroughHttpSender(this);
        configurationContext.setProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL", (Object)this.targetConfiguration.getWorkerPool());
        ClientConnFactoryBuilder connFactoryBuilder = this.initConnFactoryBuilder(transportOutDescription, configurationContext);
        this.connFactory = connFactoryBuilder.createConnFactory(this.targetConfiguration.getHttpParams());
        try {
            String prefix = this.namePrefix + "-Sender I/O dispatcher";
            this.ioReactor = new DefaultConnectingIOReactor(this.targetConfiguration.getIOReactorConfig(), (ThreadFactory)new NativeThreadFactory(new ThreadGroup(prefix + " Thread Group"), prefix));
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    PassThroughHttpSender.this.log.warn((Object)("System may be unstable: " + PassThroughHttpSender.this.namePrefix + " ConnectingIOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    PassThroughHttpSender.this.log.warn((Object)("System may be unstable: " + PassThroughHttpSender.this.namePrefix + " ConnectingIOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOReactorException e) {
            this.handleException("Error starting " + this.namePrefix + " ConnectingIOReactor", (Exception)((Object)e));
        }
        ConnectCallback connectCallback = new ConnectCallback();
        this.targetConnections = new TargetConnections((ConnectingIOReactor)this.ioReactor, this.targetConfiguration, connectCallback);
        this.targetConfiguration.setConnections(this.targetConnections);
        this.deliveryAgent = new DeliveryAgent(this.targetConfiguration, this.targetConnections, this.proxyConfig);
        connectCallback.setDeliveryAgent(this.deliveryAgent);
        this.interceptors = StreamInterceptorsLoader.getInterceptors();
        this.handler = new TargetHandler(this.deliveryAgent, this.connFactory, this.targetConfiguration, this.interceptors);
        this.ioEventDispatch = new ClientIODispatch(this.handler, this.connFactory);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PassThroughHttpSender.this.ioReactor.execute((IOEventDispatch)PassThroughHttpSender.this.ioEventDispatch);
                }
                catch (Exception ex) {
                    PassThroughHttpSender.this.log.fatal((Object)("Exception encountered in the " + PassThroughHttpSender.this.namePrefix + " Sender. No more connections will be initiated by this transport"), (Throwable)ex);
                }
                PassThroughHttpSender.this.log.info((Object)(PassThroughHttpSender.this.namePrefix + " Sender shutdown"));
            }
        }, "PassThrough" + this.namePrefix + "Sender");
        t.start();
        this.state = 1;
        this.log.info((Object)("Pass-through " + this.namePrefix + " Sender started..."));
    }

    public void cleanup(MessageContext messageContext) throws AxisFault {
    }

    public void stop() {
        try {
            this.ioReactor.shutdown();
        }
        catch (IOException e) {
            this.log.error((Object)"Error shutting down the PassThroughHttpSender", (Throwable)e);
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        EndpointReference epr;
        PassThroughTransportUtils.removeUnwantedHeaders(msgContext, this.targetConfiguration);
        if (AddressingHelper.isReplyRedirected((MessageContext)msgContext) && !msgContext.getReplyTo().hasNoneAddress()) {
            msgContext.setProperty("IGNORE_SC_ACCEPTED", (Object)"true");
        }
        if ((epr = PassThroughTransportUtils.getDestinationEPR(msgContext)) != null) {
            if (!epr.hasNoneAddress()) {
                if (msgContext.getProperty("pass-through.pipe") == null) {
                    Pipe pipe = new Pipe(this.targetConfiguration.getBufferFactory().getBuffer(), "Test", this.targetConfiguration);
                    msgContext.setProperty("pass-through.pipe", (Object)pipe);
                    msgContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
                }
                boolean forceContentLength = msgContext.isPropertyTrue("FORCE_HTTP_CONTENT_LENGTH");
                boolean forceContentLengthCopy = msgContext.isPropertyTrue("COPY_CONTENT_LENGTH_FROM_INCOMING");
                if (forceContentLength && forceContentLengthCopy && msgContext.getProperty("ORGINAL_CONTEN_LENGTH") != null) {
                    msgContext.setProperty("PASSTROUGH_MESSAGE_LENGTH", (Object)Long.parseLong((String)msgContext.getProperty("ORGINAL_CONTEN_LENGTH")));
                }
                this.sendRequestContent(msgContext, epr);
            } else {
                this.handleException("Cannot send message to http://www.w3.org/2005/08/addressing/none");
            }
        } else if (msgContext.getProperty("OutTransportInfo") != null) {
            if (msgContext.getProperty("OutTransportInfo") instanceof ServerWorker) {
                try {
                    this.submitResponse(msgContext);
                }
                catch (Exception e) {
                    this.handleException("Failed to submit the response", e);
                }
            } else {
                this.sendUsingOutputStream(msgContext);
            }
        } else {
            this.handleException("No valid destination EPR to send message");
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void sendUsingOutputStream(MessageContext msgContext) throws AxisFault {
        OMOutputFormat format = NhttpUtil.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
        OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
        if (msgContext.isServerSide()) {
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            if (transportInfo != null) {
                transportInfo.setContentType(messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
            } else {
                throw new AxisFault("OutTransportInfo has not been set");
            }
        }
        try {
            messageFormatter.writeTo(msgContext, format, out, false);
            out.close();
        }
        catch (IOException e) {
            this.handleException("IO Error sending response message", e);
        }
    }

    public void addPreserveHttpHeader(String headerName) {
        this.targetConfiguration.getPreserveHttpHeaders().add(headerName.toUpperCase());
    }

    public void removePreserveHttpHeader(String headerName) {
        this.targetConfiguration.getPreserveHttpHeaders().remove(headerName.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForReady(MessageContext msgContext) {
        MessageContext messageContext = msgContext;
        synchronized (messageContext) {
            while (!Boolean.TRUE.equals(msgContext.getProperty("WAIT_BUILDER_IN_STREAM_COMPLETE")) && !Boolean.TRUE.equals(msgContext.getProperty("PASSTHRU_CONNECT_ERROR"))) {
                try {
                    msgContext.wait();
                }
                catch (InterruptedException e) {
                    this.log.error((Object)"Interrupted while waiting for passthru connection..", (Throwable)e);
                }
            }
        }
        return !Boolean.TRUE.equals(msgContext.getProperty("PASSTHRU_CONNECT_ERROR"));
    }

    private void sendRequestContent(MessageContext msgContext, EndpointReference epr) throws AxisFault {
        if ("GET".equals(msgContext.getProperty("HTTP_METHOD")) || RelayUtils.isDeleteRequestWithoutPayload(msgContext)) {
            RelayUtils.discardMessage(msgContext);
        }
        if (Boolean.TRUE.equals(msgContext.getProperty("message.builder.invoked"))) {
            String disableChunking = (String)msgContext.getProperty("DISABLE_CHUNKING");
            String forceHttp10 = (String)msgContext.getProperty("FORCE_HTTP_1.0");
            Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
            OutputStream out = null;
            MessageFormatter formatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
            OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(msgContext);
            if ("true".equals(disableChunking) || "true".equals(forceHttp10)) {
                try {
                    OverflowBlob overflowBlob = this.setStreamAsTempData(formatter, msgContext, format);
                    long messageSize = overflowBlob.getLength();
                    msgContext.setProperty("PASSTROUGH_MESSAGE_LENGTH", (Object)messageSize);
                    if (!this.deliveryAgent.submit(msgContext, epr)) {
                        return;
                    }
                    if (!this.waitForReady(msgContext)) {
                        return;
                    }
                    out = (OutputStream)msgContext.getProperty("BUILDER_OUTPUT_STREAM");
                    if (out != null) {
                        if (this.ignoreMessageBody(msgContext, pipe)) {
                            return;
                        }
                        overflowBlob.writeTo(out);
                        if (pipe.isStale) {
                            throw new IOException("Target Connection is stale..");
                        }
                        pipe.setSerializationComplete(true);
                    }
                }
                catch (IOException e) {
                    this.handleException("IO while building message", e);
                }
            } else {
                if (!this.deliveryAgent.submit(msgContext, epr)) {
                    return;
                }
                if (!this.waitForReady(msgContext)) {
                    return;
                }
                out = (OutputStream)msgContext.getProperty("BUILDER_OUTPUT_STREAM");
                if (out != null) {
                    if (this.ignoreMessageBody(msgContext, pipe)) {
                        return;
                    }
                    formatter.writeTo(msgContext, format, out, false);
                    if (pipe.isStale) {
                        this.handleException("IO while building message", new IOException("Target Connection is stale.."));
                    }
                    pipe.setSerializationComplete(true);
                }
            }
        } else if (!this.deliveryAgent.submit(msgContext, epr)) {
            return;
        }
    }

    private boolean ignoreMessageBody(MessageContext msgContext, Pipe pipe) {
        if ("GET".equals(msgContext.getProperty("HTTP_METHOD")) || RelayUtils.isDeleteRequestWithoutPayload(msgContext)) {
            pipe.setSerializationComplete(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OverflowBlob setStreamAsTempData(MessageFormatter messageFormatter, MessageContext msgContext, OMOutputFormat format) throws IOException {
        OverflowBlob serialized = new OverflowBlob(256, 4096, "http-nio_", ".dat");
        try (BlobOutputStream out = serialized.getOutputStream();){
            messageFormatter.writeTo(msgContext, format, (OutputStream)out, false);
        }
        return serialized;
    }

    public void submitResponse(MessageContext msgContext) throws IOException, HttpException {
        ProtocolState state;
        Integer errorCode;
        SourceRequest sourceRequest;
        SourceConfiguration sourceConfiguration = (SourceConfiguration)msgContext.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION");
        NHttpServerConnection conn = (NHttpServerConnection)msgContext.getProperty("pass-through.Source-Connection");
        if (conn == null) {
            ServerWorker serverWorker = (ServerWorker)msgContext.getProperty("OutTransportInfo");
            if (serverWorker != null) {
                MessageContext requestContext = serverWorker.getRequestContext();
                conn = (NHttpServerConnection)requestContext.getProperty("pass-through.Source-Connection");
                sourceConfiguration = (SourceConfiguration)requestContext.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION");
            } else {
                throw new IllegalStateException("Unable to correlate the response to a request");
            }
        }
        if (msgContext.getProperty("HTTP_ETAG") != null && ((Boolean)msgContext.getProperty("HTTP_ETAG")).booleanValue()) {
            try {
                RelayUtils.buildMessage(msgContext);
            }
            catch (IOException e) {
                this.handleException("IO Error occurred while building the message", e);
            }
            catch (XMLStreamException e) {
                this.handleException("XML Error occurred while building the message", e);
            }
            String hash = this.digestGenerator.getDigest(msgContext);
            Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
            headers.put("ETag", "\"" + hash + "\"");
        }
        if (msgContext.getProperty("enableMTOM") != null && !Boolean.TRUE.equals(msgContext.getProperty("message.builder.invoked"))) {
            try {
                RelayUtils.buildMessage(msgContext);
            }
            catch (IOException e) {
                this.handleException("IO Error occurred while building the message", e);
            }
            catch (XMLStreamException e) {
                this.handleException("XML Error occurred while building the message", e);
            }
        }
        if ((sourceRequest = SourceContext.getRequest((NHttpConnection)conn)) == null) {
            if (conn.getContext().getAttribute("SOURCE_CONNECTION_DROPPED") != null && ((Boolean)conn.getContext().getAttribute("SOURCE_CONNECTION_DROPPED")).booleanValue()) {
                return;
            }
            this.log.warn((Object)("Trying to submit a response to an already closed connection : " + conn));
            return;
        }
        SourceResponse sourceResponse = SourceResponseFactory.create(msgContext, sourceRequest, sourceConfiguration);
        sourceResponse.checkResponseChunkDisable(msgContext);
        conn.getContext().setAttribute("RESPONSE_MESSAGE_CONTEXT", (Object)msgContext);
        SourceContext.setResponse((NHttpConnection)conn, sourceResponse);
        Boolean noEntityBody = (Boolean)msgContext.getProperty("NO_ENTITY_BODY");
        Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
        if (noEntityBody == null || !noEntityBody.booleanValue() || pipe != null) {
            if (pipe == null) {
                pipe = new Pipe(sourceConfiguration.getBufferFactory().getBuffer(), "Test", sourceConfiguration);
                msgContext.setProperty("pass-through.pipe", (Object)pipe);
                msgContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
            }
            pipe.attachConsumer((IOControl)conn);
            sourceResponse.connect(pipe);
        }
        if ((errorCode = (Integer)msgContext.getProperty("ERROR_CODE")) != null) {
            sourceResponse.setStatus(502);
            SourceContext.get((NHttpConnection)conn).setShutDown(true);
        }
        if ((state = SourceContext.getState((NHttpConnection)conn)) != null && state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
            OutputStream out;
            boolean noEntityBodyResponse = false;
            if (noEntityBody != null && Boolean.TRUE == noEntityBody && pipe != null) {
                out = pipe.getOutputStream();
                out.write(new byte[0]);
                pipe.setRawSerializationComplete(true);
                out.close();
                noEntityBodyResponse = true;
            }
            if (!noEntityBodyResponse && msgContext.isPropertyTrue("message.builder.invoked") && pipe != null) {
                out = pipe.getOutputStream();
                if ("true".equals(msgContext.getProperty("enableMTOM")) || "true".equals(msgContext.getProperty("enableSwA"))) {
                    Object contentType = msgContext.getProperty("ContentType");
                    if (Objects.isNull(contentType) || !((String)contentType).trim().startsWith("multipart/related")) {
                        msgContext.setProperty("ContentType", (Object)"multipart/related");
                    }
                    msgContext.setProperty("messageType", (Object)"multipart/related");
                }
                MessageFormatter formatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
                OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(msgContext);
                this.setContentType(msgContext, sourceResponse, formatter, format, sourceConfiguration);
                try {
                    formatter.writeTo(msgContext, format, out, false);
                }
                catch (RemoteException fault) {
                    IOUtils.closeQuietly((OutputStream)out);
                    throw fault;
                }
                finally {
                    pipe.setSerializationComplete(true);
                }
                out.close();
            }
            conn.requestOutput();
        } else {
            if (errorCode != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.warn((Object)("A Source connection is closed because of an error in target: " + conn));
                }
            } else {
                this.log.debug((Object)("A Source Connection is closed, because source handler is already in the process of writing a response while another response is submitted: " + conn));
            }
            pipe.consumerError();
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        this.log.info((Object)(this.namePrefix + " Sender Paused"));
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        this.state = 1;
        this.log.info((Object)(this.namePrefix + " Sender Resumed"));
    }

    public void maintenanceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.shutdown(millis);
            this.state = 0;
            this.log.info((Object)("Sender shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenence", e);
        }
    }

    private void handleException(String s, Exception e) throws AxisFault {
        this.log.error((Object)s, (Throwable)e);
        throw new AxisFault(s, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        this.log.error((Object)msg);
        throw new AxisFault(msg);
    }

    public void reloadDynamicSSLConfig(TransportOutDescription transport) throws AxisFault {
        this.log.info((Object)"PassThroughHttpSender reloading SSL Config..");
        try {
            ClientConnFactoryBuilder connFactoryBuilder = this.initConnFactoryBuilder(transport, this.configurationContext);
            this.connFactory = connFactoryBuilder.createConnFactory(this.targetConfiguration.getHttpParams());
            this.handler.setConnFactory(this.connFactory);
            this.ioEventDispatch.setConnFactory(this.connFactory);
            this.targetConnections.resetConnectionPool(this.connFactory.getHostList());
            this.log.info((Object)("Pass-through " + this.namePrefix + " Sender updated with Dynamic Configuration Updates ..."));
        }
        catch (InvalidConfigurationException configFault) {
            this.log.error((Object)"Ignoring reload SSL config since there is an invalid configuration.", (Throwable)configFault);
        }
    }

    public void setContentType(MessageContext msgContext, SourceResponse sourceResponse, MessageFormatter formatter, OMOutputFormat format, SourceConfiguration sourceConfiguration) {
        String contentTypeValueInMsgCtx;
        if (sourceConfiguration.isPreserveHttpHeader("Content-Type")) {
            return;
        }
        Object contentTypeInMsgCtx = msgContext.getProperty("ContentType");
        boolean isContentTypeSetFromMsgCtx = false;
        if (contentTypeInMsgCtx != null && !(contentTypeValueInMsgCtx = contentTypeInMsgCtx.toString()).contains("multipart/related") && !contentTypeValueInMsgCtx.contains("multipart/form-data")) {
            String encoding;
            if (format != null && contentTypeValueInMsgCtx.indexOf(HTTPConstants.CHAR_SET_ENCODING) == -1 && !"false".equals(msgContext.getProperty("setCharacterEncoding")) && (encoding = format.getCharSetEncoding()) != null) {
                contentTypeValueInMsgCtx = contentTypeValueInMsgCtx + "; charset=" + encoding;
            }
            sourceResponse.removeHeader("Content-Type");
            sourceResponse.addHeader("Content-Type", contentTypeValueInMsgCtx);
            isContentTypeSetFromMsgCtx = true;
        }
        if (!isContentTypeSetFromMsgCtx) {
            sourceResponse.removeHeader("Content-Type");
            sourceResponse.addHeader("Content-Type", formatter.getContentType(msgContext, format, msgContext.getSoapAction()));
        }
    }
}

