/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.tracker.AxisServiceFilter;
import org.apache.axis2.transport.base.tracker.AxisServiceTracker;
import org.apache.axis2.transport.base.tracker.AxisServiceTrackerListener;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.synapse.transport.http.conn.Scheme;
import org.apache.synapse.transport.http.conn.ServerConnFactory;
import org.apache.synapse.transport.nhttp.config.ServerConnFactoryBuilder;
import org.apache.synapse.transport.passthru.SourceHandler;
import org.apache.synapse.transport.passthru.StreamInterceptor;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.core.PassThroughListeningIOReactorManager;
import org.apache.synapse.transport.passthru.core.PassThroughSharedListenerConfiguration;
import org.apache.synapse.transport.passthru.jmx.MBeanRegistrar;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.apache.synapse.transport.passthru.jmx.TransportView;
import org.apache.synapse.transport.passthru.util.ActiveConnectionMonitor;
import org.apache.synapse.transport.passthru.util.SessionContextUtil;
import org.apache.synapse.transport.passthru.util.StreamInterceptorsLoader;

public class PassThroughHttpListener
implements TransportListener {
    protected Log log = LogFactory.getLog(this.getClass());
    private DefaultListeningIOReactor ioReactor;
    private PassThroughListeningIOReactorManager passThroughListeningIOReactorManager;
    private SourceHandler handler;
    private ServerConnFactory connFactory;
    private Scheme scheme;
    private SourceConfiguration sourceConfiguration = null;
    private Map<String, String> serviceNameToEPRMap = new HashMap<String, String>();
    private Map<String, String> eprToServiceNameMap = new HashMap<String, String>();
    private volatile int state = 0;
    private String namePrefix;
    private final ScheduledExecutorService activeConnectionMonitorScheduler = Executors.newSingleThreadScheduledExecutor();
    public static final long ACTIVE_CONNECTION_MONITOR_DELAY = 1000L;
    private AxisServiceTracker serviceTracker;
    private TransportInDescription pttInDescription;
    private ConfigurationContext configurationContext;
    private List<StreamInterceptor> interceptors;
    private int operatingPort;

    protected Scheme initScheme() {
        return new Scheme("http", 80, false);
    }

    protected ServerConnFactoryBuilder initConnFactoryBuilder(TransportInDescription transportIn, HttpHost host, ConfigurationContext configurationContext) throws AxisFault {
        return new ServerConnFactoryBuilder(transportIn, host, configurationContext);
    }

    public void init(ConfigurationContext cfgCtx, TransportInDescription transportInDescription) throws AxisFault {
        this.log.info((Object)"Initializing Pass-through HTTP/S Listener...");
        this.configurationContext = cfgCtx;
        this.pttInDescription = transportInDescription;
        this.namePrefix = transportInDescription.getName().toUpperCase(Locale.US);
        this.scheme = this.initScheme();
        int portOffset = Integer.parseInt(System.getProperty("portOffset", "0"));
        Parameter portParam = transportInDescription.getParameter("port");
        int port = Integer.parseInt(portParam.getValue().toString());
        this.operatingPort = port + portOffset;
        portParam.setValue((Object)String.valueOf(this.operatingPort));
        portParam.getParameterElement().setText(String.valueOf(this.operatingPort));
        System.setProperty(transportInDescription.getName() + ".nio.port", String.valueOf(this.operatingPort));
        Object obj = cfgCtx.getProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL");
        WorkerPool workerPool = null;
        if (obj != null) {
            workerPool = (WorkerPool)obj;
        }
        PassThroughTransportMetricsCollector metrics = new PassThroughTransportMetricsCollector(true, this.scheme.getName());
        TransportView view = new TransportView(this, null, metrics, null);
        MBeanRegistrar.getInstance().registerMBean(view, "Transport", "passthru-" + this.namePrefix.toLowerCase() + "-receiver");
        this.sourceConfiguration = new SourceConfiguration(cfgCtx, transportInDescription, this.scheme, workerPool, metrics);
        this.sourceConfiguration.build();
        HttpHost host = new HttpHost(this.sourceConfiguration.getHostname(), this.sourceConfiguration.getPort(), this.sourceConfiguration.getScheme().getName());
        ServerConnFactoryBuilder connFactoryBuilder = this.initConnFactoryBuilder(transportInDescription, host, cfgCtx);
        this.connFactory = connFactoryBuilder.build(this.sourceConfiguration.getHttpParams());
        this.interceptors = StreamInterceptorsLoader.getInterceptors();
        this.handler = new SourceHandler(this.sourceConfiguration, this.interceptors);
        this.passThroughListeningIOReactorManager = PassThroughListeningIOReactorManager.getInstance();
        String prefix = this.namePrefix + "-Listener I/O dispatcher";
        try {
            this.ioReactor = (DefaultListeningIOReactor)this.passThroughListeningIOReactorManager.initIOReactor(this.operatingPort, this.handler, new PassThroughSharedListenerConfiguration((ThreadFactory)new NativeThreadFactory(new ThreadGroup(prefix + " thread group"), prefix), this.connFactory, this.sourceConfiguration));
        }
        catch (IOReactorException e) {
            this.handleException("Error initiating " + this.namePrefix + " ListeningIOReactor", (Exception)((Object)e));
        }
        Map o = (Map)cfgCtx.getProperty("service.epr.map");
        if (o != null) {
            this.eprToServiceNameMap = o;
        } else {
            this.eprToServiceNameMap = new HashMap<String, String>();
            cfgCtx.setProperty("service.epr.map", this.eprToServiceNameMap);
        }
        cfgCtx.setProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL", (Object)this.sourceConfiguration.getWorkerPool());
        this.serviceTracker = new AxisServiceTracker(cfgCtx.getAxisConfiguration(), new AxisServiceFilter(){

            public boolean matches(AxisService service) {
                return !service.getName().startsWith("__") && BaseUtils.isUsingTransport((AxisService)service, (String)PassThroughHttpListener.this.pttInDescription.getName());
            }
        }, new AxisServiceTrackerListener(){

            public void serviceAdded(AxisService service) {
                PassThroughHttpListener.this.addToServiceURIMap(service);
            }

            public void serviceRemoved(AxisService service) {
                PassThroughHttpListener.this.removeServiceFfromURIMap(service);
            }
        });
    }

    public void start() throws AxisFault {
        this.serviceTracker.start();
        this.log.info((Object)("Starting Pass-through " + this.namePrefix + " Listener..."));
        String prefix = this.namePrefix + "-Listener I/O dispatcher";
        this.passThroughListeningIOReactorManager.startIOReactor((ListeningIOReactor)this.ioReactor, this.passThroughListeningIOReactorManager.getServerIODispatch(this.operatingPort), prefix);
        this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

            public boolean handle(IOException ioException) {
                PassThroughHttpListener.this.log.warn((Object)("System may be unstable: " + PassThroughHttpListener.this.namePrefix + " ListeningIOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                return true;
            }

            public boolean handle(RuntimeException runtimeException) {
                PassThroughHttpListener.this.log.warn((Object)("System may be unstable: " + PassThroughHttpListener.this.namePrefix + " ListeningIOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                return true;
            }
        });
        if (this.sourceConfiguration.getHttpGetRequestProcessor() != null) {
            this.sourceConfiguration.getHttpGetRequestProcessor().init(this.sourceConfiguration.getConfigurationContext(), this.handler);
        }
        this.startEndpoints();
        this.state = 1;
    }

    private void startEndpoints() throws AxisFault {
        HashSet<InetSocketAddress> addressSet = new HashSet<InetSocketAddress>();
        addressSet.addAll(this.connFactory.getBindAddresses());
        Parameter bindParam = this.pttInDescription.getParameter("bind-address");
        if (bindParam != null) {
            InetAddress bindAddress;
            try {
                bindAddress = InetAddress.getByName((String)bindParam.getValue());
            }
            catch (UnknownHostException ex) {
                throw AxisFault.makeFault((Throwable)ex);
            }
            if (bindAddress != null) {
                Parameter portParam = this.pttInDescription.getParameter("port");
                int port = Integer.parseInt(portParam.getValue().toString());
                addressSet.add(new InetSocketAddress(bindAddress, port));
            }
        }
        if (PassThroughConfiguration.getInstance().getMaxActiveConnections() != -1) {
            this.addMaxActiveConnectionCountController(PassThroughConfiguration.getInstance().getMaxActiveConnections());
        }
        if (addressSet.isEmpty()) {
            addressSet.add(new InetSocketAddress(Integer.parseInt((String)this.pttInDescription.getParameter("port").getValue())));
        }
        ArrayList addressList = new ArrayList(addressSet);
        Collections.sort(addressList, new Comparator<InetSocketAddress>(){

            @Override
            public int compare(InetSocketAddress a1, InetSocketAddress a2) {
                String s1 = a1.toString();
                String s2 = a2.toString();
                return s1.compareTo(s2);
            }
        });
        for (InetSocketAddress address : addressList) {
            this.passThroughListeningIOReactorManager.startPTTEndpoint(address, this.ioReactor, this.namePrefix);
        }
    }

    private void startSpecificEndpoints(Set<InetSocketAddress> bindAddresses) throws AxisFault {
        if (PassThroughConfiguration.getInstance().getMaxActiveConnections() != -1) {
            this.addMaxActiveConnectionCountController(PassThroughConfiguration.getInstance().getMaxActiveConnections());
        }
        ArrayList<InetSocketAddress> addressList = new ArrayList<InetSocketAddress>(bindAddresses);
        Collections.sort(addressList, new Comparator<InetSocketAddress>(){

            @Override
            public int compare(InetSocketAddress a1, InetSocketAddress a2) {
                String s1 = a1.toString();
                String s2 = a2.toString();
                return s1.compareTo(s2);
            }
        });
        for (InetSocketAddress address : addressList) {
            this.passThroughListeningIOReactorManager.startPTTEndpoint(address, this.ioReactor, this.namePrefix);
        }
    }

    private void handleException(String s, Exception e) throws AxisFault {
        this.log.error((Object)s, (Throwable)e);
        throw new AxisFault(s, (Throwable)e);
    }

    private void addMaxActiveConnectionCountController(int maxActiveConnections) {
        ActiveConnectionMonitor activeConnectionMonitor = new ActiveConnectionMonitor(this.sourceConfiguration.getMetrics(), this.ioReactor, maxActiveConnections);
        this.activeConnectionMonitorScheduler.scheduleWithFixedDelay(activeConnectionMonitor, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        String trailer = "";
        if (serviceName.indexOf(47) != -1) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("/"));
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        if (serviceName.indexOf(46) != -1) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("."));
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        }
        if (this.serviceNameToEPRMap.containsKey(serviceName)) {
            return new EndpointReference(this.sourceConfiguration.getCustomEPRPrefix() + this.serviceNameToEPRMap.get(serviceName) + trailer);
        }
        return new EndpointReference(this.sourceConfiguration.getServiceEPRPrefix() + serviceName + trailer);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String trailer = "";
        boolean isServiceWithCustomURI = this.isServiceWithCustomURI(serviceName);
        if (serviceName.indexOf(47) != -1) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("/"));
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        if (serviceName.indexOf(46) != -1 && !isServiceWithCustomURI) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("."));
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        } else if (isServiceWithCustomURI) {
            serviceName = this.getServiceNameFromServiceWithCustomURI(serviceName);
        }
        EndpointReference[] endpointReferences = new EndpointReference[]{this.serviceNameToEPRMap.containsKey(serviceName) ? new EndpointReference(this.sourceConfiguration.getCustomEPRPrefix() + this.serviceNameToEPRMap.get(serviceName) + trailer) : new EndpointReference(this.sourceConfiguration.getServiceEPRPrefix() + serviceName + trailer)};
        return endpointReferences;
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return SessionContextUtil.createSessionContext(messageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws AxisFault {
        if (this.state == 0) {
            return;
        }
        this.log.info((Object)("Stopping Pass-through " + this.namePrefix + " Listener.."));
        try {
            int wait = PassThroughConfiguration.getInstance().getListenerShutdownWaitTime();
            this.passThroughListeningIOReactorManager.pauseIOReactor(this.operatingPort);
            if (wait > 0) {
                this.log.info((Object)("Waiting " + wait / 1000 + " seconds to cleanup active connections..."));
                Thread.sleep(wait);
                this.passThroughListeningIOReactorManager.shutdownIOReactor(this.operatingPort, wait);
            } else {
                boolean isGracefulShutdownEnabled = Boolean.parseBoolean(System.getProperty("gracefulShutdown", "true"));
                if (isGracefulShutdownEnabled) {
                    long so_timeout = PassThroughConfiguration.getInstance().getIntProperty("http.socket.timeout", 180000).intValue();
                    this.passThroughListeningIOReactorManager.shutdownIOReactor(this.operatingPort, this.sourceConfiguration, so_timeout);
                } else {
                    this.passThroughListeningIOReactorManager.shutdownIOReactor(this.operatingPort);
                }
            }
            this.serviceTracker.stop();
            this.handler.stop();
        }
        catch (IOException e) {
            this.handleException("Error shutting down " + this.namePrefix + " listening IO reactor", e);
        }
        catch (InterruptedException e) {
            this.handleException("Error waiting for connection drain", e);
        }
        finally {
            this.state = 0;
        }
    }

    public void destroy() {
        this.log.info((Object)"Destroying PassThroughHttpListener");
        this.sourceConfiguration.getMetrics().destroy();
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            this.passThroughListeningIOReactorManager.pauseIOReactor(this.operatingPort);
            this.state = 2;
            this.log.info((Object)(this.namePrefix + " Listener Paused"));
        }
        catch (IOException e) {
            this.handleException("Error pausing IOReactor", e);
        }
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        try {
            this.passThroughListeningIOReactorManager.resumeIOReactor(this.operatingPort);
            this.state = 1;
            this.log.info((Object)(this.namePrefix + " Listener Resumed"));
        }
        catch (IOException e) {
            this.handleException("Error resuming IOReactor", e);
        }
    }

    public void reload(TransportInDescription transportIn) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.passThroughListeningIOReactorManager.closeAllPTTListenerEndpoints(this.operatingPort);
        HttpHost host = new HttpHost(this.sourceConfiguration.getHostname(), this.sourceConfiguration.getPort(), this.sourceConfiguration.getScheme().getName());
        ServerConnFactoryBuilder connFactoryBuilder = this.initConnFactoryBuilder(transportIn, host, this.configurationContext);
        this.connFactory = connFactoryBuilder.build(this.sourceConfiguration.getHttpParams());
        this.passThroughListeningIOReactorManager.getServerIODispatch(this.operatingPort).update(this.connFactory);
        this.startEndpoints();
        this.log.info((Object)(this.namePrefix + " Reloaded"));
    }

    public void reloadSpecificEndPoints(TransportInDescription transportIn) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        HttpHost host = new HttpHost(this.sourceConfiguration.getHostname(), this.sourceConfiguration.getPort(), this.sourceConfiguration.getScheme().getName());
        ServerConnFactoryBuilder connFactoryBuilder = this.initConnFactoryBuilder(transportIn, host, this.configurationContext);
        this.connFactory = connFactoryBuilder.build(this.sourceConfiguration.getHttpParams());
        this.passThroughListeningIOReactorManager.closeSpecificPTTListenerEndpoints(this.operatingPort, this.connFactory.getBindAddresses());
        this.passThroughListeningIOReactorManager.getServerIODispatch(this.operatingPort).update(this.connFactory);
        this.startSpecificEndpoints(this.connFactory.getBindAddresses());
        this.log.info((Object)(this.namePrefix + " Reloaded"));
    }

    public void maintenanceShutdown(long milliSecs) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.passThroughListeningIOReactorManager.pauseIOReactor(this.operatingPort);
            this.passThroughListeningIOReactorManager.shutdownIOReactor(this.operatingPort, milliSecs);
            this.state = 0;
            this.serviceTracker.stop();
            this.log.info((Object)("Listener shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenance", e);
        }
    }

    private boolean ignoreService(AxisService service) {
        return service.getName().startsWith("__") || JavaUtils.isTrueExplicitly((Object)service.getParameter("hiddenService"));
    }

    private void addToServiceURIMap(AxisService service) {
        Parameter param = service.getParameter("ServiceURI");
        if (param != null) {
            String uriLocation = param.getValue().toString();
            if (uriLocation.startsWith("/")) {
                uriLocation = uriLocation.substring(1);
            }
            this.serviceNameToEPRMap.put(service.getName(), uriLocation);
            this.eprToServiceNameMap.put(uriLocation, service.getName());
        }
    }

    private void removeServiceFfromURIMap(AxisService service) {
        this.eprToServiceNameMap.remove(this.serviceNameToEPRMap.get(service.getName()));
        this.serviceNameToEPRMap.remove(service.getName());
    }

    private boolean isServiceWithCustomURI(String serviceName) {
        if (this.serviceNameToEPRMap.containsKey(serviceName)) {
            return true;
        }
        if (!serviceName.contains(".")) {
            return false;
        }
        serviceName = serviceName.substring(0, serviceName.lastIndexOf("."));
        return this.isServiceWithCustomURI(serviceName);
    }

    private String getServiceNameFromServiceWithCustomURI(String serviceName) {
        if (this.serviceNameToEPRMap.containsKey(serviceName)) {
            return serviceName;
        }
        serviceName = serviceName.substring(0, serviceName.lastIndexOf("."));
        return this.getServiceNameFromServiceWithCustomURI(serviceName);
    }

    public String getTransportName() {
        return this.pttInDescription.getName();
    }

    public void reloadDynamicSSLConfig(TransportInDescription transportInDescription) throws AxisFault {
        this.log.info((Object)"PassThroughHttpListener reloading SSL Config..");
        Parameter oldParameter = transportInDescription.getParameter("SSLProfiles");
        Parameter profilePathParam = transportInDescription.getParameter("dynamicSSLProfilesConfig");
        if (oldParameter != null && profilePathParam != null) {
            transportInDescription.removeParameter(oldParameter);
            this.reloadSpecificEndPoints(transportInDescription);
        }
    }

    private class GenericAxisObserver
    implements AxisObserver {
        private GenericAxisObserver() {
        }

        public void init(AxisConfiguration axisConfig) {
        }

        public void serviceUpdate(AxisEvent event, AxisService service) {
            if (!PassThroughHttpListener.this.ignoreService(service) && BaseUtils.isUsingTransport((AxisService)service, (String)PassThroughHttpListener.this.sourceConfiguration.getInDescription().getName())) {
                switch (event.getEventType()) {
                    case 1: {
                        PassThroughHttpListener.this.addToServiceURIMap(service);
                        System.out.println("SERVICE_DEPLOY");
                        break;
                    }
                    case 0: {
                        PassThroughHttpListener.this.removeServiceFfromURIMap(service);
                        System.out.println("SERVICE_REMOVE");
                        break;
                    }
                    case 3: {
                        PassThroughHttpListener.this.addToServiceURIMap(service);
                        System.out.println("SERVICE_START");
                        break;
                    }
                    case 2: {
                        PassThroughHttpListener.this.removeServiceFfromURIMap(service);
                        System.out.println("SERVICE_STOP");
                    }
                }
            }
        }

        public void moduleUpdate(AxisEvent event, AxisModule module) {
        }

        public void addParameter(Parameter parameter) throws AxisFault {
        }

        public void removeParameter(Parameter parameter) throws AxisFault {
        }

        public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        }

        public Parameter getParameter(String name) {
            return null;
        }

        public ArrayList<Parameter> getParameters() {
            return null;
        }

        public boolean isParameterLocked(String parameterName) {
            return false;
        }

        public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
        }
    }
}

