/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.DefaultStreamInterceptor;

public class LoggingStreamInterceptor
extends DefaultStreamInterceptor {
    private static final Log log = LogFactory.getLog(LoggingStreamInterceptor.class);
    private static final String INPUT = ">>>";
    private static final String OUTPUT = "<<<";
    private String charset = Charset.defaultCharset().toString();
    private boolean enableInterception = false;

    @Override
    public boolean interceptSourceRequest(MessageContext axisCtx) {
        return this.enableInterception;
    }

    @Override
    public boolean sourceRequest(ByteBuffer buffer, MessageContext ctx) {
        this.printStream(buffer, INPUT);
        return true;
    }

    @Override
    public boolean interceptTargetRequest(MessageContext axisCtx) {
        return this.enableInterception;
    }

    @Override
    public void targetRequest(ByteBuffer buffer, MessageContext ctx) {
        this.printStream(buffer, OUTPUT);
    }

    @Override
    public boolean interceptTargetResponse(MessageContext axisCtx) {
        return this.enableInterception;
    }

    @Override
    public boolean targetResponse(ByteBuffer buffer, MessageContext ctx) {
        this.printStream(buffer, INPUT);
        return true;
    }

    @Override
    public boolean interceptSourceResponse(MessageContext axisCtx) {
        return this.enableInterception;
    }

    @Override
    public void sourceResponse(ByteBuffer buffer, MessageContext ctx) {
        this.printStream(buffer, OUTPUT);
    }

    private void printStream(ByteBuffer stream, String direction) {
        Charset charsetValue = Charset.forName(this.charset);
        String text = charsetValue.decode(stream).toString();
        log.info((Object)(direction + " " + text));
    }

    public void setCharset(String charset) {
        this.charset = charset;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Charset : " + charset));
        }
    }

    public void setEnableInterception(boolean enableInterception) {
        this.enableInterception = enableInterception;
    }
}

