/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.http.conn.ProxyConfig;
import org.apache.synapse.transport.http.conn.SynapseDebugInfoHolder;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.TargetErrorHandler;
import org.apache.synapse.transport.passthru.TargetRequest;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.connections.TargetConnections;
import org.apache.synapse.transport.passthru.util.TargetRequestFactory;

public class DeliveryAgent {
    private static final Log log = LogFactory.getLog(DeliveryAgent.class);
    private Map<HttpRoute, Queue<MessageContext>> waitingMessages = new ConcurrentHashMap<HttpRoute, Queue<MessageContext>>();
    private TargetConnections targetConnections;
    private TargetConfiguration targetConfiguration;
    private ProxyConfig proxyConfig;
    private int maxWaitingMessages;
    private TargetErrorHandler targetErrorHandler;
    private Lock lock = new ReentrantLock();

    public DeliveryAgent(TargetConfiguration targetConfiguration, TargetConnections targetConnections, ProxyConfig proxyConfig) {
        this.targetConfiguration = targetConfiguration;
        this.targetConnections = targetConnections;
        this.proxyConfig = proxyConfig;
        this.targetErrorHandler = new TargetErrorHandler(targetConfiguration);
        PassThroughConfiguration conf = PassThroughConfiguration.getInstance();
        this.maxWaitingMessages = conf.getIntProperty("http.max.messages.per.host.port", Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submit(MessageContext msgContext, EndpointReference epr) throws AxisFault {
        try {
            URL url;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Submitting request for MessageID: " + msgContext.getMessageID()));
            }
            String scheme = (url = new URL(epr.getAddress())).getProtocol() != null ? url.getProtocol() : "http";
            String hostname = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                if ("http".equals(scheme)) {
                    port = 80;
                } else if ("https".equals(scheme)) {
                    port = 443;
                }
            }
            HttpHost target = new HttpHost(hostname, port, scheme);
            boolean secure = "https".equalsIgnoreCase(target.getSchemeName());
            HttpHost proxy = this.proxyConfig.selectProxy(target);
            msgContext.setProperty("PROXY_PROFILE_TARGET_HOST", (Object)target.getHostName());
            HttpRoute route = proxy != null ? new HttpRoute(target, null, proxy, secure) : new HttpRoute(target, null, secure);
            Queue<MessageContext> queue = null;
            NHttpClientConnection conn = null;
            this.lock.lock();
            try {
                queue = this.waitingMessages.get(route);
                if (queue == null) {
                    queue = new ConcurrentLinkedQueue<MessageContext>();
                    this.waitingMessages.put(route, queue);
                }
                if (queue.size() >= this.maxWaitingMessages) {
                    msgContext.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
                    log.warn((Object)"Delivery agent queue length exceeds the maximum number of waiting messages");
                    if (msgContext != null) {
                        this.targetErrorHandler.handleError(msgContext, 101504, "Number of queued messages exceeds the limit", null, ProtocolState.REQUEST_READY);
                    }
                    boolean bl = false;
                    return bl;
                }
                queue.add(msgContext);
                conn = this.targetConnections.getConnection(route, msgContext, this.targetErrorHandler, queue);
                if (conn == null && msgContext != null && "true".equalsIgnoreCase((String)msgContext.getProperty("CONNECTION_LIMIT_EXCEEDS"))) {
                    msgContext.removeProperty("CONNECTION_LIMIT_EXCEEDS");
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (conn == null) return true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connection found from pool for MessageID: " + msgContext.getMessageID() + ", conn: " + conn.toString()));
            }
            conn.resetInput();
            conn.resetOutput();
            MessageContext messageContext = queue.poll();
            if (messageContext == null) return true;
            this.tryNextMessage(messageContext, route, conn);
            return true;
        }
        catch (MalformedURLException e) {
            this.handleException("Malformed URL in the target EPR", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorConnecting(HttpRoute route, int errorCode, String message, Exception exceptionToRaise) {
        Queue<MessageContext> queue = this.waitingMessages.get(route);
        if (queue != null) {
            MessageContext msgCtx = queue.poll();
            if (msgCtx != null) {
                msgCtx.setProperty("_INTERNAL_EXCEPTION_ORIGIN", (Object)"TARGET_ERROR_HANDLER");
                this.targetErrorHandler.handleError(msgCtx, errorCode, "Error connecting to the back end", exceptionToRaise, ProtocolState.REQUEST_READY);
                MessageContext messageContext = msgCtx;
                synchronized (messageContext) {
                    msgCtx.setProperty("WAIT_BUILDER_IN_STREAM_COMPLETE", (Object)Boolean.TRUE);
                    msgCtx.notifyAll();
                }
            }
        } else {
            throw new IllegalStateException("Queue cannot be null for: " + route);
        }
    }

    public void errorConnecting(HttpRoute route, int errorCode, String message) {
        this.errorConnecting(route, errorCode, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(HttpRoute route, NHttpClientConnection conn) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection established conn: " + conn.toString()));
        }
        Queue<MessageContext> queue = null;
        this.lock.lock();
        try {
            queue = this.waitingMessages.get(route);
        }
        finally {
            this.lock.unlock();
        }
        while (queue.size() > 0) {
            if (conn == null) {
                conn = this.targetConnections.getExistingConnection(route);
            }
            if (conn == null) break;
            MessageContext messageContext = queue.poll();
            if (messageContext == null) continue;
            this.tryNextMessage(messageContext, route, conn);
            conn = null;
        }
        if (conn != null && TargetContext.getState((NHttpConnection)conn) == ProtocolState.REQUEST_READY) {
            this.targetConfiguration.getConnections().releaseConnection(conn);
        }
    }

    private void tryNextMessage(MessageContext messageContext, HttpRoute route, NHttpClientConnection conn) {
        if (conn != null) {
            try {
                HttpContext ctx = conn.getContext();
                ctx.setAttribute("correlation_id", messageContext.getProperty("correlation_id"));
                ctx.setAttribute("REQUEST_MESSAGE_CONTEXT", (Object)messageContext);
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_READY);
                TargetContext.get((NHttpConnection)conn).setRequestMsgCtx(messageContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying to send the message, MessageID:" + messageContext.getMessageID() + ", conn:" + conn.toString()));
                }
                this.submitRequest(conn, route, messageContext);
            }
            catch (AxisFault e) {
                log.error((Object)"IO error while sending the request out", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRequest(NHttpClientConnection conn, HttpRoute route, MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Submitting new request MessageID:" + msgContext.getMessageID() + " to the connection: " + conn));
        }
        if (SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            conn.getContext().setAttribute("synapse.wire.log.holder", msgContext.getProperty("synapse.wire.log.holder"));
            conn.getContext().setAttribute("synapse.wire.log.mediator.id", msgContext.getProperty("synapse.wire.log.mediator.id"));
        }
        TargetRequest request = TargetRequestFactory.create(msgContext, route, this.targetConfiguration);
        TargetContext.setRequest((NHttpConnection)conn, request);
        Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
        if (pipe != null) {
            pipe.attachConsumer((IOControl)conn);
            request.connect(pipe);
            if (Boolean.TRUE.equals(msgContext.getProperty("message.builder.invoked"))) {
                MessageContext messageContext = msgContext;
                synchronized (messageContext) {
                    OutputStream out = pipe.getOutputStream();
                    msgContext.setProperty("BUILDER_OUTPUT_STREAM", (Object)out);
                    msgContext.setProperty("WAIT_BUILDER_IN_STREAM_COMPLETE", (Object)Boolean.TRUE);
                    msgContext.notifyAll();
                }
                return;
            }
        }
        conn.requestOutput();
    }

    private void handleException(String s, Exception e) throws AxisFault {
        log.error((Object)s, (Throwable)e);
        throw new AxisFault(s, (Throwable)e);
    }
}

