/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.synapse.transport.passthru.DeliveryAgent;
import org.apache.synapse.transport.passthru.connections.HostConnections;

public class ConnectCallback
implements SessionRequestCallback {
    private static Log log = LogFactory.getLog(ConnectCallback.class);
    private DeliveryAgent deliveryAgent;

    public void completed(SessionRequest request) {
        if (log.isDebugEnabled() && request.getSession() != null && request.getSession().getLocalAddress() != null) {
            log.debug((Object)("Connected to remote address: " + request.getSession().getRemoteAddress() + " from local address: " + request.getSession().getLocalAddress()));
        }
    }

    public void failed(SessionRequest request) {
        HostConnections pool = (HostConnections)request.getAttachment();
        pool.pendingConnectionFailed();
        this.deliveryAgent.errorConnecting(pool.getRoute(), 101503, "Connection Failed", request.getException());
        this.handleError("Connection refused or failed for : " + request.getRemoteAddress());
    }

    public void timeout(SessionRequest request) {
        HostConnections pool = (HostConnections)request.getAttachment();
        pool.pendingConnectionFailed();
        this.deliveryAgent.errorConnecting(pool.getRoute(), 101508, "Connection Timeout");
        this.handleError("Timeout connecting to : " + request.getRemoteAddress());
        request.cancel();
    }

    public void cancelled(SessionRequest request) {
        HostConnections pool = (HostConnections)request.getAttachment();
        pool.pendingConnectionFailed();
        this.deliveryAgent.errorConnecting(pool.getRoute(), 101507, "Connection Cancel");
        this.handleError("Connection cancelled for : " + request.getRemoteAddress());
    }

    private void handleError(String errorMessage) {
        log.warn((Object)errorMessage);
    }

    public void setDeliveryAgent(DeliveryAgent deliveryAgent) {
        this.deliveryAgent = deliveryAgent;
    }
}

