/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.commons.util.ext.TenantInfoInitiator;
import org.apache.synapse.commons.util.ext.TenantInfoInitiatorProvider;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.apache.synapse.transport.passthru.ServerWorker;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.TargetResponse;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;

public class ClientWorker
implements Runnable {
    private Log log = LogFactory.getLog(ClientWorker.class);
    private TargetConfiguration targetConfiguration = null;
    private MessageContext responseMsgCtx = null;
    private TargetResponse response = null;
    private boolean expectEntityBody = true;
    private MessageContext requestMessageContext;

    public ClientWorker(TargetConfiguration targetConfiguration, MessageContext outMsgCtx, TargetResponse response) {
        this(targetConfiguration, outMsgCtx, response, Collections.emptyList());
    }

    public ClientWorker(TargetConfiguration targetConfiguration, MessageContext outMsgCtx, TargetResponse response, List<String> allowedResponseProperties) {
        this.targetConfiguration = targetConfiguration;
        this.response = response;
        this.expectEntityBody = response.isExpectResponseBody();
        this.requestMessageContext = outMsgCtx;
        Map<String, String> headers = response.getHeaders();
        Map excessHeaders = response.getExcessHeaders();
        String oriURL = headers.get("Location");
        if (outMsgCtx.getProperty("pass-through.Source-Connection") != null) {
            ((NHttpServerConnection)outMsgCtx.getProperty("pass-through.Source-Connection")).getContext().setAttribute("CLIENT_WORKER_INIT_TIME", (Object)System.currentTimeMillis());
        }
        if (oriURL != null && response.getStatus() != 302 && response.getStatus() != 301 && response.getStatus() != 201 && response.getStatus() != 303 && response.getStatus() != 307 && !targetConfiguration.isPreserveHttpHeader("Location")) {
            String urlContext = null;
            try {
                URL url = new URL(oriURL);
                urlContext = url.getFile();
            }
            catch (MalformedURLException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Relative URL received for Location : " + oriURL), (Throwable)e);
                }
                urlContext = oriURL;
            }
            headers.remove("Location");
            String prfix = (String)outMsgCtx.getProperty("SERVICE_PREFIX");
            if (prfix != null) {
                if (urlContext != null && urlContext.startsWith("/")) {
                    urlContext = urlContext.substring(1);
                }
                headers.put("Location", prfix + urlContext);
            }
        }
        try {
            this.responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
            if (this.responseMsgCtx != null) {
                this.responseMsgCtx.setSoapAction("");
            }
        }
        catch (AxisFault af) {
            this.log.error((Object)"Error getting IN message context from the operation context", (Throwable)af);
            return;
        }
        if (this.responseMsgCtx == null) {
            if (outMsgCtx.getOperationContext().isComplete()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Error getting IN message context from the operation context. Possibly an RM terminate sequence message");
                }
                return;
            }
            this.responseMsgCtx = new MessageContext();
            this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        }
        this.responseMsgCtx.setProperty("PRE_LOCATION_HEADER", (Object)oriURL);
        this.responseMsgCtx.setProperty("pass-through.Source-Connection", outMsgCtx.getProperty("pass-through.Source-Connection"));
        this.responseMsgCtx.setProperty("PASS_THROUGH_SOURCE_CONFIGURATION", outMsgCtx.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION"));
        this.responseMsgCtx.setProperty("disableAddressingForInMessages", outMsgCtx.getProperty("disableAddressingForInMessages"));
        this.responseMsgCtx.setServerSide(true);
        this.responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
        this.responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
        this.responseMsgCtx.setTransportIn(outMsgCtx.getTransportIn());
        this.responseMsgCtx.setTransportOut(outMsgCtx.getTransportOut());
        this.responseMsgCtx.setProperty("invokedREST", (Object)outMsgCtx.isDoingREST());
        this.responseMsgCtx.setProperty("ORIGINAL_STATUS_CODE", (Object)response.getStatus());
        this.responseMsgCtx.setProperty("HTTP_REASON_PHRASE", (Object)response.getStatusLine());
        Set<Map.Entry<String, String>> headerEntries = response.getHeaders().entrySet();
        TreeMap<String, String> headerMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (Map.Entry<String, String> headerEntry : headerEntries) {
            headerMap.put(headerEntry.getKey(), headerEntry.getValue());
        }
        this.responseMsgCtx.setProperty("TRANSPORT_HEADERS", headerMap);
        this.responseMsgCtx.setProperty("EXCESS_TRANSPORT_HEADERS", (Object)excessHeaders);
        if (response.getStatus() == 202) {
            this.responseMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
            this.responseMsgCtx.setProperty("message.builder.invoked", (Object)Boolean.FALSE);
            this.responseMsgCtx.setProperty("SC_ACCEPTED", (Object)Boolean.TRUE);
        }
        this.responseMsgCtx.setAxisMessage(outMsgCtx.getOperationContext().getAxisOperation().getMessage("In"));
        this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        this.responseMsgCtx.setConfigurationContext(outMsgCtx.getConfigurationContext());
        this.responseMsgCtx.setTo(null);
        this.responseMsgCtx.setProperty("pass-through.pipe", (Object)response.getPipe());
        this.responseMsgCtx.setProperty("pass-through.Target-Response", (Object)response);
        this.responseMsgCtx.setProperty("synapse.wire.log.holder", response.getConnection().getContext().getAttribute("synapse.wire.log.holder"));
        this.responseMsgCtx.setProperty("pass-through.Target-Connection", (Object)response.getConnection());
        this.responseMsgCtx.setProperty("correlation_id", outMsgCtx.getProperty("correlation_id"));
        for (String property : allowedResponseProperties) {
            this.responseMsgCtx.setProperty(property, outMsgCtx.getProperty(property));
        }
        this.responseMsgCtx.setProperty("SYNAPSE_ARTIFACT_TYPE", outMsgCtx.getProperty("SYNAPSE_ARTIFACT_TYPE"));
        response.getConnection().getContext().setAttribute("RESPONSE_MESSAGE_CONTEXT", (Object)this.responseMsgCtx);
    }

    private void initTenantInfo() {
        CustomLogSetter.getInstance().clearThreadLocalContent();
        TenantInfoInitiator tenantInfoInitiator = TenantInfoInitiatorProvider.getTenantInfoInitiator();
        if (tenantInfoInitiator != null) {
            ServerWorker serverWorker;
            SourceRequest sourceRequest;
            if (this.requestMessageContext.getProperty("OutTransportInfo") instanceof ServerWorker && (sourceRequest = (serverWorker = (ServerWorker)this.requestMessageContext.getProperty("OutTransportInfo")).getSourceRequest()) != null) {
                tenantInfoInitiator.initTenantInfo(sourceRequest.getUri());
                return;
            }
            tenantInfoInitiator.initTenantInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initTenantInfo();
        if (this.responseMsgCtx == null) {
            this.cleanup();
            return;
        }
        if (this.responseMsgCtx.getProperty("pass-through.Source-Connection") != null) {
            ((NHttpServerConnection)this.responseMsgCtx.getProperty("pass-through.Source-Connection")).getContext().setAttribute("CLIENT_WORKER_START_TIME", (Object)System.currentTimeMillis());
        }
        try {
            if (this.expectEntityBody) {
                String cType = this.response.getHeader("Content-Type");
                if (cType == null) {
                    cType = this.response.getHeader("Content-Type".toLowerCase());
                }
                String contentType = cType != null ? cType : this.inferContentType();
                this.responseMsgCtx.setProperty("ContentType", (Object)contentType);
                String charSetEnc = BuilderUtil.getCharSetEncoding((String)contentType);
                if (charSetEnc == null) {
                    charSetEnc = "UTF-8";
                }
                if (contentType != null) {
                    this.responseMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)(contentType.indexOf("charset") > 0 ? charSetEnc : "UTF-8"));
                    this.responseMsgCtx.removeProperty("NO_ENTITY_BODY");
                }
                this.responseMsgCtx.setServerSide(false);
                SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
                SOAPEnvelope envelope = fac.getDefaultEnvelope();
                try {
                    this.responseMsgCtx.setEnvelope(envelope);
                }
                catch (AxisFault axisFault) {
                    this.log.error((Object)"Error setting SOAP envelope", (Throwable)axisFault);
                }
                this.responseMsgCtx.setServerSide(true);
            } else {
                this.responseMsgCtx.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
                this.responseMsgCtx.setEnvelope(new SOAP11Factory().getDefaultEnvelope());
            }
            int statusCode = this.response.getStatus();
            this.responseMsgCtx.setProperty("HTTP_SC", (Object)statusCode);
            this.responseMsgCtx.setProperty("HTTP_SC_DESC", (Object)this.response.getStatusLine());
            if (statusCode >= 400) {
                this.responseMsgCtx.setProperty("FAULT_MESSAGE", (Object)"TRUE");
            }
            this.responseMsgCtx.setProperty("NonBlockingTransport", (Object)true);
            try {
                AxisEngine.receive((MessageContext)this.responseMsgCtx);
            }
            catch (AxisFault af) {
                this.log.error((Object)"Fault processing response message through Axis2", (Throwable)af);
                String errorMessage = "Fault processing response message through Axis2: " + af.getMessage();
                this.responseMsgCtx.setProperty("SENDING_FAULT", (Object)Boolean.TRUE);
                this.responseMsgCtx.setProperty("ERROR_CODE", (Object)101510);
                this.responseMsgCtx.setProperty("ERROR_MESSAGE", (Object)errorMessage.split("\n")[0]);
                this.responseMsgCtx.setProperty("ERROR_DETAIL", (Object)JavaUtils.stackToString((Throwable)af));
                this.responseMsgCtx.setProperty("ERROR_EXCEPTION", (Object)af);
                this.responseMsgCtx.getAxisOperation().getMessageReceiver().receive(this.responseMsgCtx);
            }
        }
        catch (AxisFault af) {
            this.log.error((Object)"Fault creating response SOAP envelope", (Throwable)af);
        }
        finally {
            this.cleanup();
        }
    }

    private String inferContentType() {
        Map<String, String> headers = this.response.getHeaders();
        for (String header : headers.keySet()) {
            if (!"Content-Type".equalsIgnoreCase(header)) continue;
            return headers.get(header);
        }
        String cType = this.response.getHeader("content-type");
        if (cType != null) {
            return cType;
        }
        cType = this.response.getHeader("Content-type");
        if (cType != null) {
            return cType;
        }
        Object cTypeProperty = this.responseMsgCtx.getProperty("CONTENT_TYPE");
        if (cTypeProperty != null) {
            return cTypeProperty.toString();
        }
        Parameter cTypeParam = this.targetConfiguration.getConfigurationContext().getAxisConfiguration().getParameter("CONTENT_TYPE");
        if (cTypeParam != null) {
            return cTypeParam.getValue().toString();
        }
        boolean contentLengthHeaderPresent = false;
        String contentLengthHeader = headers.get("Content-Length");
        if (contentLengthHeader != null) {
            contentLengthHeaderPresent = true;
        } else {
            for (String header : headers.keySet()) {
                if (!"Content-Length".equalsIgnoreCase(header)) continue;
                contentLengthHeader = headers.get(header);
                contentLengthHeaderPresent = true;
                break;
            }
        }
        boolean transferEncodingHeaderPresent = headers.containsKey("Transfer-Encoding");
        if (!transferEncodingHeaderPresent) {
            for (String header : headers.keySet()) {
                if (!"Transfer-Encoding".equalsIgnoreCase(header)) continue;
                transferEncodingHeaderPresent = true;
                break;
            }
        }
        if (!contentLengthHeaderPresent && !transferEncodingHeaderPresent || "0".equals(contentLengthHeader)) {
            this.responseMsgCtx.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
            return null;
        }
        return "application/octet-stream";
    }

    private void cleanup() {
        MessageContext.destroyCurrentMessageContext();
        TenantInfoInitiator tenantInfoInitiator = TenantInfoInitiatorProvider.getTenantInfoInitiator();
        if (tenantInfoInitiator != null) {
            tenantInfoInitiator.cleanTenantInfo();
        }
    }
}

