/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.dispatchers.HTTPLocationBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIOperationDispatcher;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.NhttpConstants;

public class RESTUtil {
    private static final Log log = LogFactory.getLog(RESTUtil.class);
    private static RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();
    private static HTTPLocationBasedDispatcher httpLocationBasedDispatcher = new HTTPLocationBasedDispatcher();
    private static RequestURIOperationDispatcher requestURIOperationDispatcher = new RequestURIOperationDispatcher();
    private static Object dispatcherInstance = null;
    private static Method invokeMethod = null;

    public static String getURI(MessageContext messageContext, String address) throws AxisFault {
        address = address.substring(address.indexOf("//") + 2);
        address = address.substring(address.indexOf("/"));
        String queryParameterSeparator = (String)messageContext.getProperty("whttp:queryParameterSeparator");
        if (queryParameterSeparator == null) {
            queryParameterSeparator = WSDL20DefaultValueHolder.getDefaultValue((String)"whttp:queryParameterSeparator");
        }
        OMElement firstElement = messageContext.getEnvelope().getBody().getFirstElement();
        String params = "";
        if (firstElement != null) {
            address = address + "/" + firstElement.getLocalName();
        } else {
            firstElement = messageContext.getEnvelope().getBody();
        }
        Iterator iter = firstElement.getChildElements();
        String legalCharacters = "-._~!$'()*+,;=:@/?".replaceAll(queryParameterSeparator, "");
        StringBuffer buff = new StringBuffer(params);
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            try {
                buff.append(URIEncoderDecoder.quoteIllegal((String)element.getLocalName(), (String)legalCharacters)).append("=").append(URIEncoderDecoder.quoteIllegal((String)element.getText(), (String)legalCharacters)).append(queryParameterSeparator);
            }
            catch (UnsupportedEncodingException e) {
                throw new AxisFault("URI Encoding error : " + element.getLocalName() + "=" + element.getText(), (Throwable)e);
            }
        }
        params = buff.toString();
        if (params.trim().length() != 0) {
            int index = address.indexOf("?");
            address = index == -1 ? address + "?" + params.substring(0, params.length() - 1) : (index == address.length() - 1 ? address + params.substring(0, params.length() - 1) : address + queryParameterSeparator + params.substring(0, params.length() - 1));
        }
        return address;
    }

    public static void processGetAndDeleteRequest(MessageContext msgContext, OutputStream out, String requestURI, Header contentTypeHeader, String httpMethod, boolean dispatching) throws AxisFault {
        String contentType = contentTypeHeader != null ? contentTypeHeader.getValue() : null;
        RESTUtil.prepareMessageContext(msgContext, requestURI, httpMethod, out, contentType, dispatching);
        msgContext.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
        org.apache.axis2.transport.http.util.RESTUtil.processURLRequest((MessageContext)msgContext, (OutputStream)out, (String)contentType);
    }

    public static void processURLRequest(MessageContext msgContext, OutputStream out, String soapAction, String requestURI) throws AxisFault {
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        msgContext.setSoapAction(soapAction);
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("TRANSPORT_OUT", (Object)out);
        msgContext.setServerSide(true);
        msgContext.setDoingREST(true);
        msgContext.setEnvelope(new SOAP11Factory().getDefaultEnvelope());
        msgContext.setProperty("NO_ENTITY_BODY", (Object)Boolean.TRUE);
        AxisEngine.receive((MessageContext)msgContext);
    }

    public static void processPOSTRequest(MessageContext msgContext, InputStream is, OutputStream os, String requestURI, Header contentTypeHeader, boolean dispatching) throws AxisFault {
        String contentType = contentTypeHeader != null ? contentTypeHeader.getValue() : null;
        RESTUtil.processPOSTRequest(msgContext, is, os, requestURI, contentType, dispatching);
    }

    public static void processPOSTRequest(MessageContext msgContext, InputStream is, OutputStream os, String requestURI, String contentType, boolean dispatching) throws AxisFault {
        RESTUtil.prepareMessageContext(msgContext, requestURI, "POST", os, contentType, dispatching);
        org.apache.axis2.transport.http.util.RESTUtil.processXMLRequest((MessageContext)msgContext, (InputStream)is, (OutputStream)os, (String)contentType);
    }

    private static void prepareMessageContext(MessageContext msgContext, String requestURI, String httpMethod, OutputStream out, String contentType, boolean dispatching) throws AxisFault {
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("HTTP_METHOD_OBJECT", (Object)httpMethod);
        msgContext.setServerSide(true);
        msgContext.setDoingREST(true);
        msgContext.setProperty("TRANSPORT_OUT", (Object)out);
        msgContext.setProperty("synapse.internal.rest.contentType", (Object)contentType);
        boolean reverseProxyMode = Boolean.parseBoolean(System.getProperty("reverseProxyMode"));
        AxisService axisService = null;
        if (!reverseProxyMode) {
            axisService = requestDispatcher.findService(msgContext);
        }
        boolean isCustomRESTDispatcher = false;
        if (requestURI.matches(NHttpConfiguration.getInstance().getRestUriApiRegex()) || requestURI.matches(NHttpConfiguration.getInstance().getRestUriProxyRegex())) {
            isCustomRESTDispatcher = true;
        }
        if (dispatching || !isCustomRESTDispatcher) {
            if (axisService == null) {
                String defaultSvcName = NHttpConfiguration.getInstance().getStringValue("nhttp.default.service", "__SynapseService");
                axisService = msgContext.getConfigurationContext().getAxisConfiguration().getService(defaultSvcName);
            }
            msgContext.setAxisService(axisService);
            RESTUtil.setAxisOperation(msgContext, axisService);
        } else {
            String multiTenantDispatchService = NHttpConfiguration.getInstance().getRESTDispatchService();
            axisService = msgContext.getConfigurationContext().getAxisConfiguration().getService(multiTenantDispatchService);
            msgContext.setAxisService(axisService);
            RESTUtil.setAxisOperation(msgContext, axisService);
        }
    }

    public static void dispatchAndVerify(MessageContext msgContext) throws AxisFault {
        String extendedURIBasedDispatcher = System.getProperty("ei.extendedURIBasedDispatcher");
        if (extendedURIBasedDispatcher == null) {
            requestDispatcher.invoke(msgContext);
        } else {
            try {
                invokeMethod.invoke(dispatcherInstance, msgContext);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AxisFault(e.getMessage());
            }
        }
        AxisService axisService = msgContext.getAxisService();
        if (axisService != null) {
            AxisOperation axisOperation;
            httpLocationBasedDispatcher.invoke(msgContext);
            if (msgContext.getAxisOperation() == null) {
                requestURIOperationDispatcher.invoke(msgContext);
            }
            if ((axisOperation = msgContext.getAxisOperation()) != null) {
                AxisEndpoint axisEndpoint = (AxisEndpoint)msgContext.getProperty("endpoint");
                if (axisEndpoint != null) {
                    AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisEndpoint.getBinding().getChild((Object)axisOperation.getName());
                    msgContext.setProperty("AxisBindingOperation", (Object)axisBindingOperation);
                }
                msgContext.setAxisOperation(axisOperation);
            }
        }
    }

    private static void setAxisOperation(MessageContext msgContext, AxisService axisService) {
        if (msgContext.getAxisOperation() == null && axisService != null) {
            AxisOperation axisOperation = RESTUtil.findOperation(axisService, msgContext);
            msgContext.setAxisOperation(axisOperation);
        }
    }

    public static AxisOperation findOperation(AxisService svc, MessageContext mc) {
        AxisOperation operation = svc.getOperation(NhttpConstants.SYNAPSE_OPERATION_NAME);
        if (operation == null && mc.getAxisService() != null) {
            operation = RESTUtil.processOperationValidation(svc);
        }
        return operation;
    }

    private static AxisOperation processOperationValidation(AxisService svc) {
        Object operationObj = svc.getParameterValue("_default_mediate_operation_");
        if (operationObj != null) {
            return (AxisOperation)operationObj;
        }
        return null;
    }

    static {
        String extendedURIBasedDispatcher = System.getProperty("ei.extendedURIBasedDispatcher");
        try {
            if (extendedURIBasedDispatcher != null) {
                Class<?> extendedURIBasedDispatcherClass = RESTUtil.class.getClassLoader().loadClass(extendedURIBasedDispatcher);
                dispatcherInstance = extendedURIBasedDispatcherClass.newInstance();
                invokeMethod = extendedURIBasedDispatcherClass.getMethod("invoke", MessageContext.class);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            log.fatal((Object)e);
        }
    }
}

