/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.nhttp.HttpCoreNIOMultiSSLListener;
import org.apache.synapse.transport.nhttp.config.ServerConnFactoryBuilder;
import org.apache.synapse.transport.nhttp.util.MultiSSLProfileReloaderMBean;

public class MultiSSLProfileReloader
implements MultiSSLProfileReloaderMBean {
    HttpCoreNIOMultiSSLListener httpCoreNIOMultiSSLListener;
    TransportInDescription transportInDescription;

    public MultiSSLProfileReloader(HttpCoreNIOMultiSSLListener multiSSLListener, TransportInDescription inDescription) {
        this.httpCoreNIOMultiSSLListener = multiSSLListener;
        this.transportInDescription = inDescription;
        MBeanRegistrar.getInstance().registerMBean((Object)this, "MultiSSLProfileReload", "reload");
    }

    @Override
    public String reloadSSLProfileConfig() throws AxisFault {
        Parameter oldParameter = this.transportInDescription.getParameter("SSLProfiles");
        Parameter profilePathParam = this.transportInDescription.getParameter("SSLProfilesConfigPath");
        if (oldParameter != null && profilePathParam != null) {
            this.transportInDescription.removeParameter(oldParameter);
            ServerConnFactoryBuilder builder = new ServerConnFactoryBuilder(this.transportInDescription, null);
            TransportInDescription loadedTransportIn = builder.loadMultiProfileSSLConfig();
            if (loadedTransportIn != null) {
                this.transportInDescription = loadedTransportIn;
                this.httpCoreNIOMultiSSLListener.reload(this.transportInDescription);
                return "SSLProfiles reloaded Successfully";
            }
            this.transportInDescription.addParameter(oldParameter);
        }
        return "Failed to reload SSLProfiles";
    }
}

