/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.nhttp.util.LatencyCollector;
import org.apache.synapse.transport.nhttp.util.LatencyParameter;
import org.apache.synapse.transport.nhttp.util.LatencyViewMBean;

public class LatencyView
implements LatencyViewMBean {
    private static final int SMALL_DATA_COLLECTION_PERIOD = 5;
    private static final int LARGE_DATA_COLLECTION_PERIOD = 300;
    private LatencyParameter lastLatency = new LatencyParameter(true);
    private LatencyParameter lastLatencyBe = new LatencyParameter(true);
    private LatencyParameter serverDecodeLatency;
    private LatencyParameter serverEncodeLatency;
    private LatencyParameter clientEncodeLatency;
    private LatencyParameter clientDecodeLatency;
    private LatencyParameter serverWorkerWaitTime;
    private LatencyParameter clientWorkerWaitTime;
    private LatencyParameter requestMediationLatency;
    private LatencyParameter responseMediationLatency;
    private List<LatencyParameter> latencies = new ArrayList<LatencyParameter>(10);
    private ScheduledExecutorService scheduler;
    private Date resetTime = Calendar.getInstance().getTime();
    private String latencyMode;
    private String name;

    public LatencyView(String latencyMode, boolean isHttps) {
        this(latencyMode, isHttps, "", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LatencyView(final String latencyMode, boolean isHttps, String namePostfix, boolean showAdvancedParameters) {
        this.latencyMode = latencyMode;
        this.name = "nio-http" + (isHttps ? "s" : "") + namePostfix;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, latencyMode + "-" + LatencyView.this.name + "-latency-view");
            }
        });
        this.scheduler.scheduleAtFixedRate(new ShortTermDataCollector(), 5L, 5L, TimeUnit.SECONDS);
        this.scheduler.scheduleAtFixedRate(new LongTermDataCollector(), 300L, 300L, TimeUnit.SECONDS);
        boolean registered = false;
        try {
            registered = MBeanRegistrar.getInstance().registerMBean((Object)this, this.latencyMode, this.name);
        }
        finally {
            if (!registered) {
                this.scheduler.shutdownNow();
            }
        }
        this.registerAllLatencies(showAdvancedParameters);
    }

    public void destroy() {
        MBeanRegistrar.getInstance().unRegisterMBean(this.latencyMode, this.name);
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
    }

    private void notifyTimes(long reqArrival, long reqDeparture, long resArrival, long resDeparture) {
        long latencyBe = resArrival - reqDeparture;
        long latency = resDeparture - reqArrival - latencyBe;
        this.lastLatency.update(latency);
        this.lastLatencyBe.update(latencyBe);
    }

    public void notifyTimes(LatencyCollector collector) {
        this.lastLatency.update(collector.getLatency());
        this.lastLatencyBe.update(collector.getBackendLatency());
        this.serverDecodeLatency.update(collector.getServerDecodeLatency());
        this.clientEncodeLatency.update(collector.getClientEncodeLatency());
        this.clientDecodeLatency.update(collector.getClientDecodeLatency());
        this.serverEncodeLatency.update(collector.getServerEncodeLatency());
        this.serverWorkerWaitTime.update(collector.getServerWorkerQueuedTime());
        this.clientWorkerWaitTime.update(collector.getClientWorkerQueuedTime());
        this.requestMediationLatency.update(collector.getServerWorkerLatency());
        this.responseMediationLatency.update(collector.getClientWorkerLatency());
    }

    private void registerAllLatencies(boolean recordAdditionalLatencies) {
        this.latencies.add(this.lastLatency);
        this.latencies.add(this.lastLatencyBe);
        this.serverDecodeLatency = new LatencyParameter(recordAdditionalLatencies);
        this.serverEncodeLatency = new LatencyParameter(recordAdditionalLatencies);
        this.clientEncodeLatency = new LatencyParameter(recordAdditionalLatencies);
        this.clientDecodeLatency = new LatencyParameter(recordAdditionalLatencies);
        this.serverWorkerWaitTime = new LatencyParameter(recordAdditionalLatencies);
        this.clientWorkerWaitTime = new LatencyParameter(recordAdditionalLatencies);
        this.requestMediationLatency = new LatencyParameter(recordAdditionalLatencies);
        this.responseMediationLatency = new LatencyParameter(recordAdditionalLatencies);
        this.latencies.add(this.serverDecodeLatency);
        this.latencies.add(this.clientEncodeLatency);
        this.latencies.add(this.clientDecodeLatency);
        this.latencies.add(this.serverEncodeLatency);
        this.latencies.add(this.serverWorkerWaitTime);
        this.latencies.add(this.clientWorkerWaitTime);
        this.latencies.add(this.requestMediationLatency);
        this.latencies.add(this.responseMediationLatency);
    }

    @Override
    public double getAvg_Latency() {
        return this.lastLatency.getAllTimeAverage();
    }

    @Override
    public double getAvg_Client_To_Esb_RequestReadTime() {
        return this.serverDecodeLatency.getAllTimeAverage();
    }

    @Override
    public double getAvg_Esb_To_BackEnd_RequestWriteTime() {
        return this.clientEncodeLatency.getAllTimeAverage();
    }

    @Override
    public double getAvg_BackEnd_To_Esb_ResponseReadTime() {
        return this.clientDecodeLatency.getAllTimeAverage();
    }

    @Override
    public double getAvg_Esb_To_Client_ResponseWriteTime() {
        return this.serverEncodeLatency.getAllTimeAverage();
    }

    @Override
    public double get1m_Avg_Client_To_Esb_RequestReadTime() {
        return this.serverDecodeLatency.getAverageLatency1m();
    }

    @Override
    public double get1m_Avg_Esb_To_BackEnd_RequestWriteTime() {
        return this.clientEncodeLatency.getAverageLatency1m();
    }

    @Override
    public double get1m_Avg_BackEnd_To_Esb_ResponseReadTime() {
        return this.clientDecodeLatency.getAverageLatency1m();
    }

    @Override
    public double get1m_Avg_Esb_To_Client_ResponseWriteTime() {
        return this.serverEncodeLatency.getAverageLatency1m();
    }

    @Override
    public double get5m_Avg_Client_To_Esb_RequestReadTime() {
        return this.serverDecodeLatency.getAverageLatency5m();
    }

    @Override
    public double get5m_Avg_Esb_To_BackEnd_RequestWriteTime() {
        return this.clientEncodeLatency.getAverageLatency5m();
    }

    @Override
    public double get5m_Avg_BackEnd_To_Esb_ResponseReadTime() {
        return this.clientDecodeLatency.getAverageLatency5m();
    }

    @Override
    public double get5m_Avg_Esb_To_Client_ResponseWriteTime() {
        return this.serverEncodeLatency.getAverageLatency5m();
    }

    @Override
    public double get15m_Avg_Client_To_Esb_RequestReadTime() {
        return this.serverDecodeLatency.getAverageLatency15m();
    }

    @Override
    public double get15m_Avg_Esb_To_BackEnd_RequestWriteTime() {
        return this.clientEncodeLatency.getAverageLatency15m();
    }

    @Override
    public double get15m_Avg_BackEnd_To_Esb_ResponseReadTime() {
        return this.clientDecodeLatency.getAverageLatency15m();
    }

    @Override
    public double get15m_Avg_Esb_To_Client_ResponseWriteTime() {
        return this.serverEncodeLatency.getAverageLatency15m();
    }

    @Override
    public double getAvg_ClientWorker_QueuedTime() {
        return this.clientWorkerWaitTime.getAllTimeAverage();
    }

    @Override
    public double get1m_Avg_ClientWorker_QueuedTime() {
        return this.clientWorkerWaitTime.getAverageLatency1m();
    }

    @Override
    public double get5m_Avg_ClientWorker_QueuedTime() {
        return this.clientWorkerWaitTime.getAverageLatency5m();
    }

    @Override
    public double get15m_Avg_ClientWorker_QueuedTime() {
        return this.clientWorkerWaitTime.getAverageLatency15m();
    }

    @Override
    public double getAvg_ServerWorker_QueuedTime() {
        return this.serverWorkerWaitTime.getAllTimeAverage();
    }

    @Override
    public double get1m_Avg_ServerWorker_QueuedTime() {
        return this.serverWorkerWaitTime.getAverageLatency1m();
    }

    @Override
    public double get5m_Avg_ServerWorker_QueuedTime() {
        return this.serverWorkerWaitTime.getAverageLatency5m();
    }

    @Override
    public double get15m_Avg_ServerWorker_QueuedTime() {
        return this.serverWorkerWaitTime.getAverageLatency15m();
    }

    @Override
    public double get1m_Avg_Latency() {
        return this.lastLatency.getAverageLatency1m();
    }

    @Override
    public double get5m_Avg_Latency() {
        return this.lastLatency.getAverageLatency5m();
    }

    @Override
    public double get15m_Avg_Latency() {
        return this.lastLatency.getAverageLatency15m();
    }

    @Override
    public double get1h_Avg_Latency() {
        return this.lastLatency.getAverageLatency1h();
    }

    @Override
    public double get8h_Avg_Latency() {
        return this.lastLatency.getAverageLatency8h();
    }

    @Override
    public double get24h_Avg_Latency() {
        return this.lastLatency.getAverageLatency24h();
    }

    @Override
    public double getAvg_Latency_BackEnd() {
        return this.lastLatencyBe.getAllTimeAverage();
    }

    @Override
    public double get1m_Avg_Latency_BackEnd() {
        return this.lastLatencyBe.getAverageLatency1m();
    }

    @Override
    public double get5m_Avg_Latency_BackEnd() {
        return this.lastLatencyBe.getAverageLatency5m();
    }

    @Override
    public double get15m_Avg_Latency_BackEnd() {
        return this.lastLatencyBe.getAverageLatency15m();
    }

    @Override
    public double get1h_Avg_Latency_BackEnd() {
        return this.lastLatencyBe.getAverageLatency1h();
    }

    @Override
    public double get8h_Avg_Latency_BackEnd() {
        return this.lastLatencyBe.getAverageLatency8h();
    }

    @Override
    public double get24h_Avg_Latency_BackEnd() {
        return this.lastLatencyBe.getAverageLatency24h();
    }

    @Override
    public double get1h_Avg_Client_To_Esb_RequestReadTime() {
        return this.serverDecodeLatency.getAverageLatency1h();
    }

    @Override
    public double get1h_Avg_Esb_To_BackEnd_RequestWriteTime() {
        return this.clientEncodeLatency.getAverageLatency1h();
    }

    @Override
    public double get1h_Avg_BackEnd_To_Esb_ResponseReadTime() {
        return this.clientDecodeLatency.getAverageLatency1h();
    }

    @Override
    public double get1h_Avg_Esb_To_Client_ResponseWriteTime() {
        return this.serverEncodeLatency.getAverageLatency1h();
    }

    @Override
    public double get1h_Avg_ServerWorker_QueuedTime() {
        return this.serverWorkerWaitTime.getAverageLatency1h();
    }

    @Override
    public double get1h_Avg_ClientWorker_QueuedTime() {
        return this.clientWorkerWaitTime.getAverageLatency1h();
    }

    @Override
    public double get8h_Avg_Client_To_Esb_RequestReadTime() {
        return this.serverDecodeLatency.getAverageLatency8h();
    }

    @Override
    public double get8h_Avg_Esb_To_BackEnd_RequestWriteTime() {
        return this.clientEncodeLatency.getAverageLatency8h();
    }

    @Override
    public double get8h_Avg_BackEnd_To_Esb_ResponseReadTime() {
        return this.clientDecodeLatency.getAverageLatency8h();
    }

    @Override
    public double get8h_Avg_Esb_To_Client_ResponseWriteTime() {
        return this.serverEncodeLatency.getAverageLatency8h();
    }

    @Override
    public double get8h_Avg_ServerWorker_QueuedTime() {
        return this.serverWorkerWaitTime.getAverageLatency8h();
    }

    @Override
    public double get8h_Avg_ClientWorker_QueuedTime() {
        return this.clientWorkerWaitTime.getAverageLatency8h();
    }

    @Override
    public double get24h_Avg_Client_To_Esb_RequestReadTime() {
        return this.serverDecodeLatency.getAverageLatency24h();
    }

    @Override
    public double get24h_Avg_Esb_To_BackEnd_RequestWriteTime() {
        return this.clientEncodeLatency.getAverageLatency24h();
    }

    @Override
    public double get24h_Avg_BackEnd_To_Esb_ResponseReadTime() {
        return this.clientDecodeLatency.getAverageLatency24h();
    }

    @Override
    public double get24h_Avg_Esb_To_Client_ResponseWriteTime() {
        return this.serverEncodeLatency.getAverageLatency24h();
    }

    @Override
    public double get24h_Avg_ServerWorker_QueuedTime() {
        return this.serverWorkerWaitTime.getAverageLatency24h();
    }

    @Override
    public double get24h_Avg_ClientWorker_QueuedTime() {
        return this.clientWorkerWaitTime.getAverageLatency24h();
    }

    @Override
    public double getAvg_request_Mediation_Latency() {
        return this.requestMediationLatency.getAllTimeAverage();
    }

    @Override
    public double getAvg_response_Mediation_Latency() {
        return this.responseMediationLatency.getAllTimeAverage();
    }

    @Override
    public double get1m_Avg_request_Mediation_Latency() {
        return this.requestMediationLatency.getAverageLatency1m();
    }

    @Override
    public double get1m_Avg_response_Mediation_Latency() {
        return this.responseMediationLatency.getAverageLatency1m();
    }

    @Override
    public double get5m_Avg_request_Mediation_Latency() {
        return this.requestMediationLatency.getAverageLatency5m();
    }

    @Override
    public double get5m_Avg_response_Mediation_Latency() {
        return this.responseMediationLatency.getAverageLatency5m();
    }

    @Override
    public double get15m_Avg_request_Mediation_Latency() {
        return this.requestMediationLatency.getAverageLatency15m();
    }

    @Override
    public double get15m_Avg_response_Mediation_Latency() {
        return this.responseMediationLatency.getAverageLatency15m();
    }

    @Override
    public double get1h_Avg_request_Mediation_Latency() {
        return this.requestMediationLatency.getAverageLatency1h();
    }

    @Override
    public double get1h_Avg_response_Mediation_Latency() {
        return this.responseMediationLatency.getAverageLatency1h();
    }

    @Override
    public double get8h_Avg_request_Mediation_Latency() {
        return this.requestMediationLatency.getAverageLatency8h();
    }

    @Override
    public double get8h_Avg_response_Mediation_Latency() {
        return this.responseMediationLatency.getAverageLatency8h();
    }

    @Override
    public double get24h_Avg_request_Mediation_Latency() {
        return this.requestMediationLatency.getAverageLatency24h();
    }

    @Override
    public double get24h_Avg_response_Mediation_Latency() {
        return this.responseMediationLatency.getAverageLatency24h();
    }

    @Override
    public void reset() {
        for (LatencyParameter latency : this.latencies) {
            latency.reset();
        }
        this.resetTime = Calendar.getInstance().getTime();
    }

    @Override
    public Date getLastResetTime() {
        return this.resetTime;
    }

    private class LongTermDataCollector
    implements Runnable {
        private LongTermDataCollector() {
        }

        @Override
        public void run() {
            for (LatencyParameter latency : LatencyView.this.latencies) {
                latency.updateLongTermCache();
            }
        }
    }

    private class ShortTermDataCollector
    implements Runnable {
        private ShortTermDataCollector() {
        }

        @Override
        public void run() {
            for (LatencyParameter latency : LatencyView.this.latencies) {
                latency.updateCache();
            }
        }
    }
}

