/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import org.apache.http.protocol.HttpContext;

public class LatencyCollector {
    private long backendLatency = 0L;
    private long latency = 0L;
    private long serverDecodeLatency = 0L;
    private long clientEncodeLatency = 0L;
    private long clientDecodeLatency = 0L;
    private long serverEncodeLatency = 0L;
    private long serverWorkerQueuedTime = 0L;
    private long clientWorkerQueuedTime = 0L;
    private long serverWorkerLatency = 0L;
    private long clientWorkerLatency = 0L;

    public LatencyCollector(HttpContext context, boolean isS2S) {
        Object o4;
        Object o3;
        Object o1 = context.getAttribute("REQ_ARRIVAL_TIME");
        Object o2 = context.getAttribute("REQ_DEPARTURE_TIME");
        if (isS2S) {
            o3 = context.getAttribute("RES_HEADER_ARRIVAL_TIME");
            o4 = context.getAttribute("RES_TO_CLIENT_WRITE_START_TIME");
        } else {
            o3 = context.getAttribute("RES_ARRIVAL_TIME");
            o4 = context.getAttribute("RES_DEPARTURE_TIME");
        }
        if (o1 != null && o2 != null && o3 != null && o4 != null) {
            long tReqArrival = (Long)o1;
            long tReqDeparture = (Long)o2;
            long tResArrival = (Long)o3;
            long tResDeparture = (Long)o4;
            this.backendLatency = tResArrival - tReqDeparture;
            this.latency = tResDeparture - tReqArrival - this.backendLatency;
        }
        o1 = context.getAttribute("REQ_FROM_CLIENT_READ_START_TIME");
        o2 = context.getAttribute("REQ_FROM_CLIENT_READ_END_TIME");
        long reqestFromClientReadEndTime = 0L;
        if (o1 != null && o2 != null) {
            reqestFromClientReadEndTime = (Long)o2;
            this.serverDecodeLatency = reqestFromClientReadEndTime - (Long)o1;
        }
        o1 = context.getAttribute("REQ_TO_BACKEND_WRITE_START_TIME");
        o2 = context.getAttribute("REQ_TO_BACKEND_WRITE_END_TIME");
        if (o1 != null && o2 != null) {
            this.clientEncodeLatency = (Long)o2 - (Long)o1;
        }
        o1 = context.getAttribute("RES_FROM_BACKEND_READ_START_TIME");
        o2 = context.getAttribute("RES_FROM_BACKEND_READ_END_TIME");
        long responseFromBEReadEndTime = 0L;
        if (o1 != null && o2 != null) {
            responseFromBEReadEndTime = (Long)o2;
            this.clientDecodeLatency = responseFromBEReadEndTime - (Long)o1;
        }
        o1 = context.getAttribute("RES_TO_CLIENT_WRITE_START_TIME");
        o2 = context.getAttribute("RES_TO_CLIENT_WRITE_END_TIME");
        if (o1 != null && o2 != null) {
            this.serverEncodeLatency = (Long)o2 - (Long)o1;
        }
        long serverWorkerStartTime = 0L;
        o1 = context.getAttribute("SERVER_WORKER_START_TIME");
        o2 = context.getAttribute("SERVER_WORKER_INIT_TIME");
        if (o1 != null && o2 != null) {
            serverWorkerStartTime = (Long)o1;
            this.serverWorkerQueuedTime = serverWorkerStartTime - (Long)o2;
        }
        o1 = context.getAttribute("CLIENT_WORKER_START_TIME");
        o2 = context.getAttribute("CLIENT_WORKER_INIT_TIME");
        long clientWorkerStartTime = 0L;
        if (o1 != null && o2 != null) {
            clientWorkerStartTime = (Long)o1;
            this.clientWorkerQueuedTime = clientWorkerStartTime - (Long)o2;
        }
        o1 = context.getAttribute("REQ_TO_BACKEND_WRITE_START_TIME");
        o2 = context.getAttribute("SERVER_WORKER_START_TIME");
        if (o1 != null && o2 != null) {
            this.serverWorkerLatency = (Long)o1 - (Long)o2;
        }
        o1 = context.getAttribute("RES_TO_CLIENT_WRITE_START_TIME");
        o2 = context.getAttribute("CLIENT_WORKER_START_TIME");
        if (o1 != null && o2 != null) {
            this.clientWorkerLatency = (Long)o1 - (Long)o2;
        }
        if (this.clientWorkerQueuedTime > 0L && responseFromBEReadEndTime > clientWorkerStartTime) {
            if (!isS2S) {
                this.backendLatency -= this.clientWorkerQueuedTime;
            }
            this.clientDecodeLatency -= this.clientWorkerQueuedTime;
        }
        if (this.serverWorkerQueuedTime > 0L && reqestFromClientReadEndTime > serverWorkerStartTime) {
            this.serverDecodeLatency -= this.serverWorkerQueuedTime;
        }
    }

    public long getBackendLatency() {
        return this.backendLatency;
    }

    public long getLatency() {
        return this.latency;
    }

    public long getServerDecodeLatency() {
        return this.serverDecodeLatency;
    }

    public long getServerEncodeLatency() {
        return this.serverEncodeLatency;
    }

    public long getClientEncodeLatency() {
        return this.clientEncodeLatency;
    }

    public long getClientDecodeLatency() {
        return this.clientDecodeLatency;
    }

    public long getServerWorkerQueuedTime() {
        return this.serverWorkerQueuedTime;
    }

    public long getClientWorkerQueuedTime() {
        return this.clientWorkerQueuedTime;
    }

    public long getServerWorkerLatency() {
        return this.serverWorkerLatency;
    }

    public long getClientWorkerLatency() {
        return this.clientWorkerLatency;
    }

    public static void clearTimestamps(HttpContext context) {
        if (context == null) {
            return;
        }
        context.removeAttribute("REQ_ARRIVAL_TIME");
        context.removeAttribute("REQ_DEPARTURE_TIME");
        context.removeAttribute("RES_HEADER_ARRIVAL_TIME");
        context.removeAttribute("RES_TO_CLIENT_WRITE_START_TIME");
        context.removeAttribute("RES_ARRIVAL_TIME");
        context.removeAttribute("RES_DEPARTURE_TIME");
        context.removeAttribute("REQ_FROM_CLIENT_READ_START_TIME");
        context.removeAttribute("REQ_FROM_CLIENT_READ_END_TIME");
        context.removeAttribute("REQ_TO_BACKEND_WRITE_START_TIME");
        context.removeAttribute("REQ_TO_BACKEND_WRITE_END_TIME");
        context.removeAttribute("RES_FROM_BACKEND_READ_START_TIME");
        context.removeAttribute("RES_FROM_BACKEND_READ_END_TIME");
        context.removeAttribute("RES_TO_CLIENT_WRITE_END_TIME");
        context.removeAttribute("SERVER_WORKER_START_TIME");
        context.removeAttribute("SERVER_WORKER_INIT_TIME");
        context.removeAttribute("CLIENT_WORKER_START_TIME");
        context.removeAttribute("CLIENT_WORKER_INIT_TIME");
    }
}

