/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.synapse.transport.nhttp.util.NhttpMetricsCollector;

public class ActiveConnectionMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog(ActiveConnectionMonitor.class);
    private NhttpMetricsCollector nhttpMetricsCollector;
    private DefaultListeningIOReactor ioReactor;
    private int maxActive;

    public ActiveConnectionMonitor(NhttpMetricsCollector metrics, DefaultListeningIOReactor ior, int maxActiveConnections) {
        this.ioReactor = ior;
        this.nhttpMetricsCollector = metrics;
        this.maxActive = maxActiveConnections;
    }

    @Override
    public void run() {
        try {
            if (this.maxActive > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Active Connection Count : " + this.nhttpMetricsCollector.getActiveConnectionCount()));
                }
                if (this.nhttpMetricsCollector.getActiveConnectionCount() > this.maxActive) {
                    log.warn((Object)"Pausing the Listening IOReactor : Too many open connections than the max_open_connections limit.");
                    this.ioReactor.pause();
                } else {
                    this.ioReactor.resume();
                }
            }
        }
        catch (IOException e) {
            log.warn((Object)"Active Connection Monitor Task - IO Error while pausing/resuming the IOReactor ");
        }
    }
}

