/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.certificatevalidation.RevocationVerificationManager;
import org.apache.synapse.transport.http.conn.SSLClientAuth;
import org.apache.synapse.transport.http.conn.SSLContextDetails;
import org.apache.synapse.transport.http.conn.ServerConnFactory;
import org.apache.synapse.transport.http.conn.ServerSSLSetupHandler;
import org.apache.synapse.transport.nhttp.util.SecureVaultValueReader;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class ServerConnFactoryBuilder {
    private final Log log = LogFactory.getLog(ServerConnFactoryBuilder.class);
    private final TransportInDescription transportIn;
    private final HttpHost host;
    private final String name;
    protected SSLContextDetails ssl;
    private Map<InetSocketAddress, SSLContextDetails> sslByIPMap = null;
    private ConfigurationContext configurationContext;

    public ServerConnFactoryBuilder(TransportInDescription transportIn, HttpHost host, ConfigurationContext configurationContext) {
        this.transportIn = transportIn;
        this.host = host;
        this.name = transportIn.getName().toUpperCase(Locale.US);
        this.configurationContext = configurationContext;
    }

    public ServerConnFactoryBuilder(TransportInDescription transportIn, HttpHost host) {
        this.transportIn = transportIn;
        this.host = host;
        this.name = transportIn.getName().toUpperCase(Locale.US);
    }

    protected SSLContextDetails createSSLContext(OMElement keyStoreEl, OMElement trustStoreEl, OMElement cientAuthEl, OMElement httpsProtocolsEl, OMElement preferredCiphersEl, RevocationVerificationManager verificationManager, String sslProtocol) throws AxisFault {
        SecretResolver secretResolver = this.configurationContext != null && this.configurationContext.getAxisConfiguration() != null ? this.configurationContext.getAxisConfiguration().getSecretResolver() : SecretResolverFactory.create((OMElement)keyStoreEl, (boolean)false);
        return this.createSSLContext(keyStoreEl, trustStoreEl, cientAuthEl, httpsProtocolsEl, preferredCiphersEl, verificationManager, sslProtocol, secretResolver);
    }

    protected SSLContextDetails createSSLContext(OMElement keyStoreEl, OMElement trustStoreEl, OMElement cientAuthEl, OMElement httpsProtocolsEl, OMElement preferredCiphersEl, RevocationVerificationManager verificationManager, String sslProtocol, SecretResolver secretResolver) throws AxisFault {
        String configuredWeakCiphers;
        String configuredHttpsProtocols;
        String s;
        OMElement storePasswordEl;
        String type;
        String location;
        KeyManager[] keymanagers = null;
        TrustManager[] trustManagers = null;
        if (keyStoreEl != null) {
            location = this.getValueOfElementWithLocalName(keyStoreEl, "Location");
            type = this.getValueOfElementWithLocalName(keyStoreEl, "Type");
            storePasswordEl = keyStoreEl.getFirstChildWithName(new QName("Password"));
            OMElement keyPasswordEl = keyStoreEl.getFirstChildWithName(new QName("KeyPassword"));
            if (storePasswordEl == null) {
                throw new AxisFault("Cannot proceed because Password element is missing in KeyStore");
            }
            if (keyPasswordEl == null) {
                throw new AxisFault("Cannot proceed because KeyPassword element is missing in KeyStore");
            }
            String storePassword = SecureVaultValueReader.getSecureVaultValue(secretResolver, storePasswordEl);
            String keyPassword = SecureVaultValueReader.getSecureVaultValue(secretResolver, keyPasswordEl);
            FileInputStream fis = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(type);
                fis = new FileInputStream(location);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(this.name + " Loading Identity Keystore from : " + location));
                }
                keyStore.load(fis, storePassword.toCharArray());
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(keyStore, keyPassword.toCharArray());
                keymanagers = kmfactory.getKeyManagers();
                if (this.log.isInfoEnabled() && keymanagers != null) {
                    KeyManager[] keyManagerArray = keymanagers;
                    int n = keyManagerArray.length;
                    for (int i = 0; i < n; ++i) {
                        KeyManager keymanager = keyManagerArray[i];
                        if (!(keymanager instanceof X509KeyManager)) continue;
                        X509KeyManager x509keymanager = (X509KeyManager)keymanager;
                        Enumeration<String> en = keyStore.aliases();
                        while (en.hasMoreElements()) {
                            String s2 = en.nextElement();
                            X509Certificate[] certs = x509keymanager.getCertificateChain(s2);
                            if (certs == null) continue;
                            for (X509Certificate cert : certs) {
                                this.log.debug((Object)(this.name + " Subject DN: " + cert.getSubjectDN()));
                                this.log.debug((Object)(this.name + " Issuer DN: " + cert.getIssuerDN()));
                            }
                        }
                    }
                }
            }
            catch (GeneralSecurityException gse) {
                this.log.error((Object)(this.name + " Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                this.log.error((Object)(this.name + " Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (trustStoreEl != null) {
            location = this.getValueOfElementWithLocalName(trustStoreEl, "Location");
            type = this.getValueOfElementWithLocalName(trustStoreEl, "Type");
            storePasswordEl = trustStoreEl.getFirstChildWithName(new QName("Password"));
            if (storePasswordEl == null) {
                throw new AxisFault("Cannot proceed because Password element is missing in TrustStore");
            }
            String storePassword = SecureVaultValueReader.getSecureVaultValue(secretResolver, storePasswordEl);
            FileInputStream fis = null;
            try {
                KeyStore trustStore = KeyStore.getInstance(type);
                fis = new FileInputStream(location);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(this.name + " Loading Trust Keystore from : " + location));
                }
                trustStore.load(fis, storePassword.toCharArray());
                TrustManagerFactory trustManagerfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerfactory.init(trustStore);
                trustManagers = trustManagerfactory.getTrustManagers();
            }
            catch (GeneralSecurityException gse) {
                this.log.error((Object)(this.name + " Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                this.log.error((Object)(this.name + " Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        String string = s = cientAuthEl != null ? cientAuthEl.getText() : null;
        SSLClientAuth clientAuth = "optional".equalsIgnoreCase(s) ? SSLClientAuth.OPTIONAL : ("require".equalsIgnoreCase(s) ? SSLClientAuth.REQUIRED : null);
        String[] httpsProtocols = null;
        String string2 = configuredHttpsProtocols = httpsProtocolsEl != null ? httpsProtocolsEl.getText() : null;
        if (configuredHttpsProtocols != null && configuredHttpsProtocols.trim().length() != 0) {
            String[] configuredValues = configuredHttpsProtocols.trim().split(",");
            ArrayList<String> protocolList = new ArrayList<String>(configuredValues.length);
            for (String protocol : configuredValues) {
                if (protocol.trim().isEmpty()) continue;
                protocolList.add(protocol.trim());
            }
            httpsProtocols = protocolList.toArray(new String[protocolList.size()]);
        }
        String[] preferredCiphers = null;
        String string3 = configuredWeakCiphers = preferredCiphersEl != null ? preferredCiphersEl.getText() : null;
        if (configuredWeakCiphers != null && configuredWeakCiphers.trim().length() != 0) {
            String[] configuredValues = configuredWeakCiphers.trim().split(",");
            ArrayList<String> ciphersList = new ArrayList<String>(configuredValues.length);
            for (String cipher : configuredValues) {
                if ((cipher = cipher.trim()).isEmpty()) continue;
                ciphersList.add(cipher);
            }
            preferredCiphers = ciphersList.toArray(new String[ciphersList.size()]);
        }
        try {
            String sslProtocolValue = sslProtocol != null ? sslProtocol : "TLS";
            SSLContext sslContext = SSLContext.getInstance(sslProtocolValue);
            sslContext.init(keymanagers, trustManagers, null);
            ServerSSLSetupHandler sslSetupHandler = clientAuth != null || httpsProtocols != null || preferredCiphers != null ? new ServerSSLSetupHandler(clientAuth, httpsProtocols, verificationManager, preferredCiphers) : null;
            return new SSLContextDetails(sslContext, sslSetupHandler);
        }
        catch (GeneralSecurityException gse) {
            this.log.error((Object)(this.name + " Unable to create SSL context with the given configuration"), (Throwable)gse);
            throw new AxisFault("Unable to create SSL context with the given configuration", (Throwable)gse);
        }
    }

    public ServerConnFactoryBuilder parseSSL() throws AxisFault {
        Parameter keyParam = this.transportIn.getParameter("keystore");
        Parameter trustParam = this.transportIn.getParameter("truststore");
        Parameter clientAuthParam = this.transportIn.getParameter("SSLVerifyClient");
        Parameter httpsProtocolsParam = this.transportIn.getParameter("HttpsProtocols");
        Parameter sslpParameter = this.transportIn.getParameter("SSLProtocol");
        Parameter preferredCiphersParam = this.transportIn.getParameter("PreferredCiphers");
        String sslProtocol = sslpParameter != null ? sslpParameter.getValue().toString() : "TLS";
        OMElement keyStoreEl = keyParam != null ? keyParam.getParameterElement().getFirstElement() : null;
        OMElement trustStoreEl = trustParam != null ? trustParam.getParameterElement().getFirstElement() : null;
        OMElement clientAuthEl = clientAuthParam != null ? clientAuthParam.getParameterElement() : null;
        OMElement httpsProtocolsEl = httpsProtocolsParam != null ? httpsProtocolsParam.getParameterElement() : null;
        OMElement preferredCiphersEl = preferredCiphersParam != null ? preferredCiphersParam.getParameterElement() : null;
        Parameter cvp = this.transportIn.getParameter("CertificateRevocationVerifier");
        String cvEnable = cvp != null ? cvp.getParameterElement().getAttribute(new QName("enable")).getAttributeValue() : null;
        RevocationVerificationManager revocationVerifier = null;
        if ("true".equalsIgnoreCase(cvEnable)) {
            String cacheSizeString = cvp.getParameterElement().getFirstChildWithName(new QName("CacheSize")).getText();
            String cacheDelayString = cvp.getParameterElement().getFirstChildWithName(new QName("CacheDelay")).getText();
            Integer cacheSize = null;
            Integer cacheDelay = null;
            try {
                cacheSize = new Integer(cacheSizeString);
                cacheDelay = new Integer(cacheDelayString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            revocationVerifier = new RevocationVerificationManager(cacheSize, cacheDelay);
        }
        this.ssl = this.createSSLContext(keyStoreEl, trustStoreEl, clientAuthEl, httpsProtocolsEl, preferredCiphersEl, revocationVerifier, sslProtocol);
        return this;
    }

    public ServerConnFactoryBuilder parseMultiProfileSSL() throws AxisFault {
        TransportInDescription loadedTransportIn = this.loadMultiProfileSSLConfig();
        if (loadedTransportIn == null) {
            return this;
        }
        Parameter profileParam = this.transportIn.getParameter("SSLProfiles");
        OMElement profilesEl = profileParam.getParameterElement();
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)profilesEl, (boolean)true);
        Iterator profiles = profilesEl.getChildrenWithName(new QName("profile"));
        while (profiles.hasNext()) {
            OMElement profileEl = (OMElement)profiles.next();
            OMElement bindAddressEl = profileEl.getFirstChildWithName(new QName("bindAddress"));
            if (bindAddressEl == null) {
                String msg = "SSL profile must define a bind address";
                this.log.error((Object)(this.name + " " + msg));
                throw new AxisFault(msg);
            }
            InetSocketAddress address = new InetSocketAddress(bindAddressEl.getText(), this.host.getPort());
            OMElement keyStoreEl = profileEl.getFirstChildWithName(new QName("KeyStore"));
            OMElement trustStoreEl = profileEl.getFirstChildWithName(new QName("TrustStore"));
            OMElement clientAuthEl = profileEl.getFirstChildWithName(new QName("SSLVerifyClient"));
            OMElement httpsProtocolsEl = profileEl.getFirstChildWithName(new QName("HttpsProtocols"));
            OMElement preferredCiphersEl = profileEl.getFirstChildWithName(new QName("PreferredCiphers"));
            Parameter sslpParameter = this.transportIn.getParameter("SSLProtocol");
            String sslProtocol = sslpParameter != null ? sslpParameter.getValue().toString() : "TLS";
            SSLContextDetails ssl = this.createSSLContext(keyStoreEl, trustStoreEl, clientAuthEl, httpsProtocolsEl, preferredCiphersEl, null, sslProtocol, secretResolver);
            if (this.sslByIPMap == null) {
                this.sslByIPMap = new HashMap<InetSocketAddress, SSLContextDetails>();
            }
            this.sslByIPMap.put(address, ssl);
        }
        return this;
    }

    public TransportInDescription loadMultiProfileSSLConfig() {
        Parameter profilePathParam = this.transportIn.getParameter("dynamicSSLProfilesConfig");
        if (profilePathParam == null) {
            if (this.transportIn.getParameter("SSLProfiles") != null) {
                return this.transportIn;
            }
            return null;
        }
        OMElement pathEl = profilePathParam.getParameterElement();
        String path = pathEl.getFirstChildWithName(new QName("filePath")).getText();
        try {
            if (path != null) {
                String separator = path.startsWith(System.getProperty("file.separator")) ? "" : System.getProperty("file.separator");
                String fullPath = System.getProperty("user.dir") + separator + path;
                OMElement profileEl = new StAXOMBuilder(fullPath).getDocumentElement();
                Parameter profileParam = new Parameter();
                profileParam.setParameterElement(profileEl);
                profileParam.setName("SSLProfiles");
                profileParam.setValue((Object)profileEl);
                this.transportIn.addParameter(profileParam);
                this.log.info((Object)("SSLProfile configuration is loaded from path: " + fullPath));
                return this.transportIn;
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Could not load SSLProfileConfig from file path: " + path), (Throwable)e);
        }
        return null;
    }

    public ServerConnFactory build(HttpParams params) throws AxisFault {
        if (this.ssl != null || this.sslByIPMap != null) {
            String port = ParamUtils.getOptionalParam((ParameterInclude)this.transportIn, (String)"port");
            if (port != null) {
                return new ServerConnFactory(this.ssl, this.sslByIPMap, params, Integer.parseInt(port));
            }
            return new ServerConnFactory(this.ssl, this.sslByIPMap, params);
        }
        return new ServerConnFactory(params);
    }

    private String getValueOfElementWithLocalName(OMElement element, String localName) {
        Iterator iterator = element.getChildrenWithLocalName(localName);
        String value = null;
        Object obj = iterator.next();
        if (obj instanceof OMElement) {
            value = ((OMElement)obj).getText();
        }
        return value;
    }
}

