/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.synapse.transport.http.conn.ProxyConfig;
import org.apache.synapse.transport.http.conn.ProxyProfileConfig;

public class ProxyConfigBuilder {
    private HttpHost proxy;
    private UsernamePasswordCredentials proxyCredentials;
    private String[] proxyBypass;
    private String name;
    private static final QName Q_PROFILE = new QName("profile");
    private static final QName Q_TARGET_HOSTS = new QName("targetHosts");
    private static final QName Q_PROXY_HOST = new QName("proxyHost");
    private static final QName Q_PROXY_PORT = new QName("proxyPort");
    private static final QName Q_PROXY_USER = new QName("proxyUserName");
    private static final QName Q_PROXY_PASSWORD = new QName("proxyPassword");
    private static final QName Q_BYPASS = new QName("bypass");
    private static final Log log = LogFactory.getLog(ProxyConfigBuilder.class);

    public ProxyConfig build(TransportOutDescription transportOut) throws AxisFault {
        this.name = transportOut.getName();
        Map<String, ProxyProfileConfig> proxyProfileConfigMap = this.getProxyProfiles(transportOut);
        if (proxyProfileConfigMap == null) {
            String s;
            String proxyHost = null;
            int proxyPort = -1;
            Parameter proxyHostParam = transportOut.getParameter("http.proxyHost");
            if (proxyHostParam != null) {
                proxyHost = (String)proxyHostParam.getValue();
                Parameter proxyPortParam = transportOut.getParameter("http.proxyPort");
                if (proxyPortParam != null) {
                    proxyPort = Integer.parseInt((String)proxyPortParam.getValue());
                }
            }
            if (proxyHost == null && (proxyHost = System.getProperty("http.proxyHost")) != null && (s = System.getProperty("http.proxyPort")) != null) {
                proxyPort = Integer.parseInt(s);
            }
            if (proxyHost != null) {
                this.proxy = new HttpHost(proxyHost, proxyPort >= 0 ? proxyPort : 80);
                String bypassListStr = null;
                Parameter bypassListParam = transportOut.getParameter("http.nonProxyHosts");
                bypassListStr = bypassListParam == null ? System.getProperty("http.nonProxyHosts") : (String)bypassListParam.getValue();
                if (bypassListStr != null) {
                    this.proxyBypass = bypassListStr.split("\\|");
                }
                Parameter proxyUsernameParam = transportOut.getParameter("http.proxy.username");
                Parameter proxyPasswordParam = transportOut.getParameter("http.proxy.password");
                if (proxyUsernameParam != null) {
                    this.proxyCredentials = new UsernamePasswordCredentials((String)proxyUsernameParam.getValue(), proxyPasswordParam != null ? (String)proxyPasswordParam.getValue() : "");
                }
            }
        }
        return new ProxyConfig(this.proxy, this.proxyCredentials, this.proxyBypass, proxyProfileConfigMap);
    }

    private Map<String, ProxyProfileConfig> getProxyProfiles(TransportOutDescription transportOut) throws AxisFault {
        Parameter proxyProfilesParam = transportOut.getParameter("proxyProfiles");
        if (proxyProfilesParam == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + " Loading proxy profiles for the HTTP/S sender"));
        }
        OMElement proxyProfilesParamEle = proxyProfilesParam.getParameterElement();
        Iterator profiles = proxyProfilesParamEle.getChildrenWithName(Q_PROFILE);
        HashMap<String, ProxyProfileConfig> proxyProfileMap = new HashMap<String, ProxyProfileConfig>();
        while (profiles.hasNext()) {
            String[] targetHosts;
            OMElement profile = (OMElement)profiles.next();
            OMElement targetHostsEle = profile.getFirstChildWithName(Q_TARGET_HOSTS);
            if (targetHostsEle == null || targetHostsEle.getText().isEmpty()) {
                String msg = "Each proxy profile must define at least one host or a wildcard matcher under the targetHosts element";
                log.error((Object)(this.name + " " + msg));
                throw new AxisFault(msg);
            }
            HttpHost proxy = this.getHttpProxy(profile, targetHostsEle.getText());
            UsernamePasswordCredentials proxyCredentials = this.getUsernamePasswordCredentials(profile);
            Set<String> proxyBypass = this.getProxyBypass(profile);
            ProxyProfileConfig proxyProfileConfig = new ProxyProfileConfig(proxy, proxyCredentials, proxyBypass);
            for (String endpoint : targetHosts = targetHostsEle.getText().split(",")) {
                if (!proxyProfileMap.containsKey(endpoint = endpoint.trim())) {
                    proxyProfileMap.put(endpoint, proxyProfileConfig);
                    continue;
                }
                log.warn((Object)(this.name + " Multiple proxy profiles were found for the endpoint: " + endpoint + ". Ignoring the excessive profiles."));
            }
        }
        if (proxyProfileMap.size() > 0) {
            log.info((Object)(this.name + " Proxy profiles initialized for " + proxyProfileMap.size() + " targetHosts"));
            return proxyProfileMap;
        }
        return null;
    }

    private HttpHost getHttpProxy(OMElement profile, String targetHosts) throws AxisFault {
        OMElement proxyPortEle;
        String proxyHost;
        OMElement proxyHostEle = profile.getFirstChildWithName(Q_PROXY_HOST);
        if (proxyHostEle != null) {
            proxyHost = proxyHostEle.getText();
            proxyPortEle = profile.getFirstChildWithName(Q_PROXY_PORT);
            if (proxyPortEle == null) {
                throw new AxisFault("Proxy Port didn't configure correctly in proxy profile [" + targetHosts + "]");
            }
        } else {
            throw new AxisFault("Proxy Host didn't configure correctly in proxy profile [" + targetHosts + "]");
        }
        String proxyPortStr = proxyPortEle.getText();
        int proxyPort = Integer.parseInt(proxyPortStr);
        return new HttpHost(proxyHost, proxyPort >= 0 ? proxyPort : 80);
    }

    private UsernamePasswordCredentials getUsernamePasswordCredentials(OMElement profile) {
        UsernamePasswordCredentials proxyCredentials = null;
        OMElement proxyUserNameEle = profile.getFirstChildWithName(Q_PROXY_USER);
        if (proxyUserNameEle != null) {
            String proxyUserName = proxyUserNameEle.getText();
            OMElement proxyPasswordEle = profile.getFirstChildWithName(Q_PROXY_PASSWORD);
            String proxyPassword = proxyPasswordEle != null ? proxyPasswordEle.getText() : "";
            proxyCredentials = new UsernamePasswordCredentials(proxyUserName, proxyPassword != null ? proxyPassword : "");
        }
        return proxyCredentials;
    }

    private Set<String> getProxyBypass(OMElement profile) {
        HashSet<String> bypassSet = new HashSet<String>();
        OMElement bypassEle = profile.getFirstChildWithName(Q_BYPASS);
        if (bypassEle != null && !bypassEle.getText().isEmpty()) {
            String[] bypassHosts;
            for (String bypassHost : bypassHosts = bypassEle.getText().split(",")) {
                bypassSet.add(bypassHost.trim());
            }
        }
        return bypassSet;
    }
}

