/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.certificatevalidation.RevocationVerificationManager;
import org.apache.synapse.transport.exceptions.InvalidConfigurationException;
import org.apache.synapse.transport.http.conn.ClientConnFactory;
import org.apache.synapse.transport.http.conn.ClientSSLSetupHandler;
import org.apache.synapse.transport.http.conn.SSLContextDetails;
import org.apache.synapse.transport.nhttp.NoValidateCertTrustManager;
import org.apache.synapse.transport.nhttp.util.SecureVaultValueReader;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class ClientConnFactoryBuilder {
    private static final Log log = LogFactory.getLog(ClientConnFactoryBuilder.class);
    private final TransportOutDescription transportOut;
    private final String name;
    private SSLContextDetails ssl = null;
    private Map<String, SSLContext> sslByHostMap = null;
    private ConfigurationContext configurationContext;

    public ClientConnFactoryBuilder(TransportOutDescription transportOut, ConfigurationContext configurationContext) {
        this(transportOut);
        this.configurationContext = configurationContext;
    }

    public ClientConnFactoryBuilder(TransportOutDescription transportOut) {
        this.transportOut = transportOut;
        this.name = transportOut.getName().toUpperCase(Locale.US);
    }

    public ClientConnFactoryBuilder parseSSL() throws AxisFault {
        String configuredWeakCiphers;
        String configuredHttpsProtocols;
        String hvs;
        Parameter keyParam = this.transportOut.getParameter("keystore");
        Parameter trustParam = this.transportOut.getParameter("truststore");
        Parameter httpsProtocolsParam = this.transportOut.getParameter("HttpsProtocols");
        Parameter preferredCiphersParam = this.transportOut.getParameter("PreferredCiphers");
        OMElement ksEle = null;
        OMElement tsEle = null;
        if (keyParam != null) {
            ksEle = keyParam.getParameterElement().getFirstElement();
        }
        boolean novalidatecert = ParamUtils.getOptionalParamBoolean((ParameterInclude)this.transportOut, (String)"novalidatecert", (boolean)false);
        if (trustParam != null) {
            if (novalidatecert && log.isWarnEnabled()) {
                log.warn((Object)(this.name + " Ignoring novalidatecert parameter since a truststore has been specified"));
            }
            tsEle = trustParam.getParameterElement().getFirstElement();
        }
        SSLContext sslContext = this.createSSLContext(ksEle, tsEle, novalidatecert);
        Parameter hvp = this.transportOut.getParameter("HostnameVerifier");
        String string = hvs = hvp != null ? hvp.getValue().toString() : null;
        X509HostnameVerifier hostnameVerifier = "Strict".equalsIgnoreCase(hvs) ? ClientSSLSetupHandler.STRICT : ("AllowAll".equalsIgnoreCase(hvs) ? ClientSSLSetupHandler.ALLOW_ALL : ("DefaultAndLocalhost".equalsIgnoreCase(hvs) ? ClientSSLSetupHandler.DEFAULT_AND_LOCALHOST : ClientSSLSetupHandler.DEFAULT));
        Parameter cvp = this.transportOut.getParameter("CertificateRevocationVerifier");
        String cvEnable = cvp != null ? cvp.getParameterElement().getAttribute(new QName("enable")).getAttributeValue() : null;
        RevocationVerificationManager revocationVerifier = null;
        if ("true".equalsIgnoreCase(cvEnable)) {
            String cacheSizeString = cvp.getParameterElement().getFirstChildWithName(new QName("CacheSize")).getText();
            String cacheDelayString = cvp.getParameterElement().getFirstChildWithName(new QName("CacheDelay")).getText();
            Integer cacheSize = null;
            Integer cacheDelay = null;
            try {
                cacheSize = new Integer(cacheSizeString);
                cacheDelay = new Integer(cacheDelayString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            revocationVerifier = new RevocationVerificationManager(cacheSize, cacheDelay);
        }
        OMElement httpsProtocolsEl = httpsProtocolsParam != null ? httpsProtocolsParam.getParameterElement() : null;
        String[] httpsProtocols = null;
        String string2 = configuredHttpsProtocols = httpsProtocolsEl != null ? httpsProtocolsEl.getText() : null;
        if (configuredHttpsProtocols != null && configuredHttpsProtocols.trim().length() != 0) {
            String[] configuredValues = configuredHttpsProtocols.trim().split(",");
            ArrayList<String> protocolList = new ArrayList<String>(configuredValues.length);
            for (String protocol : configuredValues) {
                if (protocol.trim().isEmpty()) continue;
                protocolList.add(protocol.trim());
            }
            httpsProtocols = protocolList.toArray(new String[protocolList.size()]);
        }
        ClientSSLSetupHandler clientSSLSetupHandler = new ClientSSLSetupHandler(hostnameVerifier, revocationVerifier);
        if (null != httpsProtocols) {
            clientSSLSetupHandler.setHttpsProtocols(httpsProtocols);
        }
        OMElement preferredCiphersEl = preferredCiphersParam != null ? preferredCiphersParam.getParameterElement() : null;
        String[] preferredCiphers = null;
        String string3 = configuredWeakCiphers = preferredCiphersEl != null ? preferredCiphersEl.getText() : null;
        if (configuredWeakCiphers != null && configuredWeakCiphers.trim().length() != 0) {
            String[] configuredValues = configuredWeakCiphers.trim().split(",");
            ArrayList<String> ciphersList = new ArrayList<String>(configuredValues.length);
            for (String cipher : configuredValues) {
                if ((cipher = cipher.trim()).isEmpty()) continue;
                ciphersList.add(cipher);
            }
            preferredCiphers = ciphersList.toArray(new String[ciphersList.size()]);
            clientSSLSetupHandler.setPreferredCiphers(preferredCiphers);
        }
        this.ssl = new SSLContextDetails(sslContext, clientSSLSetupHandler);
        this.sslByHostMap = this.getCustomSSLContexts(this.transportOut);
        return this;
    }

    private Map<String, SSLContext> getCustomSSLContexts(TransportOutDescription transportOut) throws AxisFault {
        TransportOutDescription customSSLProfileTransport = this.loadDynamicSSLConfig(transportOut);
        Parameter customProfilesParam = customSSLProfileTransport.getParameter("customSSLProfiles");
        if (customProfilesParam == null) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.name + " Loading custom SSL profiles for the HTTPS sender"));
        }
        OMElement customProfilesElt = customProfilesParam.getParameterElement();
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)customProfilesElt, (boolean)true);
        Iterator profiles = customProfilesElt.getChildrenWithName(new QName("profile"));
        HashMap<String, SSLContext> contextMap = new HashMap<String, SSLContext>();
        while (profiles.hasNext()) {
            OMElement profile = (OMElement)profiles.next();
            OMElement serversElt = profile.getFirstChildWithName(new QName("servers"));
            if (serversElt == null || serversElt.getText() == null) {
                String msg = "Each custom SSL profile must define at least one host:port pair under the servers element";
                log.error((Object)(this.name + " " + msg));
                throw new AxisFault(msg);
            }
            String[] servers = serversElt.getText().split(",");
            OMElement ksElt = profile.getFirstChildWithName(new QName("KeyStore"));
            OMElement trElt = profile.getFirstChildWithName(new QName("TrustStore"));
            String noValCert = profile.getAttributeValue(new QName("novalidatecert"));
            boolean novalidatecert = "true".equals(noValCert);
            SSLContext sslContext = null;
            try {
                sslContext = this.createSSLContext(ksElt, trElt, novalidatecert, secretResolver);
            }
            catch (AxisFault axisFault) {
                String err = "Error occurred while creating SSL context for the servers " + serversElt.getText();
                throw new InvalidConfigurationException(err, axisFault);
            }
            for (String server : servers) {
                if (!contextMap.containsKey(server = server.trim())) {
                    contextMap.put(server, sslContext);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)(this.name + " Multiple SSL profiles were found for the server : " + server + ". Ignoring the excessive profiles."));
            }
        }
        if (contextMap.size() > 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.name + " Custom SSL profiles initialized for " + contextMap.size() + " servers"));
            }
            return contextMap;
        }
        return null;
    }

    private SSLContext createSSLContext(OMElement keyStoreElt, OMElement trustStoreElt, boolean novalidatecert) throws AxisFault {
        OMElement passwordElement;
        String type;
        String location;
        KeyManager[] keymanagers = null;
        TrustManager[] trustManagers = null;
        SecretResolver resolver = this.configurationContext != null && this.configurationContext.getAxisConfiguration() != null ? this.configurationContext.getAxisConfiguration().getSecretResolver() : SecretResolverFactory.create((OMElement)keyStoreElt, (boolean)false);
        if (keyStoreElt != null) {
            location = keyStoreElt.getFirstChildWithName(new QName("Location")).getText();
            type = keyStoreElt.getFirstChildWithName(new QName("Type")).getText();
            passwordElement = keyStoreElt.getFirstChildWithName(new QName("Password"));
            OMElement keyPasswordElement = keyStoreElt.getFirstChildWithName(new QName("KeyPassword"));
            if (passwordElement == null) {
                throw new AxisFault("Cannot proceed because Password element is missing in KeyStore");
            }
            if (keyPasswordElement == null) {
                throw new AxisFault("Cannot proceed because KeyPassword element is missing in KeyStore");
            }
            String storePassword = SecureVaultValueReader.getSecureVaultValue(resolver, passwordElement);
            String keyPassword = SecureVaultValueReader.getSecureVaultValue(resolver, keyPasswordElement);
            FileInputStream fis = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(type);
                fis = new FileInputStream(location);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.name + " Loading Identity Keystore from : " + location));
                }
                keyStore.load(fis, storePassword.toCharArray());
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(keyStore, keyPassword.toCharArray());
                keymanagers = kmfactory.getKeyManagers();
            }
            catch (GeneralSecurityException gse) {
                log.error((Object)(this.name + " Error loading Keystore : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Keystore : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                log.error((Object)(this.name + " Error opening Keystore : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Keystore : " + location, (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (trustStoreElt != null) {
            if (novalidatecert && log.isWarnEnabled()) {
                log.warn((Object)(this.name + " Ignoring novalidatecert parameter since a truststore has been specified"));
            }
            location = trustStoreElt.getFirstChildWithName(new QName("Location")).getText();
            type = trustStoreElt.getFirstChildWithName(new QName("Type")).getText();
            passwordElement = trustStoreElt.getFirstChildWithName(new QName("Password"));
            if (passwordElement == null) {
                throw new AxisFault("Cannot proceed because Password element is missing in TrustStore");
            }
            String storePassword = SecureVaultValueReader.getSecureVaultValue(resolver, passwordElement);
            FileInputStream fis = null;
            try {
                KeyStore trustStore = KeyStore.getInstance(type);
                fis = new FileInputStream(location);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.name + " Loading Trust Keystore from : " + location));
                }
                trustStore.load(fis, storePassword.toCharArray());
                TrustManagerFactory trustManagerfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerfactory.init(trustStore);
                trustManagers = trustManagerfactory.getTrustManagers();
            }
            catch (GeneralSecurityException gse) {
                log.error((Object)(this.name + " Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                log.error((Object)(this.name + " Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (novalidatecert) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(this.name + " Server certificate validation (trust) has been disabled. DO NOT USE IN PRODUCTION!"));
            }
            trustManagers = new TrustManager[]{new NoValidateCertTrustManager()};
        }
        try {
            Parameter sslpParameter = this.transportOut.getParameter("SSLProtocol");
            String sslProtocol = sslpParameter != null ? sslpParameter.getValue().toString() : "TLS";
            SSLContext sslcontext = SSLContext.getInstance(sslProtocol);
            sslcontext.init(keymanagers, trustManagers, null);
            return sslcontext;
        }
        catch (GeneralSecurityException gse) {
            log.error((Object)(this.name + " Unable to create SSL context with the given configuration"), (Throwable)gse);
            throw new AxisFault("Unable to create SSL context with the given configuration", (Throwable)gse);
        }
    }

    private SSLContext createSSLContext(OMElement keyStoreElt, OMElement trustStoreElt, boolean novalidatecert, SecretResolver secretResolver) throws AxisFault {
        TrustManager[] trustManagers;
        KeyManager[] keymanagers;
        block40: {
            String storePassword;
            String type;
            String location;
            keymanagers = null;
            trustManagers = null;
            if (keyStoreElt != null) {
                location = keyStoreElt.getFirstChildWithName(new QName("Location")).getText();
                type = keyStoreElt.getFirstChildWithName(new QName("Type")).getText();
                storePassword = SecureVaultValueReader.getSecureVaultValue(secretResolver, keyStoreElt.getFirstChildWithName(new QName("Password")));
                String keyPassword = SecureVaultValueReader.getSecureVaultValue(secretResolver, keyStoreElt.getFirstChildWithName(new QName("KeyPassword")));
                try (FileInputStream fis = new FileInputStream(location);){
                    KeyStore keyStore = KeyStore.getInstance(type);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.name + " Loading Identity Keystore from : " + location));
                    }
                    keyStore.load(fis, storePassword.toCharArray());
                    KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmfactory.init(keyStore, keyPassword.toCharArray());
                    keymanagers = kmfactory.getKeyManagers();
                }
                catch (GeneralSecurityException gse) {
                    log.error((Object)(this.name + " Error loading Keystore : " + location), (Throwable)gse);
                    throw new AxisFault("Error loading Keystore : " + location, (Throwable)gse);
                }
                catch (IOException ioe) {
                    log.error((Object)(this.name + " Error opening Keystore : " + location), (Throwable)ioe);
                    throw new AxisFault("Error opening Keystore : " + location, (Throwable)ioe);
                }
            }
            if (trustStoreElt != null) {
                if (novalidatecert && log.isWarnEnabled()) {
                    log.warn((Object)(this.name + " Ignoring novalidatecert parameter since a truststore has been specified"));
                }
                location = trustStoreElt.getFirstChildWithName(new QName("Location")).getText();
                type = trustStoreElt.getFirstChildWithName(new QName("Type")).getText();
                storePassword = SecureVaultValueReader.getSecureVaultValue(secretResolver, trustStoreElt.getFirstChildWithName(new QName("Password")));
                try (FileInputStream fis = new FileInputStream(location);){
                    KeyStore trustStore = KeyStore.getInstance(type);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.name + " Loading Trust Keystore from : " + location));
                    }
                    trustStore.load(fis, storePassword.toCharArray());
                    TrustManagerFactory trustManagerfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerfactory.init(trustStore);
                    trustManagers = trustManagerfactory.getTrustManagers();
                    break block40;
                }
                catch (GeneralSecurityException gse) {
                    log.error((Object)(this.name + " Error loading Key store : " + location), (Throwable)gse);
                    throw new AxisFault("Error loading Key store : " + location, (Throwable)gse);
                }
                catch (IOException ioe) {
                    log.error((Object)(this.name + " Error opening Key store : " + location), (Throwable)ioe);
                    throw new AxisFault("Error opening Key store : " + location, (Throwable)ioe);
                }
            }
            if (novalidatecert) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)(this.name + " Server certificate validation (trust) has been disabled. DO NOT USE IN PRODUCTION!"));
                }
                trustManagers = new TrustManager[]{new NoValidateCertTrustManager()};
            }
        }
        try {
            Parameter sslpParameter = this.transportOut.getParameter("SSLProtocol");
            String sslProtocol = sslpParameter != null ? sslpParameter.getValue().toString() : "TLS";
            SSLContext sslcontext = SSLContext.getInstance(sslProtocol);
            sslcontext.init(keymanagers, trustManagers, null);
            return sslcontext;
        }
        catch (GeneralSecurityException gse) {
            log.error((Object)(this.name + " Unable to create SSL context with the given configuration"), (Throwable)gse);
            throw new AxisFault("Unable to create SSL context with the given configuration", (Throwable)gse);
        }
    }

    public ClientConnFactory createConnFactory(HttpParams params) {
        if (this.ssl != null) {
            return new ClientConnFactory(this.ssl, this.sslByHostMap, params);
        }
        return new ClientConnFactory(params);
    }

    public TransportOutDescription loadDynamicSSLConfig(TransportOutDescription transportOut) {
        Parameter profilePathParam = transportOut.getParameter("dynamicSSLProfilesConfig");
        if (profilePathParam == null) {
            return transportOut;
        }
        OMElement pathEl = profilePathParam.getParameterElement();
        String path = pathEl.getFirstChildWithName(new QName("filePath")).getText();
        try {
            if (path != null) {
                String separator = path.startsWith(System.getProperty("file.separator")) ? "" : System.getProperty("file.separator");
                String fullPath = System.getProperty("user.dir") + separator + path;
                OMElement profileEl = new StAXOMBuilder(fullPath).getDocumentElement();
                Parameter profileParam = new Parameter();
                profileParam.setParameterElement(profileEl);
                profileParam.setName("customSSLProfiles");
                profileParam.setValue((Object)profileEl);
                transportOut.addParameter(profileParam);
                log.info((Object)("customSSLProfiles configuration is loaded from path: " + fullPath));
                return transportOut;
            }
        }
        catch (XMLStreamException xmlEx) {
            log.error((Object)("XMLStreamException - Could not load customSSLProfiles from file path: " + path), (Throwable)xmlEx);
        }
        catch (FileNotFoundException fileEx) {
            log.error((Object)("FileNotFoundException - Could not load customSSLProfiles from file path: " + path), (Throwable)fileEx);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("AxisFault - Could not load customSSLProfiles from file path: " + path), (Throwable)axisFault);
        }
        catch (Exception ex) {
            log.error((Object)("Exception - Could not load customSSLProfiles from file path: " + path), (Throwable)ex);
        }
        return null;
    }
}

