/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.apache.synapse.transport.nhttp.HttpCoreRequestResponseTransport;
import org.apache.synapse.transport.nhttp.HttpGetRequestProcessor;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerHandler;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;
import org.apache.synapse.transport.nhttp.util.RESTUtil;

public class ServerWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ServerWorker.class);
    private final ConfigurationContext cfgCtx;
    private final String schemeName;
    private final MetricsCollector metrics;
    private final ServerHandler serverHandler;
    private final NHttpServerConnection conn;
    private final HttpRequest request;
    private final HttpResponse response;
    private final InputStream is;
    private final OutputStream os;
    private boolean isRestDispatching;
    private HttpGetRequestProcessor httpGetRequestProcessor;
    private final MessageContext msgContext;
    private static final String SOAPACTION = "SOAPAction";
    private static final String LOCATION = "Location";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_XML = "text/xml";
    private String remoteAddress = null;

    public ServerWorker(ConfigurationContext cfgCtx, String schemeName, MetricsCollector metrics, NHttpServerConnection conn, ServerHandler serverHandler, HttpRequest request, InputStream is, HttpResponse response, OutputStream os, boolean isRestDispatching, HttpGetRequestProcessor httpGetRequestProcessor) {
        this.cfgCtx = cfgCtx;
        this.schemeName = schemeName;
        this.metrics = metrics;
        this.conn = conn;
        this.serverHandler = serverHandler;
        this.request = request;
        this.response = response;
        this.is = is;
        this.os = os;
        this.isRestDispatching = isRestDispatching;
        this.httpGetRequestProcessor = httpGetRequestProcessor;
        this.msgContext = this.createMessageContext(request);
        conn.getContext().setAttribute("SERVER_WORKER_INIT_TIME", (Object)System.currentTimeMillis());
    }

    private MessageContext createMessageContext(HttpRequest request) {
        MessageContext msgContext = new MessageContext();
        msgContext.setMessageID(UIDGenerator.generateURNString());
        msgContext.setProperty("ClientApiNonBlocking", (Object)Boolean.FALSE);
        msgContext.setConfigurationContext(this.cfgCtx);
        if ("https".equalsIgnoreCase(this.schemeName)) {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("https"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("https"));
            msgContext.setIncomingTransportName("https");
            SSLIOSession session = (SSLIOSession)this.conn.getContext().getAttribute("http.session.ssl");
            if (session != null && msgContext.getTransportIn() != null && msgContext.getTransportIn().getParameter("SSLVerifyClient") != null) {
                try {
                    msgContext.setProperty("ssl.client.auth.cert.X509", (Object)session.getSSLSession().getPeerCertificateChain());
                }
                catch (SSLPeerUnverifiedException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Peer certificate chain is not available for MsgContext " + msgContext.getMessageID()));
                    }
                }
            }
        } else {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("http"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("http"));
            msgContext.setIncomingTransportName("http");
        }
        msgContext.setProperty("OutTransportInfo", (Object)this);
        msgContext.setServerSide(true);
        msgContext.setProperty("TransportInURL", (Object)request.getRequestLine().getUri());
        TreeMap<String, String> headers = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (Header header : request.getAllHeaders()) {
            String headerName = header.getName();
            if (headers.containsKey(headerName)) {
                Object map;
                String key = "EXCESS_TRANSPORT_HEADERS";
                String oldValue = (String)headers.get(headerName);
                if (msgContext.getProperty(key) != null) {
                    map = (Map)msgContext.getProperty(key);
                    map.put(headerName, oldValue);
                } else {
                    map = new MultiValueMap();
                    map.put(headerName, oldValue);
                    msgContext.setProperty(key, map);
                }
            }
            headers.put(header.getName(), header.getValue());
        }
        msgContext.setProperty("TRANSPORT_HEADERS", headers);
        if (this.conn instanceof HttpInetConnection) {
            HttpContext httpContext = this.conn.getContext();
            HttpInetConnection inetConn = (HttpInetConnection)this.conn;
            InetAddress remoteAddr = inetConn.getRemoteAddress();
            if (remoteAddr != null) {
                httpContext.setAttribute("CLIENT_REMOTE_ADDR", (Object)remoteAddr);
                httpContext.setAttribute("CLIENT_REMOTE_PORT", (Object)inetConn.getRemotePort());
                msgContext.setProperty("REMOTE_ADDR", (Object)remoteAddr.getHostAddress());
                msgContext.setProperty("REMOTE_HOST", (Object)NhttpUtil.getHostName(remoteAddr));
                this.remoteAddress = remoteAddr.getHostAddress();
            }
        }
        msgContext.setProperty("RequestResponseTransportControl", (Object)new HttpCoreRequestResponseTransport(msgContext));
        msgContext.setProperty("synapse.server-connection-debug", this.conn.getContext().getAttribute("synapse.server-connection-debug"));
        msgContext.setProperty("nhttp.input.stream", (Object)this.is);
        msgContext.setProperty("nhttp.output.stream", (Object)this.os);
        return msgContext;
    }

    @Override
    public void run() {
        HttpInetConnection inetConn;
        InetAddress localAddr;
        CustomLogSetter.getInstance().clearThreadLocalContent();
        this.conn.getContext().setAttribute("SERVER_WORKER_START_TIME", (Object)System.currentTimeMillis());
        this.conn.getContext().setAttribute("SERVER_WORKER_THREAD_ID", (Object)Thread.currentThread().getId());
        String method = this.request.getRequestLine().getMethod().toUpperCase();
        this.msgContext.setProperty("HTTP_METHOD", (Object)this.request.getRequestLine().getMethod());
        if (NHttpConfiguration.getInstance().isHttpMethodDisabled(method)) {
            this.handleException("Unsupported method : " + method, null);
        }
        String oriUri = this.request.getRequestLine().getUri();
        String restUrlPostfix = NhttpUtil.getRestUrlPostfix(oriUri, this.cfgCtx.getServicePath());
        this.msgContext.setProperty("REST_URL_POSTFIX", (Object)restUrlPostfix);
        String servicePrefix = oriUri.substring(0, oriUri.indexOf(restUrlPostfix));
        if (servicePrefix.indexOf("://") == -1 && (localAddr = (inetConn = (HttpInetConnection)this.conn).getLocalAddress()) != null) {
            servicePrefix = this.schemeName + "://" + localAddr.getHostName() + ":" + inetConn.getLocalPort() + servicePrefix;
        }
        this.msgContext.setProperty("SERVICE_PREFIX", (Object)servicePrefix);
        if ("GET".equals(method)) {
            this.httpGetRequestProcessor.process(this.request, this.response, this.msgContext, this.conn, this.os, this.isRestDispatching);
        } else if ("POST".equals(method)) {
            this.processEntityEnclosingMethod();
        } else if ("PUT".equals(method)) {
            this.processEntityEnclosingMethod();
        } else if ("HEAD".equals(method)) {
            this.processNonEntityEnclosingMethod();
        } else if ("OPTIONS".equals(method)) {
            this.processNonEntityEnclosingMethod();
        } else if ("DELETE".equals(method)) {
            this.processGetAndDelete("DELETE");
        } else if ("TRACE".equals(method)) {
            this.processNonEntityEnclosingMethod();
        } else if ("PATCH".equals(method)) {
            this.processEntityEnclosingMethod();
        } else {
            this.handleException("Unsupported method : " + method, null);
        }
        if (this.isAckRequired()) {
            String respWritten = "";
            if (this.msgContext.getOperationContext() != null) {
                respWritten = (String)this.msgContext.getOperationContext().getProperty("RESPONSE_WRITTEN");
            }
            boolean respWillFollow = !"true".equals(respWritten) && !"SKIP".equals(respWritten);
            boolean acked = ((RequestResponseTransport)this.msgContext.getProperty("RequestResponseTransportControl")).getStatus() == RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            boolean forced = this.msgContext.isPropertyTrue("FORCE_SC_ACCEPTED");
            boolean nioAck = this.msgContext.isPropertyTrue("NIO-ACK-Requested", false);
            if (respWillFollow || acked || forced || nioAck) {
                if (!nioAck) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending 202 Accepted response for MessageID : " + this.msgContext.getMessageID() + " response written : " + respWritten + " response will follow : " + respWillFollow + " acked : " + acked + " forced ack : " + forced));
                    }
                    this.response.setStatusCode(202);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending ACK response with status " + this.msgContext.getProperty("HTTP_SC") + ", for MessageID : " + this.msgContext.getMessageID()));
                    }
                    this.response.setStatusCode(Integer.parseInt(this.msgContext.getProperty("HTTP_SC").toString()));
                    Map responseHeaders = (Map)this.msgContext.getProperty("TRANSPORT_HEADERS");
                    if (responseHeaders != null) {
                        for (String headerName : responseHeaders.keySet()) {
                            this.response.addHeader(headerName, (String)responseHeaders.get(headerName));
                            String excessProp = "EXCESS_TRANSPORT_HEADERS";
                            Map map = (Map)this.msgContext.getProperty(excessProp);
                            if (map == null) continue;
                            log.debug((Object)("Number of excess values for " + headerName + " header is : " + ((Collection)map.get(headerName)).size()));
                            for (String key : map.keySet()) {
                                for (String excessVal : (Collection)map.get(key)) {
                                    this.response.addHeader(headerName, excessVal);
                                }
                            }
                        }
                    }
                }
                if (this.metrics != null) {
                    this.metrics.incrementMessagesSent();
                }
                try {
                    this.response.removeHeaders("Transfer-Encoding");
                    this.response.removeHeaders("Content-Length");
                    this.serverHandler.commitResponse(this.conn, this.response);
                }
                catch (HttpException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    this.handleException("Unexpected HTTP protocol error : " + e.getMessage(), (Exception)((Object)e));
                }
                catch (ConnectionClosedException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    log.warn((Object)"Connection closed by client (Connection closed)");
                }
                catch (IllegalStateException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    log.warn((Object)"Connection closed by client (Buffer closed)");
                }
                catch (IOException e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    this.handleException("IO Error sending response message", e);
                }
                catch (Exception e) {
                    if (this.metrics != null) {
                        this.metrics.incrementFaultsSending();
                    }
                    this.handleException("General Error sending response message", e);
                }
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    this.os.flush();
                    this.os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isAckRequired() {
        if (this.msgContext != null) {
            if (this.msgContext.getOperationContext() != null && (!this.msgContext.getOperationContext().getAxisOperation().isControlOperation() || this.msgContext.isPropertyTrue("FORCE_SC_ACCEPTED"))) {
                return true;
            }
            if (this.msgContext.isPropertyTrue("NIO-ACK-Requested", false)) {
                return true;
            }
        }
        return false;
    }

    private void processEntityEnclosingMethod() {
        try {
            Header contentType = this.request.getFirstHeader(CONTENT_TYPE);
            String contentTypeStr = contentType != null ? contentType.getValue() : this.inferContentType();
            String charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentTypeStr);
            this.msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEncoding);
            if (HTTPTransportUtils.isRESTRequest((String)contentTypeStr) || this.isRest(contentTypeStr)) {
                RESTUtil.processPOSTRequest(this.msgContext, this.is, this.os, this.request.getRequestLine().getUri(), contentTypeStr, this.isRestDispatching);
            } else {
                Header soapAction = this.request.getFirstHeader(SOAPACTION);
                HTTPTransportUtils.processHTTPPostRequest((MessageContext)this.msgContext, (InputStream)this.is, (OutputStream)this.os, (String)contentTypeStr, (String)(soapAction != null ? soapAction.getValue() : null), (String)this.request.getRequestLine().getUri());
            }
        }
        catch (Exception e) {
            this.handleException("Error processing POST request ", e);
        }
    }

    private boolean isRest(String contentType) {
        return contentType != null && contentType.indexOf(TEXT_XML) == -1 && contentType.indexOf("application/soap+xml") == -1;
    }

    private String inferContentType() {
        Parameter param = this.cfgCtx.getAxisConfiguration().getParameter("DEFAULT_REQUEST_CONTENT_TYPE");
        if (param != null) {
            return param.getValue().toString();
        }
        return null;
    }

    private void processNonEntityEnclosingMethod() {
        try {
            RESTUtil.processURLRequest(this.msgContext, this.os, null, this.request.getRequestLine().getUri());
        }
        catch (AxisFault e) {
            this.handleException("Error processing " + this.request.getRequestLine().getMethod() + " request for : " + this.request.getRequestLine().getUri(), (Exception)((Object)e));
        }
    }

    private void processGetAndDelete(String method) {
        try {
            RESTUtil.processGetAndDeleteRequest(this.msgContext, this.os, this.request.getRequestLine().getUri(), this.request.getFirstHeader(CONTENT_TYPE), method, this.isRestDispatching);
        }
        catch (AxisFault axisFault) {
            this.handleException("Error processing " + method + " request for: " + this.request.getRequestLine().getUri(), (Exception)((Object)axisFault));
        }
    }

    private void handleException(String msg, Exception e) {
        if (e == null) {
            log.error((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        Exception newException = e;
        if (e == null) {
            newException = new Exception(msg);
        }
        try {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)this.msgContext, (Throwable)newException);
            AxisEngine.sendFault((MessageContext)faultContext);
        }
        catch (Exception ex) {
            this.response.setStatusCode(500);
            this.response.addHeader(CONTENT_TYPE, TEXT_XML);
            this.conn.getContext().setAttribute("FORCE_CONNECTION_CLOSE", (Object)true);
            this.serverHandler.commitResponseHideExceptions(this.conn, this.response);
            try {
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                String body = "<html><body><h1>Failed to process the request</h1><p>" + msg + "</p>";
                if (e != null) {
                    body = body + "<p>" + e.getMessage() + "</p></body></html>";
                }
                if (ex != null) {
                    body = body + "<p>" + ex.getMessage() + "</p></body></html>";
                }
                this.os.write(body.getBytes());
                this.os.flush();
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public InputStream getIs() {
        return this.is;
    }

    public ServerHandler getServiceHandler() {
        return this.serverHandler;
    }

    public NHttpServerConnection getConn() {
        return this.conn;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }
}

