/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.entity.ContentInputStream;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SharedInputBuffer;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EncodingUtils;
import org.apache.synapse.commons.evaluators.EvaluatorContext;
import org.apache.synapse.commons.evaluators.Parser;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.jmx.ThreadingView;
import org.apache.synapse.transport.http.conn.Scheme;
import org.apache.synapse.transport.nhttp.ListenerContext;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.NhttpSharedOutputBuffer;
import org.apache.synapse.transport.nhttp.ServerWorker;
import org.apache.synapse.transport.nhttp.debug.ServerConnectionDebug;
import org.apache.synapse.transport.nhttp.util.LatencyCollector;
import org.apache.synapse.transport.nhttp.util.LatencyView;
import org.apache.synapse.transport.nhttp.util.NhttpMetricsCollector;

public class ServerHandler
implements NHttpServerEventHandler {
    private static final Log log = LogFactory.getLog(ServerHandler.class);
    private final ConfigurationContext cfgCtx;
    private final Scheme scheme;
    private final ListenerContext listenerContext;
    private final HttpResponseFactory responseFactory;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    private final ByteBufferAllocator allocator;
    private final WorkerPool workerPool;
    private final NhttpMetricsCollector metrics;
    private static boolean isMessageSizeValidationEnabled = false;
    private static int validMaxMessageSize = Integer.MAX_VALUE;
    private final Parser parser;
    private final PriorityExecutor executor;
    private final List<NHttpServerConnection> activeConnections;
    private final LatencyView latencyView;
    private final LatencyView s2sLatencyView;
    private final ThreadingView threadingView;
    public static final String REQUEST_SINK_BUFFER = "synapse.request-sink-buffer";
    public static final String RESPONSE_SOURCE_BUFFER = "synapse.response-source-buffer";
    public static final String CONNECTION_CREATION_TIME = "synapse.connectionCreationTime";
    public static final String SERVER_CONNECTION_DEBUG = "synapse.server-connection-debug";
    public static final String HTTP_REQUEST = "http.request";
    private final int bufferSize;
    private final int socketTimeout;

    public ServerHandler(ConfigurationContext cfgCtx, Scheme scheme, ListenerContext listenerContext, NhttpMetricsCollector metrics) {
        this.cfgCtx = cfgCtx;
        this.scheme = scheme;
        this.listenerContext = listenerContext;
        this.metrics = metrics;
        this.responseFactory = new DefaultHttpResponseFactory();
        this.httpProcessor = this.getHttpProcessor();
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.allocator = new HeapByteBufferAllocator();
        this.activeConnections = new ArrayList<NHttpServerConnection>();
        String strNamePostfix = "";
        if (listenerContext.getTransportIn() != null && listenerContext.getTransportIn().getName() != null) {
            strNamePostfix = "-" + listenerContext.getTransportIn().getName();
        }
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        boolean enableAdvancedForLatencyView = cfg.getBooleanValue("synapse.nhttp.latency_view.enable_advanced_view", false);
        boolean enableAdvancedForS2SView = cfg.getBooleanValue("synapse.nhttp.s2slatency_view.enable_advanced_view", false);
        this.latencyView = new LatencyView("NHTTPLatencyView", scheme.isSSL(), strNamePostfix, enableAdvancedForLatencyView);
        this.s2sLatencyView = new LatencyView("NHTTPS2SLatencyView", scheme.isSSL(), strNamePostfix, enableAdvancedForS2SView);
        this.threadingView = new ThreadingView("HttpServerWorker", true, 50.0);
        if (listenerContext.getExecutor() == null) {
            this.workerPool = WorkerPoolFactory.getWorkerPool((int)cfg.getServerCoreThreads(), (int)cfg.getServerMaxThreads(), (int)cfg.getServerKeepalive(), (int)cfg.getServerQueueLen(), (String)"Server Worker thread group", (String)"HttpServerWorker");
            this.executor = null;
            this.parser = null;
        } else {
            this.workerPool = null;
            this.executor = listenerContext.getExecutor();
            this.parser = listenerContext.getParser();
        }
        isMessageSizeValidationEnabled = cfg.getMessageSizeValidationEnabled();
        if (isMessageSizeValidationEnabled) {
            try {
                validMaxMessageSize = cfg.getMaxMessageSize();
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Invalid max message size configured for property \"valid.max.message.size.in.bytes\", setting the Integer MAX_VALUE as the valid maximum message size", (Throwable)e);
                validMaxMessageSize = Integer.MAX_VALUE;
            }
        }
        this.bufferSize = cfg.getBufferSize();
        this.socketTimeout = cfg.getProperty("http.socket.timeout.sender", 60000);
    }

    public void requestReceived(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        context.setAttribute("REQ_ARRIVAL_TIME", (Object)System.currentTimeMillis());
        context.setAttribute("REQ_FROM_CLIENT_READ_START_TIME", (Object)System.currentTimeMillis());
        HttpRequest request = conn.getHttpRequest();
        context.setAttribute(HTTP_REQUEST, (Object)request);
        context.setAttribute("message-in-flight", (Object)"true");
        if (isMessageSizeValidationEnabled) {
            context.setAttribute("MESSAGE_SIZE_VALIDATION_SUM", (Object)0);
        }
        conn.getContext().setAttribute(SERVER_CONNECTION_DEBUG, (Object)new ServerConnectionDebug(conn));
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        try {
            ContentInputStream is;
            if (request instanceof HttpEntityEnclosingRequest) {
                conn.getContext().setAttribute("REQUEST_READ", (Object)Boolean.FALSE);
                SharedInputBuffer inputBuffer = new SharedInputBuffer(cfg.getBufferSize(), (IOControl)conn, this.allocator);
                context.setAttribute(REQUEST_SINK_BUFFER, (Object)inputBuffer);
                is = new ContentInputStream((ContentInputBuffer)inputBuffer);
            } else {
                is = null;
                conn.getContext().removeAttribute("REQUEST_READ");
            }
            NhttpSharedOutputBuffer outputBuffer = new NhttpSharedOutputBuffer(this.bufferSize, (IOControl)conn, this.allocator, this.socketTimeout);
            context.setAttribute(RESPONSE_SOURCE_BUFFER, (Object)outputBuffer);
            ContentOutputStream os = new ContentOutputStream((ContentOutputBuffer)outputBuffer);
            ProtocolVersion httpVersion = request.getRequestLine().getProtocolVersion();
            HttpResponse response = this.responseFactory.newHttpResponse(httpVersion, 200, context);
            BasicHttpEntity entity = new BasicHttpEntity();
            if (httpVersion.greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                entity.setChunked(true);
            }
            response.setEntity((HttpEntity)entity);
            if (this.metrics != null) {
                this.metrics.incrementMessagesReceived();
            }
            ServerWorker worker = new ServerWorker(this.cfgCtx, this.scheme.getName(), this.metrics, conn, this, request, (InputStream)is, response, (OutputStream)os, this.listenerContext.isRestDispatching(), this.listenerContext.getHttpGetRequestProcessor());
            if (this.workerPool != null) {
                this.workerPool.execute((Runnable)worker);
            } else if (this.executor != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Header header : request.getAllHeaders()) {
                    headers.put(header.getName(), header.getValue());
                }
                EvaluatorContext evaluatorContext = new EvaluatorContext(request.getRequestLine().getUri(), headers);
                int priority = this.parser.parse(evaluatorContext);
                this.executor.execute((Runnable)worker, priority);
            }
            Header expect = request.getFirstHeader("Expect");
            if (expect != null && "100-continue".equalsIgnoreCase(expect.getValue())) {
                BasicHttpResponse ack = new BasicHttpResponse(request.getProtocolVersion(), 100, "Continue");
                conn.submitResponse((HttpResponse)ack);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(conn + ": Expect :100 Continue hit, sending ack back to the server"));
                }
                return;
            }
        }
        catch (Exception e) {
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
            this.handleException("Error processing request received for : " + request.getRequestLine().getUri(), e, conn);
        }
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        HttpContext context = conn.getContext();
        ContentInputBuffer inBuf = (ContentInputBuffer)context.getAttribute(REQUEST_SINK_BUFFER);
        try {
            int bytesRead = inBuf.consumeContent(decoder);
            if (isMessageSizeValidationEnabled) {
                HttpContext httpContext = conn.getContext();
                if (httpContext.getAttribute("MESSAGE_SIZE_VALIDATION_SUM") == null) {
                    httpContext.setAttribute("MESSAGE_SIZE_VALIDATION_SUM", (Object)0);
                }
                int messageSizeSum = (Integer)httpContext.getAttribute("MESSAGE_SIZE_VALIDATION_SUM");
                if ((messageSizeSum += bytesRead) > validMaxMessageSize) {
                    log.warn((Object)("Payload exceeds valid payload size range, hence discontinuing chunk stream at " + messageSizeSum + " bytes to prevent OOM."));
                    this.dropServerConnection(conn);
                    conn.getContext().setAttribute("CONNECTION_DROPPED", (Object)true);
                    ((SharedInputBuffer)inBuf).close();
                }
                httpContext.setAttribute("MESSAGE_SIZE_VALIDATION_SUM", (Object)messageSizeSum);
            }
            if (this.metrics != null && bytesRead > 0) {
                this.metrics.incrementBytesReceived(bytesRead);
            }
            if (decoder.isCompleted()) {
                ((ServerConnectionDebug)conn.getContext().getAttribute(SERVER_CONNECTION_DEBUG)).recordRequestCompletionTime();
                context.setAttribute("REQUEST_READ", (Object)Boolean.TRUE);
                context.setAttribute("REQ_FROM_CLIENT_READ_END_TIME", (Object)System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
            this.handleException("I/O Error at inputReady : " + e.getMessage(), e, conn);
        }
    }

    private void updateLatencyView(HttpContext context) {
        if (context == null) {
            return;
        }
        this.latencyView.notifyTimes(new LatencyCollector(context, false));
        this.s2sLatencyView.notifyTimes(new LatencyCollector(context, true));
        LatencyCollector.clearTimestamps(context);
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        ContentOutputBuffer outBuf = (ContentOutputBuffer)context.getAttribute(RESPONSE_SOURCE_BUFFER);
        if (outBuf == null) {
            this.shutdownConnection(conn, false, null);
            return;
        }
        try {
            int bytesWritten = outBuf.produceContent(encoder);
            if (this.metrics != null && bytesWritten > 0) {
                this.metrics.incrementBytesSent(bytesWritten);
            }
            if (encoder.isCompleted()) {
                long currentTime = System.currentTimeMillis();
                context.setAttribute("RES_TO_CLIENT_WRITE_END_TIME", (Object)currentTime);
                context.setAttribute("RES_DEPARTURE_TIME", (Object)currentTime);
                this.updateLatencyView(context);
                context.removeAttribute("REQ_ARRIVAL_TIME");
                context.removeAttribute("REQ_DEPARTURE_TIME");
                context.removeAttribute("RES_ARRIVAL_TIME");
                ((ServerConnectionDebug)conn.getContext().getAttribute(SERVER_CONNECTION_DEBUG)).recordResponseCompletionTime();
                Boolean reqRead = (Boolean)conn.getContext().getAttribute("REQUEST_READ");
                Boolean forceConnectionClose = (Boolean)conn.getContext().getAttribute("FORCE_CONNECTION_CLOSE");
                if (reqRead != null && !reqRead.booleanValue()) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                } else if (!this.connStrategy.keepAlive(response, context)) {
                    conn.close();
                } else if (forceConnectionClose != null && forceConnectionClose.booleanValue()) {
                    conn.close();
                } else {
                    conn.requestInput();
                }
            }
        }
        catch (IOException e) {
            if (this.metrics != null) {
                this.metrics.incrementFaultsSending();
            }
            this.handleException("I/O Error at outputReady : " + e.getMessage(), e, conn);
        }
    }

    public void commitResponseHideExceptions(NHttpServerConnection conn, HttpResponse response) {
        try {
            conn.suspendInput();
            this.httpProcessor.process(response, conn.getContext());
            conn.submitResponse(response);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error : " + e.getMessage(), (Exception)((Object)e), conn);
        }
        catch (IOException e) {
            this.handleException("IO error submiting response : " + e.getMessage(), e, conn);
        }
    }

    public void commitResponse(NHttpServerConnection conn, HttpResponse response) throws IOException, HttpException {
        try {
            BasicHttpEntity entity = (BasicHttpEntity)response.getEntity();
            Header[] headers = response.getAllHeaders();
            int contentLength = -1;
            if (this.canResponseHaveBody(response, conn)) {
                if (entity == null) {
                    entity = new BasicHttpEntity();
                }
                for (Header header : headers) {
                    if (!header.getName().equals("Content-Length") || Integer.parseInt(header.getValue()) <= 0) continue;
                    contentLength = Integer.parseInt(header.getValue());
                    response.removeHeader(header);
                }
                if (contentLength != -1) {
                    entity.setChunked(false);
                    entity.setContentLength((long)contentLength);
                } else {
                    entity.setChunked(true);
                }
            } else if (entity != null) {
                entity.setChunked(false);
                entity.setContentLength((long)contentLength);
            }
            response.setEntity((HttpEntity)entity);
            conn.suspendInput();
            HttpContext context = conn.getContext();
            this.httpProcessor.process(response, context);
            conn.getContext().setAttribute("RES_TO_CLIENT_WRITE_START_TIME", (Object)System.currentTimeMillis());
            conn.submitResponse(response);
        }
        catch (HttpException e) {
            this.shutdownConnection(conn, true, e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.shutdownConnection(conn, true, e.getMessage());
            throw e;
        }
    }

    public void timeout(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        Boolean read = (Boolean)context.getAttribute("REQUEST_READ");
        if (read == null || read.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(conn + ": Keepalive connection was closed"));
            }
            this.shutdownConnection(conn, false, null);
        } else {
            String msg = "Connection Timeout - before message body was fully read : " + conn;
            log.error((Object)msg);
            if (this.metrics != null) {
                this.metrics.incrementTimeoutsReceiving();
            }
            this.shutdownConnection(conn, true, msg);
        }
    }

    public void endOfInput(NHttpServerConnection conn) throws IOException {
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(NHttpServerConnection conn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(conn + ": New incoming connection"));
        }
        this.metrics.connected();
        conn.getContext().setAttribute(CONNECTION_CREATION_TIME, (Object)System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)(conn + ": Adding a connection : " + conn + " to the pool, existing pool size : " + this.activeConnections.size()));
        }
        ServerHandler serverHandler = this;
        synchronized (serverHandler) {
            this.activeConnections.add(conn);
        }
    }

    public void responseReady(NHttpServerConnection conn) {
        if (JavaUtils.isTrueExplicitly((Object)conn.getContext().getAttribute("forceClosing")) && !JavaUtils.isTrueExplicitly((Object)conn.getContext().getAttribute("message-in-flight"))) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(conn + ": Closing a persisted connection since it is forced : " + conn));
                }
                conn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        this.metrics.notifyReceivedMessageSize(conn.getMetrics().getReceivedBytesCount());
        this.metrics.notifySentMessageSize(conn.getMetrics().getSentBytesCount());
        conn.getMetrics().reset();
        conn.getContext().removeAttribute("message-in-flight");
        if (log.isTraceEnabled()) {
            log.trace((Object)(conn + ": Ready to send response"));
        }
    }

    public void closed(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        this.shutdownConnection(conn, false, null);
        context.removeAttribute(REQUEST_SINK_BUFFER);
        context.removeAttribute(RESPONSE_SOURCE_BUFFER);
        context.removeAttribute(CONNECTION_CREATION_TIME);
        context.removeAttribute(SERVER_CONNECTION_DEBUG);
        if (log.isTraceEnabled()) {
            log.trace((Object)(conn + ": Connection closed"));
        }
        this.metrics.disconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markActiveConnectionsToBeClosed() {
        log.info((Object)("Marking the closing signal on the connection pool of size : " + this.activeConnections.size()));
        ServerHandler serverHandler = this;
        synchronized (serverHandler) {
            for (NHttpServerConnection conn : this.activeConnections) {
                conn.getContext().setAttribute("forceClosing", (Object)"true");
                conn.requestOutput();
            }
        }
    }

    public void exception(NHttpServerConnection conn, Exception e) {
        String errMsg = "I/O error : " + e.getMessage();
        if (e instanceof HttpException) {
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
            HttpContext context = conn.getContext();
            HttpRequest request = conn.getHttpRequest();
            HttpVersion ver = HttpVersion.HTTP_1_0;
            if (request != null && request.getRequestLine() != null) {
                ver = request.getRequestLine().getProtocolVersion();
            }
            HttpResponse response = this.responseFactory.newHttpResponse((ProtocolVersion)ver, 400, context);
            byte[] msg = EncodingUtils.getAsciiBytes((String)("Malformed HTTP request: " + e.getMessage()));
            ByteArrayEntity entity = new ByteArrayEntity(msg);
            entity.setContentType("text/plain; charset=US-ASCII");
            response.setEntity((HttpEntity)entity);
            try {
                this.commitResponseHideExceptions(conn, response);
            }
            catch (Exception exception) {}
        } else if (e instanceof ConnectionClosedException || e.getMessage() != null && (e.getMessage().contains("Connection reset by peer") || e.getMessage().contains("forcibly closed"))) {
            if (log.isDebugEnabled()) {
                errMsg = "I/O error (Probably the keepalive connection was closed):" + e.getMessage();
                log.debug((Object)errMsg);
            }
            this.shutdownConnection(conn, true, errMsg);
        } else if (e instanceof IOException && e.getMessage() != null) {
            errMsg = e.getMessage().toLowerCase();
            if (errMsg.indexOf("broken") != -1) {
                log.warn((Object)("I/O error (Probably the connection was closed by the remote party):" + e.getMessage()));
            } else {
                log.error((Object)("I/O error: " + e.getMessage()), (Throwable)e);
            }
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
            this.shutdownConnection(conn, true, errMsg);
        } else {
            errMsg = "Unexpected I/O error: " + e.getClass().getName();
            log.error((Object)errMsg, (Throwable)e);
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
            this.shutdownConnection(conn, true, errMsg);
        }
    }

    public void exception(NHttpServerConnection conn, IOException e) {
        String errMsg = "I/O error : " + e.getMessage();
        if (e instanceof ConnectionClosedException || e.getMessage() != null && (e.getMessage().contains("Connection reset by peer") || e.getMessage().contains("forcibly closed"))) {
            if (log.isDebugEnabled()) {
                errMsg = "I/O error (Probably the keepalive connection was closed):" + e.getMessage();
                log.debug((Object)errMsg);
            }
        } else if (e.getMessage() != null) {
            errMsg = e.getMessage().toLowerCase();
            if (errMsg.indexOf("broken") != -1) {
                errMsg = "I/O error (Probably the connection was closed by the remote party):" + e.getMessage();
                log.warn((Object)errMsg);
            } else {
                errMsg = "I/O error: " + e.getMessage();
                log.error((Object)errMsg, (Throwable)e);
            }
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
        } else {
            log.error((Object)("Unexpected I/O error: " + e.getClass().getName()), (Throwable)e);
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
            errMsg = "Unexpected I/O error: " + e.getMessage();
        }
        this.shutdownConnection(conn, true, errMsg);
    }

    private void handleException(String msg, Exception e, NHttpServerConnection conn) {
        log.error((Object)msg, (Throwable)e);
        if (conn != null) {
            this.shutdownConnection(conn, true, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownConnection(NHttpServerConnection conn, boolean isError, String errorMsg) {
        SharedInputBuffer inputBuffer;
        NhttpSharedOutputBuffer outputBuffer = (NhttpSharedOutputBuffer)((Object)conn.getContext().getAttribute(RESPONSE_SOURCE_BUFFER));
        if (outputBuffer != null) {
            outputBuffer.close();
        }
        if ((inputBuffer = (SharedInputBuffer)conn.getContext().getAttribute(REQUEST_SINK_BUFFER)) != null) {
            inputBuffer.close();
        }
        if (log.isWarnEnabled() && (isError || log.isDebugEnabled()) && conn instanceof HttpInetConnection) {
            String msg;
            HttpInetConnection inetConnection = (HttpInetConnection)conn;
            InetAddress remoteAddress = inetConnection.getRemoteAddress();
            int remotePort = inetConnection.getRemotePort();
            if (remotePort != -1 && remoteAddress != null) {
                msg = "Connection from remote address : " + remoteAddress + ":" + remotePort + " to local address : " + inetConnection.getLocalAddress() + ":" + inetConnection.getLocalPort() + " is closed!" + (errorMsg != null ? " - On error : " + errorMsg : "");
            } else {
                HttpContext httpContext = conn.getContext();
                msg = "Connection from remote address : " + httpContext.getAttribute("CLIENT_REMOTE_ADDR") + ":" + httpContext.getAttribute("CLIENT_REMOTE_PORT") + " to local address : " + inetConnection.getLocalAddress() + ":" + inetConnection.getLocalPort() + " is closed!" + (errorMsg != null ? " - On error : " + errorMsg : "");
            }
            if (isError) {
                log.warn((Object)msg);
            } else {
                log.debug((Object)msg);
            }
        }
        ServerHandler serverHandler = this;
        synchronized (serverHandler) {
            if (!this.activeConnections.isEmpty() && this.activeConnections.remove(conn) && log.isDebugEnabled()) {
                log.debug((Object)("Removing the connection : " + conn + " from pool of size : " + this.activeConnections.size()));
            }
        }
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getActiveConnectionsSize() {
        return this.activeConnections.size();
    }

    private HttpProcessor getHttpProcessor() {
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        return httpProcessor;
    }

    public int getActiveCount() {
        return this.workerPool.getActiveCount();
    }

    public int getQueueSize() {
        return this.workerPool.getQueueSize();
    }

    public MetricsCollector getMetrics() {
        return this.metrics;
    }

    public void stop() {
        this.latencyView.destroy();
        this.s2sLatencyView.destroy();
        this.threadingView.destroy();
        try {
            if (this.workerPool != null) {
                this.workerPool.shutdown(1000);
            } else if (this.executor != null) {
                this.executor.destroy();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean canResponseHaveBody(HttpResponse response, NHttpServerConnection conn) {
        HttpRequest httpRequest = (HttpRequest)conn.getContext().getAttribute(HTTP_REQUEST);
        if (httpRequest != null && "HEAD".equalsIgnoreCase(httpRequest.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    private void dropServerConnection(NHttpServerConnection conn) {
        String errorMessage = "Payload Too Large";
        try {
            HttpContext httpContext = conn.getContext();
            HttpResponse response = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 413, httpContext);
            byte[] msg = EncodingUtils.getAsciiBytes((String)errorMessage);
            ByteArrayEntity entity = new ByteArrayEntity(msg);
            entity.setContentType("text/plain; charset=US-ASCII");
            response.setEntity((HttpEntity)entity);
            response.addHeader("Connection", "Close");
            httpContext.setAttribute("http.connection", (Object)conn);
            httpContext.setAttribute(HTTP_REQUEST, null);
            httpContext.setAttribute("http.response", (Object)response);
            this.httpProcessor.process(response, httpContext);
            conn.submitResponse(response);
            conn.close();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            this.shutdownConnection(conn, true, errorMessage);
        }
    }
}

