/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.util.MiscellaneousUtil;

public final class NHttpConfiguration {
    private static final int WORKERS_CORE_THREADS = 20;
    private static final int WORKERS_MAX_THREADS = 100;
    private static final int WORKER_KEEP_ALIVE = 5;
    private static final int BLOCKING_QUEUE_LENGTH = -1;
    private static final int IO_WORKER_COUNT = 2;
    private static final int BUFFER_SIZE = 8192;
    public static final int MAX_ACTIVE_CON = -1;
    private static final String S_T_CORE = "snd_t_core";
    private static final String S_T_MAX = "snd_t_max";
    private static final String S_T_ALIVE = "snd_alive_sec";
    private static final String S_T_QLEN = "snd_qlen";
    private static final String S_IO_WORKERS = "snd_io_threads";
    private static final String C_MAX_ACTIVE = "max_open_connections";
    private static final String C_T_CORE = "lst_t_core";
    private static final String C_T_MAX = "lst_t_max";
    private static final String C_T_ALIVE = "lst_alive_sec";
    private static final String C_T_QLEN = "lst_qlen";
    private static final String C_IO_WORKERS = "lst_io_threads";
    private static final String ERROR_HANDLER_POOL_ENABLED = "error_handler_pool_enabled";
    private static final String ERROR_HANDLER_T_CORE = "error_handler_t_core";
    private static final String ERROR_HANDLER_T_MAX = "error_handler_t_max";
    private static final String ERROR_HANDLER_T_ALIVE = "error_handler_alive_sec";
    private static final String ERROR_HANDLER_T_QLEN = "error_handler_qlen";
    private static final String G_BUFFER_SIZE = "nhttp_buffer_size";
    private static final String G_DISABLED_HTTP_METHODS = "nhttp_disabled_methods";
    private static final String IS_LOG_ROTATABLE = "nhttp.is.log.rotatable";
    private static final String NHTTP_REST_DISPATCHER_SERVICE = "nhttp.rest.dispatcher.service";
    private static final String REST_URI_API_REGEX = "rest_uri_api_regex";
    private static final String REST_URI_PROXY_REGEX = "rest_uri_proxy_regex";
    public static final String TRANSPORT_LISTENER_SHUTDOWN_WAIT_TIME = "transport.listener.shutdown.wait.sec";
    public static final int DEFAULT_LISTENER_SHUTDOWN_WAIT_TIME = 0;
    public static final String MESSAGE_SIZE_VALIDATION = "message.size.validation.enabled";
    public static final String VALID_MAX_MESSAGE_SIZE = "valid.max.message.size.in.bytes";
    private static final Log log = LogFactory.getLog(NHttpConfiguration.class);
    private static NHttpConfiguration _instance = new NHttpConfiguration();
    private Properties props;
    List<String> methods;
    private List<String> preserveHeaders;
    public static final String BLOCK_SERVICE_LIST = "http.block_service_list";
    public static final String BLOCK_SERVICE_LIST_DEFAULT = "false";
    private Boolean reverseProxyMode = null;
    private String nhttpDefaultServiceName = null;
    private String restUriApiRegex = null;
    private String restUriProxyRegex = null;

    private NHttpConfiguration() {
        try {
            this.props = MiscellaneousUtil.loadProperties((String)"nhttp.properties");
            this.populatePreserveHttpHeaders();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static NHttpConfiguration getInstance() {
        return _instance;
    }

    public int getServerCoreThreads() {
        return this.getProperty(S_T_CORE, 20);
    }

    public void addPreserveHeader(String header) {
        if (this.preserveHeaders == null) {
            this.preserveHeaders = new ArrayList<String>();
        }
        this.preserveHeaders.add(header);
    }

    public void removePreserveHeader(String header) {
        if (this.preserveHeaders != null) {
            this.preserveHeaders.remove(header);
        }
    }

    public int getServerMaxThreads() {
        return this.getProperty(S_T_MAX, 100);
    }

    public int getServerKeepalive() {
        return this.getProperty(S_T_ALIVE, 5);
    }

    public int getServerQueueLen() {
        return this.getProperty(S_T_QLEN, -1);
    }

    public int getServerIOWorkers() {
        return this.getProperty(S_IO_WORKERS, 2);
    }

    public int getClientCoreThreads() {
        return this.getProperty(C_T_CORE, 20);
    }

    public int getClientMaxThreads() {
        return this.getProperty(C_T_MAX, 100);
    }

    public int getClientKeepalive() {
        return this.getProperty(C_T_ALIVE, 5);
    }

    public int getClientQueueLen() {
        return this.getProperty(C_T_QLEN, -1);
    }

    public int getClientIOWorkers() {
        return this.getProperty(C_IO_WORKERS, 2);
    }

    public int getMaxActiveConnections() {
        return this.getProperty(C_MAX_ACTIVE, -1);
    }

    public int getErrorHandlerCoreThreads() {
        return this.getProperty(ERROR_HANDLER_T_CORE, this.getClientCoreThreads() / 2);
    }

    public int getErrorHandlerTMaxThreads() {
        return this.getProperty(ERROR_HANDLER_T_MAX, this.getClientMaxThreads() / 2);
    }

    public int getErrorHandlerKeepAlive() {
        return this.getProperty(ERROR_HANDLER_T_ALIVE, 5);
    }

    public int getErrorHandlerQueuelen() {
        return this.getProperty(ERROR_HANDLER_T_QLEN, -1);
    }

    public boolean isErrorHandlerPoolEnabled() {
        return this.getBooleanValue(ERROR_HANDLER_POOL_ENABLED, false);
    }

    public int getBufferSize() {
        return this.getProperty(G_BUFFER_SIZE, 8192);
    }

    public boolean isLogRotatable() {
        return this.getBooleanValue(IS_LOG_ROTATABLE, false);
    }

    public boolean isKeepAliveDisabled() {
        return this.getProperty("http.connection.disable.keepalive", 0) == 1;
    }

    public boolean isCountConnections() {
        return this.getBooleanValue("http.count.connections", false);
    }

    public String isServiceListBlocked() {
        return this.getStringValue(BLOCK_SERVICE_LIST, BLOCK_SERVICE_LIST_DEFAULT);
    }

    public String getRESTDispatchService() {
        return this.getStringValue(NHTTP_REST_DISPATCHER_SERVICE, "");
    }

    public String getRestUriApiRegex() {
        if (this.restUriApiRegex == null) {
            this.restUriApiRegex = this.getStringValue(REST_URI_API_REGEX, "");
        }
        return this.restUriApiRegex;
    }

    public String getRestUriProxyRegex() {
        if (this.restUriProxyRegex == null) {
            this.restUriProxyRegex = this.getStringValue(REST_URI_PROXY_REGEX, "");
        }
        return this.restUriProxyRegex;
    }

    public int getListenerShutdownWaitTime() {
        return this.getProperty(TRANSPORT_LISTENER_SHUTDOWN_WAIT_TIME, 0) * 1000;
    }

    public boolean getMessageSizeValidationEnabled() {
        return this.getBooleanValue(MESSAGE_SIZE_VALIDATION, false);
    }

    public int getMaxMessageSize() {
        return this.getProperty(VALID_MAX_MESSAGE_SIZE, Integer.MAX_VALUE);
    }

    public boolean isPreserveHttpHeader(String httpHeader) {
        if (this.preserveHeaders == null || this.preserveHeaders.isEmpty() || httpHeader == null) {
            return false;
        }
        return this.preserveHeaders.contains(httpHeader.toUpperCase());
    }

    public int getProperty(String name, int def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            val = val.trim();
        }
        if (val != null && Integer.valueOf(val) > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using nhttp tuning parameter : " + name + " = " + val));
            }
            return Integer.valueOf(val);
        }
        return def;
    }

    public boolean getBooleanValue(String name, boolean def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null && Boolean.parseBoolean(val)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using nhttp tuning parameter : " + name));
            }
            return true;
        }
        if (val != null && !Boolean.parseBoolean(val)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using nhttp tuning parameter : " + name));
            }
            return false;
        }
        return def;
    }

    public String getStringValue(String name, String def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        return val == null ? def : val;
    }

    public boolean isHttpMethodDisabled(String method) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
            String methodsString = this.getStringValue(G_DISABLED_HTTP_METHODS, "");
            for (String methodStr : methodsString.split(",")) {
                this.methods.add(methodStr.trim().toUpperCase());
            }
        }
        return this.methods.contains(method);
    }

    private void populatePreserveHttpHeaders() {
        if (this.preserveHeaders == null) {
            String[] splitHeaders;
            this.preserveHeaders = new ArrayList<String>();
            String presHeaders = this.getStringValue("http.headers.preserve", "");
            if (presHeaders != null && !presHeaders.isEmpty() && (splitHeaders = presHeaders.toUpperCase().trim().split(",")) != null && splitHeaders.length > 0) {
                this.preserveHeaders.addAll(Arrays.asList(splitHeaders));
            }
            if (this.getBooleanValue("http.server.preserve", true) && !this.preserveHeaders.contains("Server".toUpperCase())) {
                this.preserveHeaders.add("Server".toUpperCase());
            }
            if (this.getBooleanValue("http.user.agent.preserve", false) && !this.preserveHeaders.contains("User-Agent".toUpperCase())) {
                this.preserveHeaders.add("User-Agent".toUpperCase());
            }
        }
    }

    public boolean isReverseProxyMode() {
        if (this.reverseProxyMode == null) {
            this.reverseProxyMode = Boolean.parseBoolean(System.getProperty("reverseProxyMode"));
        }
        return this.reverseProxyMode;
    }

    public String getNhttpDefaultServiceName() {
        if (this.nhttpDefaultServiceName == null) {
            this.nhttpDefaultServiceName = this.getStringValue("nhttp.default.service", "__SynapseService");
        }
        return this.nhttpDefaultServiceName;
    }
}

