/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.Parser;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorFactory;
import org.apache.synapse.transport.nhttp.DefaultHttpGetProcessor;
import org.apache.synapse.transport.nhttp.HttpGetRequestProcessor;
import org.apache.synapse.transport.nhttp.ListenerContext;

class ListenerContextBuilder {
    private final Log log = LogFactory.getLog(ListenerContextBuilder.class);
    private final TransportInDescription transportIn;
    private final String name;
    private String host = "localhost";
    private int port = 8280;
    private PriorityExecutor executor = null;
    private Parser parser = null;
    private boolean restDispatching = true;
    private HttpGetRequestProcessor httpGetRequestProcessor = null;
    private InetAddress bindAddress;

    public ListenerContextBuilder(TransportInDescription transportIn) {
        this.transportIn = transportIn;
        this.name = transportIn.getName().toUpperCase(Locale.US);
    }

    public ListenerContextBuilder parse() throws AxisFault {
        Parameter param = this.transportIn.getParameter("hostname");
        if (param != null) {
            this.host = ((String)param.getValue()).trim();
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.log.warn((Object)"Unable to lookup local host name, using 'localhost'");
            }
        }
        param = this.transportIn.getParameter("port");
        if (param != null) {
            this.port = Integer.parseInt((String)param.getValue());
        }
        int portOffset = 0;
        try {
            portOffset = Integer.parseInt(System.getProperty("portOffset", "0"));
        }
        catch (NumberFormatException e) {
            this.handleException("portOffset System property should be a valid Integer", e);
        }
        this.port += portOffset;
        if (param != null) {
            param.setValue((Object)String.valueOf(this.port));
            param.getParameterElement().setText(String.valueOf(this.port));
        }
        if ((param = this.transportIn.getParameter("bind-address")) != null) {
            String s = ((String)param.getValue()).trim();
            try {
                this.bindAddress = InetAddress.getByName(s);
            }
            catch (UnknownHostException ex) {
                throw AxisFault.makeFault((Throwable)ex);
            }
        }
        if ((param = this.transportIn.getParameter("priorityConfigFile")) != null && param.getValue() != null) {
            String fileName = param.getValue().toString();
            OMElement definitions = null;
            try {
                FileInputStream fis = new FileInputStream(fileName);
                definitions = new StAXOMBuilder((InputStream)fis).getDocumentElement();
                definitions.build();
            }
            catch (FileNotFoundException e) {
                this.handleException("Priority configuration file cannot be found : " + fileName, e);
            }
            catch (XMLStreamException e) {
                this.handleException("Error parsing priority configuration xml file " + fileName, e);
            }
            this.executor = this.createPriorityExecutor(definitions);
            this.parser = this.createParser(definitions);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)(this.name + " Created a priority based executor from the configuration: " + fileName));
            }
        }
        if ((param = this.transportIn.getParameter("disableRestServiceDispatching")) != null && param.getValue() != null && param.getValue().equals("true")) {
            this.restDispatching = false;
        }
        if ((param = this.transportIn.getParameter("httpGetProcessor")) != null && param.getValue() != null) {
            this.httpGetRequestProcessor = this.createHttpGetProcessor(param.getValue().toString());
            if (this.httpGetRequestProcessor == null) {
                this.handleException("Cannot create HttpGetRequestProcessor");
            }
        } else {
            this.httpGetRequestProcessor = new DefaultHttpGetProcessor();
        }
        return this;
    }

    private PriorityExecutor createPriorityExecutor(OMElement definitions) throws AxisFault {
        assert (definitions != null);
        OMElement executorElem = definitions.getFirstChildWithName(new QName("priorityExecutor"));
        if (executorElem == null) {
            this.handleException("priorityExecutor configuration is mandatory for priority based routing");
        }
        PriorityExecutor executor = PriorityExecutorFactory.createExecutor(null, (OMElement)executorElem, (boolean)false, (Properties)new Properties());
        executor.init();
        return executor;
    }

    private Parser createParser(OMElement definitions) throws AxisFault {
        OMElement conditionsElem = definitions.getFirstChildWithName(new QName("conditions"));
        if (conditionsElem == null) {
            this.handleException("Conditions configuration is mandatory for priority based routing");
        }
        assert (conditionsElem != null);
        OMAttribute defPriorityAttr = conditionsElem.getAttribute(new QName("defaultPriority"));
        Parser parser = defPriorityAttr != null ? new Parser(Integer.parseInt(defPriorityAttr.getAttributeValue())) : new Parser();
        try {
            parser.init(conditionsElem);
        }
        catch (EvaluatorException e) {
            this.handleException("Invalid conditions configuration for priority based mediation", (Exception)((Object)e));
        }
        return parser;
    }

    private HttpGetRequestProcessor createHttpGetProcessor(String str) throws AxisFault {
        Object obj = null;
        try {
            obj = Class.forName(str).newInstance();
        }
        catch (ClassNotFoundException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        catch (InstantiationException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        catch (IllegalAccessException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        if (obj instanceof HttpGetRequestProcessor) {
            return obj;
        }
        this.handleException("Error creating WSDL processor. The HttpProcessor should be of type org.apache.synapse.transport.nhttp.HttpGetRequestProcessor");
        return null;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)(this.name + " " + msg), (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        this.log.error((Object)(this.name + " " + msg));
        throw new AxisFault(msg);
    }

    public ListenerContext build() throws AxisFault {
        return new ListenerContext(this.transportIn, this.executor, this.parser, this.restDispatching, this.httpGetRequestProcessor, this.host, this.port, this.bindAddress);
    }
}

