/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.base.TransportMBeanSupport;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.commons.util.TemporaryData;
import org.apache.synapse.transport.exceptions.InvalidConfigurationException;
import org.apache.synapse.transport.http.conn.ClientConnFactory;
import org.apache.synapse.transport.http.conn.ProxyConfig;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;
import org.apache.synapse.transport.nhttp.ClientHandler;
import org.apache.synapse.transport.nhttp.ClientIODispatch;
import org.apache.synapse.transport.nhttp.ConnectionPool;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerWorker;
import org.apache.synapse.transport.nhttp.config.ClientConnFactoryBuilder;
import org.apache.synapse.transport.nhttp.config.ProxyConfigBuilder;
import org.apache.synapse.transport.nhttp.debug.ClientConnectionDebug;
import org.apache.synapse.transport.nhttp.debug.ServerConnectionDebug;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.nhttp.util.NhttpMetricsCollector;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;

public class HttpCoreNIOSender
extends AbstractHandler
implements TransportSender,
ManagementSupport {
    private static final Log log = LogFactory.getLog(HttpCoreNIOSender.class);
    private volatile DefaultConnectingIOReactor ioReactor;
    private volatile ClientIODispatch iodispatch;
    private volatile ClientConnFactory connFactory;
    private volatile String name;
    private volatile ConnectionPool connpool;
    private volatile ClientHandler handler;
    private final SessionRequestCallback sessionRequestCallback = this.getSessionRequestCallback();
    private volatile TransportMBeanSupport mbeanSupport;
    private volatile NhttpMetricsCollector metrics;
    private volatile int state = 0;
    private NHttpConfiguration cfg;
    private volatile ProxyConfig proxyConfig;
    private volatile HttpParams params;
    private volatile ConfigurationContext configurationContext;
    private int socketTimeout = 0;

    protected ClientConnFactoryBuilder initConnFactoryBuilder(TransportOutDescription transportOut, ConfigurationContext configurationContext) throws AxisFault {
        return new ClientConnFactoryBuilder(transportOut, configurationContext);
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        Parameter param;
        this.configurationContext = cfgCtx;
        this.cfg = NHttpConfiguration.getInstance();
        this.params = new BasicHttpParams();
        this.params.setIntParameter("http.socket.timeout", this.cfg.getProperty("http.socket.timeout.sender", 60000)).setIntParameter("http.connection.timeout", this.cfg.getProperty("http.connection.timeout", 10000)).setIntParameter("http.socket.buffer-size", this.cfg.getProperty("http.socket.buffer-size", 8192)).setParameter("http.useragent", (Object)"Synapse-HttpComponents-NIO");
        this.name = transportOut.getName().toUpperCase(Locale.US) + " Sender";
        ClientConnFactoryBuilder contextBuilder = this.initConnFactoryBuilder(transportOut, cfgCtx);
        this.connFactory = contextBuilder.createConnFactory(this.params);
        this.connpool = new ConnectionPool();
        this.proxyConfig = new ProxyConfigBuilder().build(transportOut);
        if (log.isDebugEnabled()) {
            log.debug((Object)this.proxyConfig.logProxyConfig());
        }
        if ((param = transportOut.getParameter("warnOnHTTP500")) != null) {
            String[] warnOnHttp500 = ((String)param.getValue()).split("\\|");
            cfgCtx.setNonReplicableProperty("warnOnHTTP500", (Object)warnOnHttp500);
        }
        IOReactorConfig ioReactorConfig = new IOReactorConfig();
        ioReactorConfig.setIoThreadCount(NHttpConfiguration.getInstance().getClientIOWorkers());
        ioReactorConfig.setSoTimeout(this.cfg.getProperty("http.socket.timeout.receiver", 60000));
        ioReactorConfig.setConnectTimeout(this.cfg.getProperty("http.connection.timeout", 10000));
        ioReactorConfig.setTcpNoDelay(this.cfg.getProperty("http.tcp.nodelay", 1) == 1);
        if (this.cfg.getBooleanValue("http.nio.interest-ops-queueing", false)) {
            ioReactorConfig.setInterestOpQueued(true);
        }
        try {
            String prefix = this.name + " I/O dispatcher";
            this.ioReactor = new DefaultConnectingIOReactor(ioReactorConfig, (ThreadFactory)new NativeThreadFactory(new ThreadGroup(prefix + " thread group"), prefix));
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOException e) {
            log.error((Object)"Error starting the IOReactor", (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        this.metrics = new NhttpMetricsCollector(false, transportOut.getName());
        this.handler = new ClientHandler(this.connpool, this.connFactory, this.proxyConfig, cfgCtx, this.params, this.metrics);
        ClientIODispatch ioEventDispatch = this.iodispatch = new ClientIODispatch(this.handler, this.connFactory);
        Thread t = new Thread(new Runnable((IOEventDispatch)ioEventDispatch){
            final /* synthetic */ IOEventDispatch val$ioEventDispatch;
            {
                this.val$ioEventDispatch = iOEventDispatch;
            }

            @Override
            public void run() {
                try {
                    HttpCoreNIOSender.this.ioReactor.execute(this.val$ioEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    log.fatal((Object)"Reactor Interrupted");
                }
                catch (IOException e) {
                    log.fatal((Object)("Encountered an I/O error: " + e.getMessage()), (Throwable)e);
                }
                log.info((Object)(HttpCoreNIOSender.this.name + " Shutdown"));
            }
        }, "HttpCoreNIOSender");
        t.start();
        log.info((Object)(this.name + " starting"));
        this.mbeanSupport = new TransportMBeanSupport((TransportSender)this, "nio-" + transportOut.getName());
        this.mbeanSupport.register();
        this.state = 1;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        EndpointReference epr;
        this.removeUnwantedHeaders(msgContext);
        if (AddressingHelper.isReplyRedirected((MessageContext)msgContext) && !msgContext.getReplyTo().hasNoneAddress()) {
            msgContext.setProperty("IGNORE_SC_ACCEPTED", (Object)"true");
        }
        if ((epr = NhttpUtil.getDestinationEPR(msgContext)) != null) {
            if (!epr.hasNoneAddress()) {
                this.sendAsyncRequest(epr, msgContext);
            } else {
                this.handleException("Cannot send message to http://www.w3.org/2005/08/addressing/none");
            }
        } else if (msgContext.getProperty("OutTransportInfo") != null) {
            if (msgContext.getProperty("OutTransportInfo") instanceof ServerWorker) {
                this.sendAsyncResponse(msgContext);
            } else {
                this.sendUsingOutputStream(msgContext);
            }
        } else {
            this.handleException("No valid destination EPR or OutputStream to send message");
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void removeUnwantedHeaders(MessageContext msgContext) {
        Map transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        Map excessHeaders = (Map)msgContext.getProperty("EXCESS_TRANSPORT_HEADERS");
        if (transportHeaders != null && !transportHeaders.isEmpty()) {
            this.removeUnwantedHeadersFromHeaderMap(transportHeaders, this.cfg);
        }
        if (excessHeaders != null && !excessHeaders.isEmpty()) {
            this.removeUnwantedHeadersFromHeaderMap(excessHeaders, this.cfg);
        }
    }

    private void removeUnwantedHeadersFromHeaderMap(Map headers, NHttpConfiguration nHttpConfiguration) {
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            if ("Connection".equalsIgnoreCase(headerName) || "Transfer-Encoding".equalsIgnoreCase(headerName) || "Content-Type".equalsIgnoreCase(headerName) || "Content-Length".equalsIgnoreCase(headerName)) {
                iter.remove();
            }
            if ("Server".equalsIgnoreCase(headerName) && !nHttpConfiguration.isPreserveHttpHeader("Server")) {
                iter.remove();
            }
            if ("User-Agent".equalsIgnoreCase(headerName) && !nHttpConfiguration.isPreserveHttpHeader("User-Agent")) {
                iter.remove();
            }
            if (!"Date".equalsIgnoreCase(headerName) || nHttpConfiguration.isPreserveHttpHeader("Date")) continue;
            iter.remove();
        }
    }

    private void sendAsyncRequest(EndpointReference epr, MessageContext msgContext) throws AxisFault {
        try {
            Axis2HttpRequest axis2Req;
            block17: {
                URL url = new URL(epr.getAddress());
                String scheme = url.getProtocol() != null ? url.getProtocol() : "http";
                String hostname = url.getHost();
                int port = url.getPort();
                if (port == -1) {
                    if ("http".equals(scheme)) {
                        port = 80;
                    } else if ("https".equals(scheme)) {
                        port = 443;
                    }
                }
                HttpHost target = new HttpHost(hostname, port, scheme);
                boolean secure = "https".equalsIgnoreCase(target.getSchemeName());
                HttpHost proxy = this.proxyConfig.selectProxy(target);
                msgContext.setProperty("PROXY_PROFILE_TARGET_HOST", (Object)target.getHostName());
                HttpRoute route = proxy != null ? new HttpRoute(target, null, proxy, secure) : new HttpRoute(target, null, secure);
                axis2Req = new Axis2HttpRequest(epr, route, msgContext);
                Object timeout = msgContext.getProperty("SEND_TIMEOUT");
                if (timeout != null && timeout instanceof Long) {
                    axis2Req.setTimeout((int)((Long)timeout).longValue());
                }
                NHttpClientConnection conn = this.connpool.getConnection(route);
                ServerConnectionDebug scd = (ServerConnectionDebug)msgContext.getProperty("synapse.server-connection-debug");
                if (scd != null) {
                    ClientConnectionDebug ccd = scd.getClientConnectionDebug();
                    if (ccd == null) {
                        ccd = new ClientConnectionDebug(scd);
                        scd.setClientConnectionDebug(ccd);
                    }
                    ccd.recordRequestStartTime(conn, axis2Req);
                    msgContext.setProperty("synapse.client-connection-debug", (Object)ccd);
                }
                if (conn == null) {
                    HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
                    this.ioReactor.connect((SocketAddress)new InetSocketAddress(host.getHostName(), host.getPort()), null, (Object)axis2Req, this.sessionRequestCallback);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A new connection established to : " + route));
                    }
                } else {
                    conn.setSocketTimeout(this.socketTimeout);
                    try {
                        this.handler.submitRequest(conn, axis2Req);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("An existing connection reused to : " + hostname + ":" + port));
                        }
                    }
                    catch (ConnectionClosedException e) {
                        this.ioReactor.connect((SocketAddress)new InetSocketAddress(hostname, port), null, (Object)axis2Req, this.sessionRequestCallback);
                        if (!log.isDebugEnabled()) break block17;
                        log.debug((Object)("A new connection established to : " + hostname + ":" + port));
                    }
                }
            }
            axis2Req.streamMessageContents();
        }
        catch (MalformedURLException e) {
            this.handleException("Malformed destination EPR : " + epr.getAddress(), e);
        }
    }

    private void sendAsyncResponse(MessageContext msgContext) throws AxisFault {
        int contentLength = this.extractContentLength(msgContext);
        this.removeUnwantedHeaders(msgContext);
        String cType = (String)msgContext.getProperty("ContentType");
        String messageType = (String)msgContext.getProperty("messageType");
        String oriMessageType = (String)msgContext.getProperty("originalMessageType");
        if (cType != null && cType.indexOf("multipart/related") != -1 && messageType != null && messageType.equals(oriMessageType)) {
            msgContext.setProperty("messageType", (Object)"multipart/related");
        }
        Map transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        ServerWorker worker = (ServerWorker)msgContext.getProperty("OutTransportInfo");
        NHttpServerConnection conn = worker.getConn();
        if (null == conn.getHttpRequest() && conn.getContext().getAttribute("CONNECTION_DROPPED") != null && ((Boolean)conn.getContext().getAttribute("CONNECTION_DROPPED")).booleanValue()) {
            return;
        }
        HttpResponse response = worker.getResponse();
        OMOutputFormat format = NhttpUtil.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
        Boolean noEntityBody = (Boolean)msgContext.getProperty("NO_ENTITY_BODY");
        if (noEntityBody == null || Boolean.FALSE == noEntityBody) {
            response.setHeader("Content-Type", messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
        } else if (Boolean.TRUE == noEntityBody) {
            ((BasicHttpEntity)response.getEntity()).setChunked(false);
            ((BasicHttpEntity)response.getEntity()).setContentLength(0L);
            if (transportHeaders.get("HTTP_REQUEST_METHOD") != null && "HEAD".equals(transportHeaders.get("HTTP_REQUEST_METHOD")) && transportHeaders.get("ORIGINAL_CONTENT_LENGTH") != null) {
                ((BasicHttpEntity)response.getEntity()).setContentLength(Long.parseLong(String.valueOf(transportHeaders.get("ORIGINAL_CONTENT_LENGTH"))));
                transportHeaders.remove("ORIGINAL_CONTENT_LENGTH");
                transportHeaders.remove("HTTP_REQUEST_METHOD");
            }
        }
        response.setStatusCode(this.determineHttpStatusCode(msgContext, response));
        if (msgContext.getProperty("HTTP_REASON_PHRASE") != null && !msgContext.getProperty("HTTP_REASON_PHRASE").equals("")) {
            response.setReasonPhrase(msgContext.getProperty("HTTP_REASON_PHRASE").toString());
        }
        if (transportHeaders != null && !transportHeaders.values().isEmpty()) {
            for (Object header : transportHeaders.keySet()) {
                Object value = transportHeaders.get(header);
                if (value == null || !(header instanceof String) || !(value instanceof String)) continue;
                response.addHeader((String)header, (String)value);
                String excessProp = "EXCESS_TRANSPORT_HEADERS";
                Map map = (Map)msgContext.getProperty(excessProp);
                if (map == null || map.get(header) == null) continue;
                log.debug((Object)("Number of excess values for " + header + " header is : " + ((Collection)map.get(header)).size()));
                for (String key : map.keySet()) {
                    for (String excessVal : (Collection)map.get(key)) {
                        if (!header.equals(key)) continue;
                        response.addHeader((String)header, excessVal);
                    }
                }
            }
        }
        boolean forceContentLength = msgContext.isPropertyTrue("FORCE_HTTP_CONTENT_LENGTH");
        boolean forceContentLengthCopy = msgContext.isPropertyTrue("COPY_CONTENT_LENGTH_FROM_INCOMING");
        BasicHttpEntity entity = (BasicHttpEntity)response.getEntity();
        MetricsCollector lstMetrics = worker.getServiceHandler().getMetrics();
        try {
            if (forceContentLength) {
                entity.setChunked(false);
                if (forceContentLengthCopy && contentLength > 0) {
                    entity.setContentLength((long)contentLength);
                } else {
                    this.setStreamAsTempData(entity, messageFormatter, msgContext, format);
                }
            }
            worker.getServiceHandler().commitResponse(worker.getConn(), response);
            lstMetrics.reportResponseCode(response.getStatusLine().getStatusCode());
            OutputStream out = worker.getOutputStream();
            if (msgContext.isPropertyTrue("SC_ACCEPTED") || Boolean.TRUE == noEntityBody) {
                out.write(new byte[0]);
            } else if (forceContentLength) {
                if (forceContentLengthCopy && contentLength > 0) {
                    messageFormatter.writeTo(msgContext, format, out, false);
                } else {
                    this.writeMessageFromTempData(out, msgContext);
                }
            } else {
                messageFormatter.writeTo(msgContext, format, out, false);
            }
            out.close();
            if (lstMetrics != null) {
                lstMetrics.incrementMessagesSent();
            }
        }
        catch (ProtocolException e) {
            log.error((Object)((Object)((Object)e) + " (Synapse may be trying to send an exact response more than once )"));
        }
        catch (HttpException e) {
            if (lstMetrics != null) {
                lstMetrics.incrementFaultsSending();
            }
            this.handleException("Unexpected HTTP protocol error sending response to : " + worker.getRemoteAddress(), (Exception)((Object)e));
        }
        catch (ConnectionClosedException e) {
            if (lstMetrics != null) {
                lstMetrics.incrementFaultsSending();
            }
            log.warn((Object)("Connection closed by client : " + worker.getRemoteAddress()));
        }
        catch (IllegalStateException e) {
            if (lstMetrics != null) {
                lstMetrics.incrementFaultsSending();
            }
            log.warn((Object)("Connection closed by client : " + worker.getRemoteAddress()));
        }
        catch (IOException e) {
            if (lstMetrics != null) {
                lstMetrics.incrementFaultsSending();
            }
            this.handleException("IO Error sending response message to : " + worker.getRemoteAddress(), e);
        }
        catch (Exception e) {
            if (lstMetrics != null) {
                lstMetrics.incrementFaultsSending();
            }
            this.handleException("General Error sending response message to : " + worker.getRemoteAddress(), e);
        }
        InputStream is = worker.getIs();
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int extractContentLength(MessageContext msgContext) {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers == null || headers.isEmpty()) {
            return -1;
        }
        for (Object o : headers.keySet()) {
            Object value;
            String headerName = (String)o;
            if (!"Content-Length".equalsIgnoreCase(headerName) || (value = headers.get(headerName)) == null || !(value instanceof String)) continue;
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStreamAsTempData(BasicHttpEntity entity, MessageFormatter messageFormatter, MessageContext msgContext, OMOutputFormat format) throws IOException {
        TemporaryData serialized = new TemporaryData(256, 4096, "http-nio_", ".dat");
        try (OutputStream out = serialized.getOutputStream();){
            messageFormatter.writeTo(msgContext, format, out, true);
        }
        msgContext.setProperty("SerializedBytes", (Object)serialized);
        entity.setContentLength(serialized.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessageFromTempData(OutputStream out, MessageContext msgContext) throws IOException {
        TemporaryData serialized = (TemporaryData)msgContext.getProperty("SerializedBytes");
        try {
            serialized.writeTo(out);
        }
        finally {
            serialized.release();
        }
    }

    private int determineHttpStatusCode(MessageContext msgContext, HttpResponse response) {
        int httpStatus = 200;
        if (response.getStatusLine() != null) {
            httpStatus = response.getStatusLine().getStatusCode();
        }
        if (msgContext.isPropertyTrue("SC_ACCEPTED")) {
            httpStatus = 202;
        } else {
            boolean handleFault = msgContext.getEnvelope().getBody().hasFault() || msgContext.isProcessingFault();
            boolean faultsAsHttp200 = "TRUE".equalsIgnoreCase((String)msgContext.getProperty("FAULTS_AS_HTTP_200"));
            if (handleFault && !faultsAsHttp200) {
                httpStatus = 500;
            } else if (handleFault & faultsAsHttp200) {
                return 200;
            }
            Object statusCode = msgContext.getProperty("HTTP_SC");
            if (statusCode != null) {
                try {
                    httpStatus = Integer.parseInt(msgContext.getProperty("HTTP_SC").toString());
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unable to set the HTTP status code from the property HTTP_SC with value: " + statusCode));
                }
            }
        }
        return httpStatus;
    }

    private void sendUsingOutputStream(MessageContext msgContext) throws AxisFault {
        OMOutputFormat format = NhttpUtil.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
        OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
        if (msgContext.isServerSide()) {
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            if (transportInfo != null) {
                transportInfo.setContentType(messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
            } else {
                throw new AxisFault("OutTransportInfo has not been set");
            }
        }
        try {
            messageFormatter.writeTo(msgContext, format, out, false);
            out.close();
        }
        catch (IOException e) {
            this.handleException("IO Error sending response message", e);
        }
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void stop() {
        if (this.state == 0) {
            return;
        }
        try {
            this.ioReactor.shutdown();
            this.handler.stop();
            this.state = 0;
        }
        catch (IOException e) {
            log.warn((Object)"Error shutting down IOReactor", (Throwable)e);
        }
        this.mbeanSupport.unregister();
        this.metrics.destroy();
    }

    private SessionRequestCallback getSessionRequestCallback() {
        return new SessionRequestCallback(){

            public void completed(SessionRequest request) {
                if (log.isDebugEnabled() && request.getSession() != null && request.getSession().getLocalAddress() != null) {
                    log.debug((Object)("Connected to remote address : " + request.getSession().getRemoteAddress() + " from local address : " + request.getSession().getLocalAddress()));
                }
            }

            public void failed(SessionRequest request) {
                this.handleError(request, 101503, "Connection refused or failed for : " + request.getRemoteAddress() + ", IO Exception occured : " + request.getException().getMessage());
            }

            public void timeout(SessionRequest request) {
                this.handleError(request, 101508, "Timeout connecting to : " + request.getRemoteAddress());
                request.cancel();
            }

            public void cancelled(SessionRequest request) {
                this.handleError(request, 101507, "Connection cancelled for : " + request.getRemoteAddress());
            }

            private void handleError(SessionRequest request, int errorCode, String errorMessage) {
                Axis2HttpRequest axis2Request;
                if (request.getAttachment() != null && request.getAttachment() instanceof Axis2HttpRequest && !(axis2Request = (Axis2HttpRequest)request.getAttachment()).isCompleted()) {
                    HttpCoreNIOSender.this.handler.markRequestCompletedWithError(axis2Request, errorCode, errorMessage, null);
                }
            }
        };
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        log.info((Object)(this.name + " Paused"));
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        this.state = 1;
        log.info((Object)(this.name + " Resumed"));
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.shutdown(millis);
            this.state = 0;
            log.info((Object)("Sender shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenence", e);
        }
    }

    public int getActiveThreadCount() {
        return this.handler.getActiveCount();
    }

    public int getQueueSize() {
        return this.handler.getQueueSize();
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    public long getTimeoutsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsReceiving();
        }
        return -1L;
    }

    public long getTimeoutsSending() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsSending();
        }
        return -1L;
    }

    public long getMinSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeReceived();
        }
        return -1L;
    }

    public long getMaxSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeReceived();
        }
        return -1L;
    }

    public double getAvgSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeReceived();
        }
        return -1.0;
    }

    public long getMinSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeSent();
        }
        return -1L;
    }

    public long getMaxSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeSent();
        }
        return -1L;
    }

    public double getAvgSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeSent();
        }
        return -1.0;
    }

    public Map getResponseCodeTable() {
        if (this.metrics != null) {
            return this.metrics.getResponseCodeTable();
        }
        return null;
    }

    public void resetStatistics() {
        if (this.metrics != null) {
            this.metrics.reset();
        }
    }

    public long getLastResetTime() {
        if (this.metrics != null) {
            return this.metrics.getLastResetTime();
        }
        return -1L;
    }

    public long getMetricsWindow() {
        if (this.metrics != null) {
            return System.currentTimeMillis() - this.metrics.getLastResetTime();
        }
        return -1L;
    }

    public void reload(TransportOutDescription transportOut) throws AxisFault {
        log.info((Object)"HttpCoreNIOSender reloading SSL Config..");
        try {
            ClientConnFactoryBuilder contextBuilder = this.initConnFactoryBuilder(transportOut, this.configurationContext);
            this.connFactory = contextBuilder.createConnFactory(this.params);
            this.handler.setConnFactory(this.connFactory);
            this.iodispatch.setConnFactory(this.connFactory);
            this.handler.resetConnectionPool(this.connFactory.getHostList());
            log.info((Object)("HttpCoreNIO " + this.name + " Sender updated with Dynamic Configuration Updates ..."));
        }
        catch (InvalidConfigurationException configFault) {
            log.error((Object)"Ignoring reload SSL config since there is an invalid configuration.", (Throwable)configFault);
        }
    }
}

