/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.TransportMBeanSupport;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.http.conn.Scheme;
import org.apache.synapse.transport.http.conn.ServerConnFactory;
import org.apache.synapse.transport.nhttp.ListenerContext;
import org.apache.synapse.transport.nhttp.ListenerContextBuilder;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerHandler;
import org.apache.synapse.transport.nhttp.ServerIODispatch;
import org.apache.synapse.transport.nhttp.config.ServerConnFactoryBuilder;
import org.apache.synapse.transport.nhttp.util.ActiveConnectionMonitor;
import org.apache.synapse.transport.nhttp.util.NhttpMetricsCollector;

public class HttpCoreNIOListener
implements TransportListener,
ManagementSupport {
    private static final Log log = LogFactory.getLog(HttpCoreNIOListener.class);
    private volatile ConfigurationContext cfgCtx;
    private volatile DefaultListeningIOReactor ioReactor;
    private volatile ServerIODispatch iodispatch;
    private volatile Scheme scheme;
    private volatile ServerConnFactory connFactory;
    private volatile String name;
    private volatile HttpParams params;
    private volatile ServerHandler handler;
    private volatile TransportMBeanSupport mbeanSupport;
    private volatile ListenerContext listenerContext;
    private volatile NhttpMetricsCollector metrics;
    private volatile int state = 0;
    private boolean EPRPrefixCheck = true;
    private volatile String serviceEPRPrefix;
    private volatile String customEPRPrefix;
    private final Map<String, String> serviceNameToEPRMap = new HashMap<String, String>();
    private Map<String, String> eprToServiceNameMap = new HashMap<String, String>();
    private final AxisObserver axisObserver = new GenericAxisObserver();
    private final ScheduledExecutorService activeConnectionMonitorScheduler = Executors.newSingleThreadScheduledExecutor();
    public static final long ACTIVE_CONNECTION_MONITOR_DELAY = 1000L;

    protected Scheme initScheme() {
        return new Scheme("http", 80, false);
    }

    protected ServerConnFactoryBuilder initConnFactoryBuilder(TransportInDescription transportIn, HttpHost host, ConfigurationContext configurationContext) throws AxisFault {
        return new ServerConnFactoryBuilder(transportIn, host, configurationContext);
    }

    protected ServerConnFactoryBuilder initConnFactoryBuilder(TransportInDescription transportIn, HttpHost host) throws AxisFault {
        return new ServerConnFactoryBuilder(transportIn, host);
    }

    public void init(ConfigurationContext ctx, TransportInDescription transportIn) throws AxisFault {
        this.cfgCtx = ctx;
        Map o = (Map)this.cfgCtx.getProperty("service.epr.map");
        if (o != null) {
            this.eprToServiceNameMap = o;
        } else {
            this.eprToServiceNameMap = new HashMap<String, String>();
            this.cfgCtx.setProperty("service.epr.map", this.eprToServiceNameMap);
        }
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        this.params = new BasicHttpParams();
        this.params.setIntParameter("http.socket.timeout", cfg.getProperty("http.socket.timeout.receiver", 60000)).setIntParameter("http.socket.buffer-size", cfg.getProperty("http.socket.buffer-size", 8192)).setParameter("http.origin-server", (Object)"Synapse-HttpComponents-NIO");
        this.name = transportIn.getName().toUpperCase(Locale.US) + " Listener";
        this.scheme = this.initScheme();
        this.listenerContext = new ListenerContextBuilder(transportIn).parse().build();
        System.setProperty(transportIn.getName() + ".nio.port", String.valueOf(this.listenerContext.getPort()));
        HttpHost host = new HttpHost(this.listenerContext.getHostname(), this.listenerContext.getPort(), this.scheme.getName());
        this.connFactory = this.initConnFactoryBuilder(transportIn, host, ctx).build(this.params);
        try {
            String prefix = this.name + " I/O dispatcher";
            IOReactorConfig ioReactorConfig = new IOReactorConfig();
            ioReactorConfig.setIoThreadCount(cfg.getServerIOWorkers());
            ioReactorConfig.setSoTimeout(cfg.getProperty("http.socket.timeout.receiver", 60000));
            ioReactorConfig.setTcpNoDelay(cfg.getProperty("http.tcp.nodelay", 1) == 1);
            if (cfg.getBooleanValue("http.nio.interest-ops-queueing", false)) {
                ioReactorConfig.setInterestOpQueued(true);
            }
            ioReactorConfig.setSoReuseAddress(cfg.getBooleanValue("http.socket.reuseaddr", false));
            this.ioReactor = new DefaultListeningIOReactor(ioReactorConfig, (ThreadFactory)new NativeThreadFactory(new ThreadGroup(prefix + " thread group"), prefix));
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOException e) {
            this.handleException("Error creating IOReactor", e);
        }
        this.metrics = new NhttpMetricsCollector(true, transportIn.getName());
        this.handler = new ServerHandler(this.cfgCtx, this.scheme, this.listenerContext, this.metrics);
        this.iodispatch = new ServerIODispatch(this.handler, this.connFactory);
        Parameter param = transportIn.getParameter("WSDLEPRPrefix");
        if (param != null) {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(this.cfgCtx, (String)param.getValue());
            this.customEPRPrefix = (String)param.getValue();
            this.EPRPrefixCheck = false;
        } else {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(this.cfgCtx, this.listenerContext.getHostname(), this.listenerContext.getPort());
            this.customEPRPrefix = this.scheme.getName() + "://" + this.listenerContext.getHostname() + ":" + (this.listenerContext.getPort() == this.scheme.getDefaultPort() ? "" : Integer.valueOf(this.listenerContext.getPort())) + "/";
        }
        this.cfgCtx.getAxisConfiguration().addObservers(this.axisObserver);
        this.mbeanSupport = new TransportMBeanSupport((TransportListener)this, "nio-" + transportIn.getName());
        this.mbeanSupport.register();
    }

    public int getActiveConnectionsSize() {
        return this.handler.getActiveConnectionsSize();
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String host, int port) {
        return this.scheme.getName() + "://" + host + (port == this.scheme.getDefaultPort() ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String wsdlEPRPrefix) {
        return wsdlEPRPrefix + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    public void start() throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting Listener...");
        }
        for (Object obj : this.cfgCtx.getAxisConfiguration().getServices().values()) {
            this.addToServiceURIMap((AxisService)obj);
        }
        this.state = 1;
        ServerIODispatch ioEventDispatch = this.iodispatch;
        Thread t = new Thread(new Runnable((IOEventDispatch)ioEventDispatch){
            final /* synthetic */ IOEventDispatch val$ioEventDispatch;
            {
                this.val$ioEventDispatch = iOEventDispatch;
            }

            @Override
            public void run() {
                try {
                    HttpCoreNIOListener.this.ioReactor.execute(this.val$ioEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    log.fatal((Object)"Reactor Interrupted", (Throwable)ex);
                }
                catch (IOException e) {
                    log.fatal((Object)("Encountered an I/O error: " + e.getMessage()), (Throwable)e);
                }
                catch (Exception e) {
                    log.fatal((Object)"Unexpected exception in I/O reactor", (Throwable)e);
                }
                log.info((Object)(HttpCoreNIOListener.this.name + " Shutdown"));
            }
        }, "HttpCoreNIOListener");
        t.start();
        this.listenerContext.getHttpGetRequestProcessor().init(this.cfgCtx, this.handler);
        this.startEndpoints();
    }

    private void startEndpoints() throws AxisFault {
        LinkedList<ListenerEndpoint> endpoints = new LinkedList<ListenerEndpoint>();
        HashSet<InetSocketAddress> addressSet = new HashSet<InetSocketAddress>();
        addressSet.addAll(this.connFactory.getBindAddresses());
        if (NHttpConfiguration.getInstance().getMaxActiveConnections() != -1) {
            this.addMaxConnectionCountController(NHttpConfiguration.getInstance().getMaxActiveConnections());
        }
        if (this.listenerContext.getBindAddress() != null) {
            addressSet.add(new InetSocketAddress(this.listenerContext.getBindAddress(), this.listenerContext.getPort()));
        }
        if (addressSet.isEmpty()) {
            addressSet.add(new InetSocketAddress(this.listenerContext.getPort()));
        }
        ArrayList addressList = new ArrayList(addressSet);
        Collections.sort(addressList, new Comparator<InetSocketAddress>(){

            @Override
            public int compare(InetSocketAddress a1, InetSocketAddress a2) {
                String s1 = a1.toString();
                String s2 = a2.toString();
                return s1.compareTo(s2);
            }
        });
        for (InetSocketAddress address : addressList) {
            endpoints.add(this.ioReactor.listen((SocketAddress)address));
        }
        while (!endpoints.isEmpty()) {
            ListenerEndpoint endpoint = (ListenerEndpoint)endpoints.remove();
            try {
                InetSocketAddress address;
                endpoint.waitFor();
                if (!log.isInfoEnabled()) continue;
                address = (InetSocketAddress)endpoint.getAddress();
                if (!address.isUnresolved()) {
                    log.info((Object)(this.name + " started on " + address.getHostName() + ":" + address.getPort()));
                    continue;
                }
                log.info((Object)(this.name + " started on " + address));
            }
            catch (InterruptedException e) {
                log.warn((Object)"Listener startup was interrupted");
                break;
            }
        }
    }

    private void startSpecificEndpoints(List<InetSocketAddress> endpointsClosed) throws AxisFault {
        LinkedList<ListenerEndpoint> endpoints = new LinkedList<ListenerEndpoint>();
        List<InetSocketAddress> addressList = endpointsClosed;
        Collections.sort(addressList, new Comparator<InetSocketAddress>(){

            @Override
            public int compare(InetSocketAddress a1, InetSocketAddress a2) {
                String s1 = a1.toString();
                String s2 = a2.toString();
                return s1.compareTo(s2);
            }
        });
        for (InetSocketAddress address : addressList) {
            endpoints.add(this.ioReactor.listen((SocketAddress)address));
        }
        while (!endpoints.isEmpty()) {
            ListenerEndpoint endpoint = (ListenerEndpoint)endpoints.remove();
            try {
                InetSocketAddress address;
                endpoint.waitFor();
                if (!log.isInfoEnabled()) continue;
                address = (InetSocketAddress)endpoint.getAddress();
                if (!address.isUnresolved()) {
                    log.info((Object)(this.name + " started on " + address.getHostName() + ":" + address.getPort()));
                    continue;
                }
                log.info((Object)(this.name + " started on " + address));
            }
            catch (InterruptedException e) {
                log.warn((Object)"Listener startup was interrupted");
                break;
            }
        }
    }

    private void addToServiceURIMap(AxisService service) {
        Parameter param = service.getParameter("ServiceURI");
        if (param != null) {
            String uriLocation = param.getValue().toString();
            if (uriLocation.startsWith("/")) {
                uriLocation = uriLocation.substring(1);
            }
            this.serviceNameToEPRMap.put(service.getName(), uriLocation);
            this.eprToServiceNameMap.put(uriLocation, service.getName());
        }
    }

    private void removeServiceFfromURIMap(AxisService service) {
        this.eprToServiceNameMap.remove(this.serviceNameToEPRMap.get(service.getName()));
        this.serviceNameToEPRMap.remove(service.getName());
    }

    public void stop() throws AxisFault {
        if (this.state == 0) {
            return;
        }
        try {
            int wait = NHttpConfiguration.getInstance().getListenerShutdownWaitTime();
            if (wait > 0) {
                this.ioReactor.pause();
                log.info((Object)("Waiting " + wait / 1000 + " seconds to cleanup active connections..."));
                Thread.sleep(wait);
                this.ioReactor.shutdown((long)wait);
            } else {
                this.ioReactor.shutdown();
            }
            this.handler.stop();
            this.state = 0;
            for (Object obj : this.cfgCtx.getAxisConfiguration().getServices().values()) {
                this.removeServiceFfromURIMap((AxisService)obj);
            }
        }
        catch (IOException e) {
            this.handleException("Error shutting down IOReactor", e);
        }
        catch (InterruptedException e) {
            this.handleException("Error waiting for connection drain", e);
        }
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            this.ioReactor.pause();
            this.handler.markActiveConnectionsToBeClosed();
            this.state = 2;
            log.info((Object)(this.name + " Paused"));
        }
        catch (IOException e) {
            this.handleException("Error pausing IOReactor", e);
        }
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        try {
            this.ioReactor.resume();
            this.state = 1;
            log.info((Object)(this.name + " Resumed"));
        }
        catch (IOException e) {
            this.handleException("Error resuming IOReactor", e);
        }
    }

    public void reload(TransportInDescription transportIn) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        Set endpoints = this.ioReactor.getEndpoints();
        for (ListenerEndpoint endpoint : endpoints) {
            endpoint.close();
        }
        HttpHost host = new HttpHost(this.listenerContext.getHostname(), this.listenerContext.getPort(), this.scheme.getName());
        ServerConnFactoryBuilder connFactoryBuilder = this.initConnFactoryBuilder(transportIn, host, this.cfgCtx);
        this.connFactory = connFactoryBuilder.build(this.params);
        this.iodispatch.update(this.connFactory);
        this.startEndpoints();
        log.info((Object)(this.name + " Reloaded"));
    }

    public void reloadSpecificEndpoints(TransportInDescription transportIn) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        HttpHost host = new HttpHost(this.listenerContext.getHostname(), this.listenerContext.getPort(), this.scheme.getName());
        ServerConnFactoryBuilder connFactoryBuilder = this.initConnFactoryBuilder(transportIn, host, this.cfgCtx);
        this.connFactory = connFactoryBuilder.build(this.params);
        this.iodispatch.update(this.connFactory);
        ArrayList<InetSocketAddress> endPointsClosed = new ArrayList<InetSocketAddress>();
        Set<InetSocketAddress> endPointsToReload = this.connFactory.getBindAddresses();
        for (InetSocketAddress inetSocketAddress : endPointsToReload) {
            for (ListenerEndpoint listenerEndpoint : this.ioReactor.getEndpoints()) {
                if (!inetSocketAddress.getHostName().equalsIgnoreCase(((InetSocketAddress)listenerEndpoint.getAddress()).getHostName())) continue;
                listenerEndpoint.close();
                endPointsClosed.add((InetSocketAddress)listenerEndpoint.getAddress());
            }
        }
        this.startSpecificEndpoints(endPointsClosed);
        log.info((Object)(this.name + " Reloaded"));
    }

    public int getActiveThreadCount() {
        return this.handler.getActiveCount();
    }

    public int getQueueSize() {
        return this.handler.getQueueSize();
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.pause();
            this.ioReactor.shutdown(millis);
            this.state = 0;
            log.info((Object)("Listener shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenence", e);
        }
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        EndpointReference ep = this.getEPRsForService(serviceName, ip)[0];
        return ep;
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String trailer = "";
        boolean isServiceWithCustomURI = this.isServiceWithCustomURI(serviceName);
        if (serviceName.indexOf(47) != -1) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("/"));
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        if (serviceName.indexOf(46) != -1 && !isServiceWithCustomURI) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("."));
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        } else if (isServiceWithCustomURI) {
            serviceName = this.getServiceNameFromServiceWithCustomURI(serviceName);
        }
        EndpointReference[] endpointReferences = new EndpointReference[1];
        String service = this.serviceEPRPrefix;
        if (ip != null && !"".equals(ip) && this.EPRPrefixCheck) {
            service = this.replaceHostname(service, ip);
        }
        if (this.serviceNameToEPRMap.containsKey(serviceName)) {
            endpointReferences[0] = new EndpointReference(this.customEPRPrefix + this.serviceNameToEPRMap.get(serviceName));
        } else {
            if (service == null || "".equals(service)) {
                return null;
            }
            endpointReferences[0] = new EndpointReference(service + serviceName + trailer);
        }
        return endpointReferences;
    }

    private boolean isServiceWithCustomURI(String serviceName) {
        if (this.serviceNameToEPRMap.containsKey(serviceName)) {
            return true;
        }
        if (!serviceName.contains(".")) {
            return false;
        }
        serviceName = serviceName.substring(0, serviceName.lastIndexOf("."));
        return this.isServiceWithCustomURI(serviceName);
    }

    private String getServiceNameFromServiceWithCustomURI(String serviceName) {
        if (this.serviceNameToEPRMap.containsKey(serviceName)) {
            return serviceName;
        }
        serviceName = serviceName.substring(0, serviceName.lastIndexOf("."));
        return this.getServiceNameFromServiceWithCustomURI(serviceName);
    }

    private void addMaxConnectionCountController(int maxActiveConnections) {
        ActiveConnectionMonitor activeConnectionMonitor = new ActiveConnectionMonitor(this.metrics, this.ioReactor, maxActiveConnections);
        this.activeConnectionMonitorScheduler.scheduleWithFixedDelay(activeConnectionMonitor, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void destroy() {
        this.ioReactor = null;
        this.cfgCtx.getAxisConfiguration().getObserversList().remove(this.axisObserver);
        this.mbeanSupport.unregister();
        this.metrics.destroy();
    }

    private boolean ignoreService(AxisService service) {
        return service.getName().startsWith("__") || JavaUtils.isTrueExplicitly((Object)service.getParameter("hiddenService"));
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    public long getTimeoutsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsReceiving();
        }
        return -1L;
    }

    public long getTimeoutsSending() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsSending();
        }
        return -1L;
    }

    public long getMinSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeReceived();
        }
        return -1L;
    }

    public long getMaxSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeReceived();
        }
        return -1L;
    }

    public double getAvgSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeReceived();
        }
        return -1.0;
    }

    public long getMinSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeSent();
        }
        return -1L;
    }

    public long getMaxSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeSent();
        }
        return -1L;
    }

    public double getAvgSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeSent();
        }
        return -1.0;
    }

    public Map getResponseCodeTable() {
        if (this.metrics != null) {
            return this.metrics.getResponseCodeTable();
        }
        return null;
    }

    public void resetStatistics() {
        if (this.metrics != null) {
            this.metrics.reset();
        }
    }

    public long getLastResetTime() {
        if (this.metrics != null) {
            return this.metrics.getLastResetTime();
        }
        return -1L;
    }

    public long getMetricsWindow() {
        if (this.metrics != null) {
            return System.currentTimeMillis() - this.metrics.getLastResetTime();
        }
        return -1L;
    }

    private String replaceHostname(String url, String hostName) {
        if (null == url) {
            return "";
        }
        try {
            URL newURL = new URL(url);
            String replaceURL = "";
            replaceURL = -1 != newURL.getPort() ? newURL.getProtocol() + "://" + hostName + ":" + newURL.getPort() + newURL.getPath() : newURL.getProtocol() + "://" + hostName + newURL.getPath();
            return replaceURL;
        }
        catch (MalformedURLException e) {
            log.warn((Object)("URL is not in the correct form" + e));
            return "";
        }
    }

    public void reloadDynamicSSLConfig(TransportInDescription transportInDescription) throws AxisFault {
        log.info((Object)"HttpCoreNIOListener reloading SSL Config..");
        Parameter oldParameter = transportInDescription.getParameter("SSLProfiles");
        Parameter profilePathParam = transportInDescription.getParameter("dynamicSSLProfilesConfig");
        if (oldParameter != null && profilePathParam != null) {
            transportInDescription.removeParameter(oldParameter);
            this.reloadSpecificEndpoints(transportInDescription);
        }
    }

    class GenericAxisObserver
    implements AxisObserver {
        GenericAxisObserver() {
        }

        public void init(AxisConfiguration axisConfig) {
        }

        public void serviceUpdate(AxisEvent event, AxisService service) {
            if (!HttpCoreNIOListener.this.ignoreService(service) && BaseUtils.isUsingTransport((AxisService)service, (String)HttpCoreNIOListener.this.listenerContext.getTransportIn().getName())) {
                switch (event.getEventType()) {
                    case 1: {
                        HttpCoreNIOListener.this.addToServiceURIMap(service);
                        break;
                    }
                    case 0: {
                        HttpCoreNIOListener.this.removeServiceFfromURIMap(service);
                        break;
                    }
                    case 3: {
                        HttpCoreNIOListener.this.addToServiceURIMap(service);
                        break;
                    }
                    case 2: {
                        HttpCoreNIOListener.this.removeServiceFfromURIMap(service);
                    }
                }
            }
        }

        public void moduleUpdate(AxisEvent event, AxisModule module) {
        }

        public void addParameter(Parameter param) throws AxisFault {
        }

        public void removeParameter(Parameter param) throws AxisFault {
        }

        public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        }

        public Parameter getParameter(String name) {
            return null;
        }

        public ArrayList<Parameter> getParameters() {
            return null;
        }

        public boolean isParameterLocked(String parameterName) {
            return false;
        }

        public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
        }
    }
}

