/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.nhttp.HttpGetRequestProcessor;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerHandler;
import org.apache.synapse.transport.nhttp.util.RESTUtil;
import org.apache.ws.commons.schema.XmlSchema;

public class DefaultHttpGetProcessor
implements HttpGetRequestProcessor {
    private static final Log log = LogFactory.getLog(DefaultHttpGetProcessor.class);
    private static final String LOCATION = "Location";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_XML = "text/xml";
    protected ConfigurationContext cfgCtx;
    protected ServerHandler serverHandler;

    @Override
    public void init(ConfigurationContext cfgCtx, ServerHandler serverHandler) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.serverHandler = serverHandler;
    }

    @Override
    public void process(HttpRequest request, HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, OutputStream os, boolean isRestDispatching) {
        String uri = request.getRequestLine().getUri();
        String servicePath = this.cfgCtx.getServiceContextPath();
        if (!servicePath.startsWith("/")) {
            servicePath = "/" + servicePath;
        }
        String serviceName = this.getServiceName(request);
        HashMap<String, String> parameters = new HashMap<String, String>();
        int pos = uri.indexOf("?");
        if (pos != -1) {
            msgContext.setTo(new EndpointReference(uri.substring(0, pos)));
            StringTokenizer st = new StringTokenizer(uri.substring(pos + 1), "&");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                pos = param.indexOf("=");
                if (pos != -1) {
                    parameters.put(param.substring(0, pos), param.substring(pos + 1));
                    continue;
                }
                parameters.put(param, null);
            }
        } else {
            msgContext.setTo(new EndpointReference(uri));
        }
        if (this.isServiceListBlocked(uri)) {
            response.setStatusCode(403);
            this.serverHandler.commitResponseHideExceptions(conn, response);
        } else if (uri.equals("/favicon.ico")) {
            response.setStatusCode(301);
            response.addHeader(LOCATION, "http://wso2.org/favicon.ico");
            this.serverHandler.commitResponseHideExceptions(conn, response);
        } else {
            if (serviceName != null && parameters.containsKey("wsdl")) {
                this.generateWsdl(request, response, msgContext, conn, os, serviceName, parameters, isRestDispatching);
                return;
            }
            if (serviceName != null && parameters.containsKey("wsdl2")) {
                this.generateWsdl2(request, response, msgContext, conn, os, serviceName, isRestDispatching);
                return;
            }
            if (serviceName != null && parameters.containsKey("xsd")) {
                this.generateXsd(request, response, msgContext, conn, os, serviceName, parameters, isRestDispatching);
                return;
            }
            if (serviceName != null && parameters.containsKey("info")) {
                this.generateServiceDetailsPage(response, conn, os, serviceName);
            } else if (uri.startsWith(servicePath) && (serviceName == null || serviceName.length() == 0)) {
                this.generateServicesList(response, conn, os, servicePath);
            } else {
                this.processGetAndDelete(request, response, msgContext, conn, os, "GET", isRestDispatching);
                return;
            }
        }
        this.closeOutputStream(os);
    }

    private void closeOutputStream(OutputStream os) {
        try {
            os.flush();
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean isServiceListBlocked(String incomingURI) {
        String isBlocked = NHttpConfiguration.getInstance().isServiceListBlocked();
        return ("/services".equals(incomingURI) || "/services/".equals(incomingURI)) && Boolean.parseBoolean(isBlocked);
    }

    protected String getServiceName(HttpRequest request) {
        int opnStart;
        String uri = request.getRequestLine().getUri();
        String servicePath = this.cfgCtx.getServiceContextPath();
        if (!servicePath.startsWith("/")) {
            servicePath = "/" + servicePath;
        }
        String serviceName = null;
        if (uri.startsWith(servicePath)) {
            serviceName = uri.substring(servicePath.length());
            if (serviceName.startsWith("/")) {
                serviceName = serviceName.substring(1);
            }
            if (serviceName.indexOf("?") != -1) {
                serviceName = serviceName.substring(0, serviceName.indexOf("?"));
            }
        } else {
            String incomingURI = request.getRequestLine().getUri();
            Map serviceURIMap = (Map)this.cfgCtx.getProperty("service.epr.map");
            if (serviceURIMap != null) {
                Set keySet = serviceURIMap.keySet();
                for (Object key : keySet) {
                    if (!incomingURI.toLowerCase().contains(((String)key).toLowerCase())) continue;
                    return (String)serviceURIMap.get(key);
                }
            }
        }
        if (serviceName != null && (opnStart = serviceName.indexOf("/")) != -1) {
            serviceName = serviceName.substring(0, opnStart);
        }
        return serviceName;
    }

    protected void generateServicesList(HttpResponse response, NHttpServerConnection conn, OutputStream os, String servicePath) {
        try {
            byte[] bytes = this.getServicesHTML(servicePath.endsWith("/") ? "" : servicePath + "/").getBytes();
            response.addHeader(CONTENT_TYPE, TEXT_HTML);
            this.serverHandler.commitResponseHideExceptions(conn, response);
            os.write(bytes);
        }
        catch (IOException e) {
            this.handleBrowserException(response, conn, os, "Error generating services list", e);
        }
    }

    protected void generateServiceDetailsPage(HttpResponse response, NHttpServerConnection conn, OutputStream os, String serviceName) {
        AxisService service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
        if (service != null) {
            String parameterValue = (String)service.getParameterValue("serviceType");
            if ("proxy".equals(parameterValue) && !this.isWSDLProvidedForProxyService(service)) {
                this.handleBrowserException(response, conn, os, "No WSDL was provided for the Service " + serviceName + ". A WSDL cannot be generated.", null);
            }
            try {
                byte[] bytes = HTTPTransportReceiver.printServiceHTML((String)serviceName, (ConfigurationContext)this.cfgCtx).getBytes();
                response.addHeader(CONTENT_TYPE, TEXT_HTML);
                this.serverHandler.commitResponseHideExceptions(conn, response);
                os.write(bytes);
            }
            catch (IOException e) {
                this.handleBrowserException(response, conn, os, "Error generating service details page for : " + serviceName, e);
            }
        } else {
            this.handleBrowserException(response, conn, os, "Invalid service : " + serviceName, null);
        }
    }

    protected void generateXsd(HttpRequest request, HttpResponse response, MessageContext messageCtx, NHttpServerConnection conn, OutputStream os, String serviceName, Map<String, String> parameters, boolean isRestDispatching) {
        if (parameters.get("xsd") == null || "".equals(parameters.get("xsd"))) {
            AxisService service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
            if (service != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    service.printSchema((OutputStream)baos);
                    response.addHeader(CONTENT_TYPE, TEXT_XML);
                    this.serverHandler.commitResponseHideExceptions(conn, response);
                    os.write(baos.toByteArray());
                    this.closeOutputStream(os);
                }
                catch (Exception e) {
                    this.handleBrowserException(response, conn, os, "Error generating ?xsd output for service : " + serviceName, e);
                }
            } else {
                this.processGetAndDelete(request, response, messageCtx, conn, os, serviceName, isRestDispatching);
            }
        } else {
            String schemaName = parameters.get("xsd");
            AxisService service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
            if (service != null) {
                int dotIndex;
                service.populateSchemaMappings();
                Map schemaTable = service.getSchemaMappingTable();
                XmlSchema schema = (XmlSchema)schemaTable.get(schemaName);
                if (schema == null && (dotIndex = schemaName.indexOf(46)) > 0) {
                    String schemaKey = schemaName.substring(0, dotIndex);
                    schema = (XmlSchema)schemaTable.get(schemaKey);
                }
                if (schema != null) {
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        schema.write((OutputStream)baos);
                        response.addHeader(CONTENT_TYPE, TEXT_XML);
                        this.serverHandler.commitResponseHideExceptions(conn, response);
                        os.write(baos.toByteArray());
                        this.closeOutputStream(os);
                    }
                    catch (Exception e) {
                        this.handleBrowserException(response, conn, os, "Error generating named ?xsd output for service : " + serviceName, e);
                    }
                } else {
                    response.setStatusCode(404);
                    this.closeOutputStream(os);
                }
            } else {
                this.processGetAndDelete(request, response, messageCtx, conn, os, serviceName, isRestDispatching);
            }
        }
    }

    protected void generateWsdl2(HttpRequest request, HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, OutputStream os, String serviceName, boolean isRestDispatching) {
        AxisService service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
        if (service != null) {
            String parameterValue = (String)service.getParameterValue("serviceType");
            if ("proxy".equals(parameterValue) && !this.isWSDLProvidedForProxyService(service)) {
                this.handleBrowserException(response, conn, os, "No WSDL was provided for the Service " + serviceName + ". A WSDL cannot be generated.", null);
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                service.printWSDL2((OutputStream)baos, DefaultHttpGetProcessor.getIpAddress());
                response.addHeader(CONTENT_TYPE, TEXT_XML);
                this.serverHandler.commitResponseHideExceptions(conn, response);
                os.write(baos.toByteArray());
                this.closeOutputStream(os);
            }
            catch (Exception e) {
                this.handleBrowserException(response, conn, os, "Error generating ?wsdl2 output for service : " + serviceName, e);
            }
        } else {
            this.processGetAndDelete(request, response, msgContext, conn, os, "GET", isRestDispatching);
        }
    }

    protected void generateWsdl(HttpRequest request, HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, OutputStream os, String serviceName, Map<String, String> parameters, boolean isRestDispatching) {
        AxisService service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
        if (service != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                String parameterValue = parameters.get("wsdl");
                if (parameterValue == null) {
                    service.printWSDL((OutputStream)baos, DefaultHttpGetProcessor.getIpAddress());
                } else {
                    service.printUserWSDL((OutputStream)baos, parameterValue);
                }
                response.addHeader(CONTENT_TYPE, TEXT_XML);
                this.serverHandler.commitResponseHideExceptions(conn, response);
                os.write(baos.toByteArray());
                this.closeOutputStream(os);
            }
            catch (Exception e) {
                this.handleBrowserException(response, conn, os, "Error generating ?wsdl output for service : " + serviceName, e);
            }
        } else {
            this.processGetAndDelete(request, response, msgContext, conn, os, "GET", isRestDispatching);
        }
    }

    protected void processGetAndDelete(HttpRequest request, HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, OutputStream os, String method, boolean isRestDispatching) {
        try {
            RESTUtil.processGetAndDeleteRequest(msgContext, os, request.getRequestLine().getUri(), request.getFirstHeader(CONTENT_TYPE), method, isRestDispatching);
        }
        catch (AxisFault axisFault) {
            this.handleException(response, msgContext, conn, os, "Error processing " + method + " request for: " + request.getRequestLine().getUri(), (Exception)((Object)axisFault));
        }
    }

    protected void handleException(HttpResponse response, MessageContext msgContext, NHttpServerConnection conn, OutputStream os, String msg, Exception e) {
        block10: {
            if (e == null) {
                log.error((Object)msg);
            } else {
                log.error((Object)msg, (Throwable)e);
            }
            if (e == null) {
                e = new Exception(msg);
            }
            try {
                MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
                AxisEngine.sendFault((MessageContext)faultContext);
            }
            catch (Exception ex) {
                response.setStatusCode(500);
                response.addHeader(CONTENT_TYPE, TEXT_XML);
                this.serverHandler.commitResponseHideExceptions(conn, response);
                try {
                    os.write(msg.getBytes());
                    if (ex != null) {
                        os.write(ex.getMessage().getBytes());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (conn == null) break block10;
                try {
                    conn.shutdown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected void handleBrowserException(HttpResponse response, NHttpServerConnection conn, OutputStream os, String msg, Exception e) {
        if (e == null) {
            log.error((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        if (!response.containsHeader("Transfer-Encoding")) {
            response.setStatusCode(500);
            response.setReasonPhrase(msg);
            response.addHeader(CONTENT_TYPE, TEXT_HTML);
            this.serverHandler.commitResponseHideExceptions(conn, response);
            try {
                os.write(msg.getBytes());
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected boolean isWSDLProvidedForProxyService(AxisService service) {
        boolean isWSDLProvided = false;
        if (service.getParameterValue("wsdl4jDefinition") != null || service.getParameterValue("WSDL20Description") != null) {
            isWSDLProvided = true;
        }
        return isWSDLProvided;
    }

    protected static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = "127.0.0.1";
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !DefaultHttpGetProcessor.isIP(ip.getHostAddress())) continue;
                return ip.getHostAddress();
            }
        }
        return address;
    }

    protected static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }

    protected String getServicesHTML(String prefix) {
        HashMap services = this.cfgCtx.getAxisConfiguration().getServices();
        Hashtable erroneousServices = this.cfgCtx.getAxisConfiguration().getFaultyServices();
        boolean servicesFound = false;
        StringBuffer resultBuf = new StringBuffer();
        resultBuf.append("<html><head><title>Axis2: Services</title></head><body>");
        if (services != null && !services.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<h2>Deployed services</h2>");
            for (Object service : services.values()) {
                AxisService axisService = (AxisService)service;
                Parameter parameter = axisService.getParameter("hiddenService");
                if (axisService.getName().startsWith("__") || parameter != null && JavaUtils.isTrueExplicitly((Object)parameter.getValue())) continue;
                Iterator iterator = axisService.getOperations();
                resultBuf.append("<h3><a href=\"").append(prefix).append(axisService.getName()).append("?wsdl\">").append(axisService.getName()).append("</a></h3>");
                if (iterator.hasNext()) {
                    resultBuf.append("Available operations <ul>");
                    while (iterator.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)iterator.next();
                        resultBuf.append("<li>").append(axisOperation.getName().getLocalPart()).append("</li>");
                    }
                    resultBuf.append("</ul>");
                    continue;
                }
                resultBuf.append("No operations specified for this service");
            }
        }
        if (erroneousServices != null && !erroneousServices.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<hr><h2><font color=\"blue\">Faulty Services</font></h2>");
            Enumeration faultyservices = erroneousServices.keys();
            while (faultyservices.hasMoreElements()) {
                String faultyserviceName = (String)faultyservices.nextElement();
                resultBuf.append("<h3><font color=\"blue\">").append(faultyserviceName).append("</font></h3>");
            }
        }
        if (!servicesFound) {
            resultBuf.append("<h2>There are no services deployed</h2>");
        }
        resultBuf.append("</body></html>");
        return resultBuf.toString();
    }
}

