/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;

public class ConnectionPool {
    private static final Log log = LogFactory.getLog(ConnectionPool.class);
    private final String SSL_SCHEMA_NAME = "https";
    private final Map<HttpRoute, List<NHttpClientConnection>> connMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NHttpClientConnection getConnection(HttpRoute route) {
        List<NHttpClientConnection> connections = this.connMap.get(route);
        if (connections == null || connections.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No connections available for reuse");
            }
            return null;
        }
        NHttpClientConnection conn = null;
        List<NHttpClientConnection> list = connections;
        synchronized (list) {
            while (!connections.isEmpty()) {
                conn = connections.remove(0);
                if (conn.isOpen() && !conn.isStale()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A connection  : " + route + " is available in the pool, and will be reused"));
                    }
                    conn.requestInput();
                    return conn;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("closing stale connection : " + route));
                }
                try {
                    conn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(NHttpClientConnection conn) {
        HttpContext ctx = conn.getContext();
        Axis2HttpRequest axis2Req = (Axis2HttpRequest)ctx.getAttribute("synapse.axis2-http-request");
        HttpRoute route = axis2Req.getRoute();
        List<Object> connections = null;
        Map<HttpRoute, List<NHttpClientConnection>> map = this.connMap;
        synchronized (map) {
            connections = this.connMap.get(route);
            if (connections == null) {
                connections = Collections.synchronizedList(new LinkedList());
                this.connMap.put(route, connections);
            }
        }
        ConnectionPool.cleanConnectionReferences(conn);
        connections.add(conn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Released a connection : " + route + " to the connection pool of current size : " + connections.size()));
        }
    }

    private static void cleanConnectionReferences(NHttpClientConnection conn) {
        HttpContext ctx = conn.getContext();
        Axis2HttpRequest axis2Req = (Axis2HttpRequest)ctx.getAttribute("synapse.axis2-http-request");
        axis2Req.clear();
        ctx.removeAttribute("synapse.axis2-attachment");
        ctx.removeAttribute("synapse.tunnel-handler");
        ctx.removeAttribute("synapse.axis2-http-request");
        ctx.removeAttribute("synapse.axis2_message_context");
        ctx.removeAttribute("synapse.request-source-buffer");
        ctx.removeAttribute("synapse.response-sink-buffer");
        ctx.removeAttribute("http.request");
        ctx.removeAttribute("http.response");
        ctx.removeAttribute("endPointURI");
        conn.resetOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(NHttpClientConnection conn) {
        HttpRoute route;
        List<NHttpClientConnection> connections;
        HttpContext ctx = conn.getContext();
        Axis2HttpRequest axis2Req = (Axis2HttpRequest)ctx.getAttribute("synapse.axis2-http-request");
        if (axis2Req != null && (connections = this.connMap.get(route = axis2Req.getRoute())) != null) {
            List<NHttpClientConnection> list = connections;
            synchronized (list) {
                connections.remove(conn);
            }
        }
    }

    public List<NHttpClientConnection> getSslConnectionsList(Set<String> hostList) {
        ArrayList<NHttpClientConnection> selectedConnections = new ArrayList<NHttpClientConnection>();
        for (String host : hostList) {
            try {
                String[] params = host.split(":");
                for (HttpRoute httpRoute : this.connMap.keySet()) {
                    List<NHttpClientConnection> clientConnections;
                    if (params.length <= 1 || !params[0].equalsIgnoreCase(httpRoute.getTargetHost().getHostName()) || Integer.valueOf(params[1]).intValue() != httpRoute.getTargetHost().getPort() || !httpRoute.getTargetHost().getSchemeName().equalsIgnoreCase("https") || (clientConnections = this.connMap.get(httpRoute)) == null) continue;
                    int count = 0;
                    for (NHttpClientConnection nHttpClientConnection : clientConnections) {
                        selectedConnections.add(clientConnections.get(count));
                        ++count;
                    }
                }
            }
            catch (NumberFormatException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Error in port number in host:port - " + host + " discard connection loading "), (Throwable)e);
            }
        }
        return selectedConnections;
    }
}

