/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.impl.nio.reactor.AbstractIODispatch;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.synapse.transport.http.conn.ClientConnFactory;
import org.apache.synapse.transport.http.conn.LoggingUtils;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;

class ClientIODispatch
extends AbstractIODispatch<DefaultNHttpClientConnection> {
    private final NHttpClientEventHandler handler;
    private ClientConnFactory connFactory;

    public ClientIODispatch(NHttpClientEventHandler handler, ClientConnFactory connFactory) {
        this.handler = LoggingUtils.decorate(handler);
        this.connFactory = connFactory;
    }

    protected DefaultNHttpClientConnection createConnection(IOSession session) {
        Axis2HttpRequest axis2Req = (Axis2HttpRequest)session.getAttribute("http.session.attachment");
        HttpRoute route = axis2Req.getRoute();
        return this.connFactory.createConnection(session, route);
    }

    protected void onConnected(DefaultNHttpClientConnection conn) {
        Axis2HttpRequest axis2Req = (Axis2HttpRequest)conn.getContext().getAttribute("http.session.attachment");
        try {
            this.handler.connected((NHttpClientConnection)conn, (Object)axis2Req);
        }
        catch (Exception ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
        }
    }

    protected void onClosed(DefaultNHttpClientConnection conn) {
        this.handler.closed((NHttpClientConnection)conn);
    }

    protected void onException(DefaultNHttpClientConnection conn, IOException ex) {
        this.handler.exception((NHttpClientConnection)conn, (Exception)ex);
    }

    protected void onInputReady(DefaultNHttpClientConnection conn) {
        conn.consumeInput(this.handler);
    }

    protected void onOutputReady(DefaultNHttpClientConnection conn) {
        conn.produceOutput(this.handler);
    }

    protected void onTimeout(DefaultNHttpClientConnection conn) {
        try {
            this.handler.timeout((NHttpClientConnection)conn);
        }
        catch (Exception ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
        }
    }

    public void setConnFactory(ClientConnFactory connFactory) {
        this.connFactory = connFactory;
    }
}

