/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.util.blob.BlobOutputStream;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;

public class Axis2HttpRequest {
    private static final Log log = LogFactory.getLog(Axis2HttpRequest.class);
    private EndpointReference epr = null;
    private int timeout = -1;
    private MessageContext msgContext = null;
    MessageFormatter messageFormatter = null;
    OMOutputFormat format = null;
    private ContentOutputBuffer outputBuffer = null;
    private volatile boolean readyToStream = false;
    private volatile boolean sendingCompleted = false;
    private volatile boolean completed = false;
    private String endpointURLPrefix = null;
    private HttpRoute route;
    private boolean chunked = true;

    public Axis2HttpRequest(EndpointReference epr, HttpRoute route, MessageContext msgContext) {
        this.epr = epr;
        this.route = route;
        this.msgContext = msgContext;
        this.format = NhttpUtil.getOMOutputFormat(msgContext);
        this.messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
        this.chunked = !msgContext.isPropertyTrue("DISABLE_CHUNKING");
    }

    public void setReadyToStream(boolean readyToStream) {
        this.readyToStream = readyToStream;
    }

    public void setOutputBuffer(ContentOutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public void clear() {
        this.epr = null;
        this.route = null;
        this.msgContext = null;
        this.format = null;
        this.messageFormatter = null;
        this.outputBuffer = null;
    }

    public EndpointReference getEpr() {
        return this.epr;
    }

    public HttpRoute getRoute() {
        return this.route;
    }

    public MessageContext getMsgContext() {
        return this.msgContext;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getEndpointURLPrefix() {
        return this.endpointURLPrefix;
    }

    public void setEndpointURLPrefix(String endpointURLPrefix) {
        this.endpointURLPrefix = endpointURLPrefix;
    }

    public HttpRequest getRequest() throws IOException, HttpException {
        String soapAction;
        BasicHttpRequest httpRequest;
        String httpMethod = (String)this.msgContext.getProperty("HTTP_METHOD");
        if (httpMethod == null) {
            httpMethod = "POST";
        }
        this.endpointURLPrefix = (String)this.msgContext.getProperty("ENDPOINT_PREFIX");
        boolean forceHTTP10 = this.msgContext.isPropertyTrue("FORCE_HTTP_1.0");
        HttpVersion httpver = forceHTTP10 ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
        try {
            URI uri;
            if ("POST".equals(httpMethod) || "PUT".equals(httpMethod) || "PATCH".equals(httpMethod)) {
                uri = this.rewriteRequestURI(new URI(this.epr.getAddress()));
                BasicHttpEntityEnclosingRequest requestWithEntity = new BasicHttpEntityEnclosingRequest(httpMethod, uri.toASCIIString(), (ProtocolVersion)httpver);
                BasicHttpEntity entity = new BasicHttpEntity();
                if (forceHTTP10) {
                    this.setStreamAsTempData(entity);
                } else {
                    entity.setChunked(this.chunked);
                    if (!this.chunked) {
                        this.setStreamAsTempData(entity);
                    }
                }
                requestWithEntity.setEntity((HttpEntity)entity);
                requestWithEntity.setHeader("Content-Type", this.messageFormatter.getContentType(this.msgContext, this.format, this.msgContext.getSoapAction()));
                httpRequest = requestWithEntity;
            } else if ("GET".equals(httpMethod) || "DELETE".equals(httpMethod)) {
                URL url = this.messageFormatter.getTargetAddress(this.msgContext, this.format, new URL(this.epr.getAddress()));
                URI uri2 = this.rewriteRequestURI(url.toURI());
                httpRequest = new BasicHttpRequest(httpMethod, uri2.toASCIIString(), (ProtocolVersion)httpver);
            } else {
                uri = this.rewriteRequestURI(new URI(this.epr.getAddress()));
                httpRequest = new BasicHttpRequest(httpMethod, uri.toASCIIString(), (ProtocolVersion)httpver);
            }
        }
        catch (URISyntaxException ex) {
            throw new HttpException(ex.getMessage(), (Throwable)ex);
        }
        Object o = this.msgContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            Map headers = (Map)o;
            for (Object header : headers.keySet()) {
                Object value = headers.get(header);
                if (!(header instanceof String) || value == null || !(value instanceof String)) continue;
                if (!"Host".equalsIgnoreCase((String)header)) {
                    httpRequest.setHeader((String)header, (String)value);
                    String excessProp = "EXCESS_TRANSPORT_HEADERS";
                    Map map = (Map)this.msgContext.getProperty(excessProp);
                    if (map == null || map.get(header) == null) continue;
                    log.debug((Object)("Number of excess values for " + header + " header is : " + ((Collection)map.get(header)).size()));
                    for (String key : map.keySet()) {
                        for (String excessVal : (Collection)map.get(key)) {
                            httpRequest.addHeader((String)header, excessVal);
                        }
                    }
                    continue;
                }
                if (this.msgContext.getProperty("REQUEST_HOST_HEADER") == null) continue;
                httpRequest.setHeader((String)header, (String)this.msgContext.getProperty("REQUEST_HOST_HEADER"));
            }
        }
        if ((soapAction = this.msgContext.getSoapAction()) == null) {
            soapAction = this.msgContext.getWSAAction();
        }
        if (soapAction == null) {
            this.msgContext.getAxisOperation().getInputAction();
        }
        if (this.msgContext.isSOAP11() && soapAction != null && soapAction.length() >= 0) {
            Header existingHeader = httpRequest.getFirstHeader("SOAPAction");
            if (existingHeader != null) {
                httpRequest.removeHeader(existingHeader);
            }
            httpRequest.setHeader("SOAPAction", this.messageFormatter.formatSOAPAction(this.msgContext, null, soapAction));
        }
        if (NHttpConfiguration.getInstance().isKeepAliveDisabled() || this.msgContext.isPropertyTrue("NO_KEEPALIVE")) {
            httpRequest.setHeader("Connection", "Close");
        }
        return httpRequest;
    }

    private URI rewriteRequestURI(URI uri) throws URISyntaxException {
        if (this.msgContext.isPropertyTrue("POST_TO_URI") || this.route.getProxyHost() != null && !this.route.isTunnelled()) {
            return uri;
        }
        return URIUtils.rewriteURI((URI)uri, null, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void streamMessageContents() throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start streaming outgoing http request : [Message ID : " + this.msgContext.getMessageID() + "]"));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Message [Request Message ID : " + this.msgContext.getMessageID() + "] [Request Message Payload : [ " + this.msgContext.getEnvelope() + "]"));
            }
        }
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        int senderTimeout = cfg.getProperty("http.socket.timeout.sender", 60000);
        long startTime = System.currentTimeMillis();
        Axis2HttpRequest axis2HttpRequest = this;
        synchronized (axis2HttpRequest) {
            while (!this.readyToStream && !this.completed) {
                try {
                    this.wait(senderTimeout + 10000);
                    if (startTime + (long)senderTimeout + 5000L >= System.currentTimeMillis()) continue;
                    this.handleException("Thread " + Thread.currentThread().getName() + " is blocked longer than the send timeout when trying to send the message :" + this.msgContext.getMessageID() + ". Releasing thread", (Exception)((Object)new AxisFault("Sender thread was not notified within send timeout")));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.completed) return;
        ContentOutputStream out = new ContentOutputStream(this.outputBuffer);
        try {
            if (this.msgContext.isPropertyTrue("FORCE_HTTP_1.0")) {
                this.writeMessageFromTempData((OutputStream)out);
                return;
            }
            if (this.chunked) {
                this.messageFormatter.writeTo(this.msgContext, this.format, (OutputStream)out, false);
                return;
            }
            this.writeMessageFromTempData((OutputStream)out);
            return;
        }
        catch (Exception e) {
            Integer errorCode;
            Throwable t = e.getCause();
            if (t != null && t.getCause() != null && t.getCause() instanceof ClosedChannelException) {
                if (!log.isDebugEnabled()) return;
                log.debug((Object)"Ignore closed channel exception, as the SessionRequestCallback handles this exception");
                return;
            }
            Integer n = errorCode = this.msgContext == null ? null : (Integer)this.msgContext.getProperty("ERROR_CODE");
            if (errorCode == null || errorCode == 101509) {
                if (!log.isDebugEnabled()) return;
                log.debug((Object)"Remote server aborted request being sent, and responded");
                return;
            }
            if (e instanceof AxisFault) {
                throw (AxisFault)((Object)e);
            }
            this.handleException("Error streaming message context", e);
            return;
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                this.handleException("Error closing outgoing message stream", e);
            }
            this.setSendingCompleted(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStreamAsTempData(BasicHttpEntity entity) throws IOException {
        OverflowBlob serialized = new OverflowBlob(256, 4096, "http-nio_", ".dat");
        try (BlobOutputStream out = serialized.getOutputStream();){
            this.messageFormatter.writeTo(this.msgContext, this.format, (OutputStream)out, true);
        }
        this.msgContext.setProperty("SerializedBytes", (Object)serialized);
        entity.setContentLength(serialized.getLength());
    }

    private void writeMessageFromTempData(OutputStream out) throws IOException {
        OverflowBlob serialized = (OverflowBlob)this.msgContext.getProperty("SerializedBytes");
        try {
            serialized.writeTo(out);
        }
        finally {
            serialized.release();
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompleted(boolean completed) {
        this.completed = completed;
        Axis2HttpRequest axis2HttpRequest = this;
        synchronized (axis2HttpRequest) {
            this.notifyAll();
        }
    }

    public boolean isSendingCompleted() {
        return this.sendingCompleted;
    }

    public void setSendingCompleted(boolean sendingCompleted) {
        this.sendingCompleted = sendingCompleted;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Axis2Request [Message ID : ").append(this.msgContext.getMessageID()).append("] ");
        sb.append("[Status Completed : ").append(this.isCompleted() ? "true" : "false").append("] ");
        sb.append("[Status SendingCompleted : ").append(this.isSendingCompleted() ? "true" : "false").append("]");
        return sb.toString();
    }
}

