/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.http.nio.reactor.IOSession;
import org.apache.synapse.transport.http.conn.LoggingUtils;
import org.apache.synapse.transport.http.conn.SynapseDebugInfoHolder;
import org.apache.synapse.transport.http.conn.SynapseWireLogHolder;

class Wire {
    private IOSession session;
    private final Log log;

    public Wire(Log log) {
        this.log = log;
    }

    private void wire(String header, byte[] b, int pos, int off) {
        StringBuilder buffer = new StringBuilder();
        StringBuilder tmpBuffer = new StringBuilder();
        StringBuilder synapseBuffer = new StringBuilder();
        for (int i = 0; i < off; ++i) {
            int ch = b[pos + i] & 0xFF;
            if (ch == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch == 10) {
                tmpBuffer.setLength(0);
                tmpBuffer.append(buffer.toString());
                tmpBuffer.insert(0, header);
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header);
                if (this.isEnabled()) {
                    Pattern pattern;
                    String line = buffer.toString();
                    String skipLogging = System.getProperty("skip.logging");
                    if ("true".equals(skipLogging) && (pattern = LoggingUtils.getSkipLoggingMatcher()) != null && pattern.matcher(line).find()) break;
                    this.log.debug((Object)(Thread.currentThread().getName() + " " + line));
                }
                synapseBuffer.append(tmpBuffer.toString());
                synapseBuffer.append(System.lineSeparator());
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            buffer.append('\"');
            buffer.insert(0, '\"');
            buffer.insert(0, header);
            if (this.isEnabled()) {
                String line = buffer.toString();
                String skipLogging = System.getProperty("skip.logging");
                if ("true".equals(skipLogging)) {
                    Pattern pattern = LoggingUtils.getSkipLoggingMatcher();
                    if (pattern != null && !pattern.matcher(line).find()) {
                        this.log.debug((Object)(Thread.currentThread().getName() + " " + line));
                    }
                } else {
                    this.log.debug((Object)(Thread.currentThread().getName() + " " + line));
                }
            }
            tmpBuffer.setLength(0);
            tmpBuffer.append(buffer.toString());
            synapseBuffer.append(tmpBuffer.toString());
        }
        if (synapseBuffer.length() > 0 && SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            String mediatorId;
            SynapseWireLogHolder logHolder;
            Object holder = this.session.getAttribute("synapse.wire.log.holder");
            if (holder == null) {
                logHolder = new SynapseWireLogHolder();
            } else {
                logHolder = (SynapseWireLogHolder)holder;
                if (logHolder.getPhase().equals((Object)SynapseWireLogHolder.PHASE.SOURCE_RESPONSE_DONE)) {
                    logHolder.clear();
                }
            }
            if (logHolder.getPhase().equals((Object)SynapseWireLogHolder.PHASE.SOURCE_REQUEST_READY)) {
                this.log.debug((Object)("source request wire Log added to the log holder, phase - " + logHolder.getPhase().toString()));
                logHolder.appendRequestWireLog(synapseBuffer.toString());
            } else if (logHolder.getPhase().equals((Object)SynapseWireLogHolder.PHASE.TARGET_REQUEST_READY)) {
                mediatorId = (String)this.session.getAttribute("synapse.wire.log.mediator.id");
                if (mediatorId == null || mediatorId.isEmpty()) {
                    mediatorId = "{ \"dummyID\" : \"dummy\"}";
                }
                this.log.debug((Object)("wire Log added to the log holder, phase - " + logHolder.getPhase().toString() + ", mediatorId - " + mediatorId));
                logHolder.appendBackEndWireLog(SynapseWireLogHolder.RequestType.REQUEST, synapseBuffer.toString(), mediatorId);
            } else if (logHolder.getPhase().equals((Object)SynapseWireLogHolder.PHASE.TARGET_RESPONSE_READY)) {
                mediatorId = (String)this.session.getAttribute("synapse.wire.log.mediator.id");
                if (mediatorId == null || mediatorId.isEmpty()) {
                    mediatorId = "{ \"dummyID\" : \"dummy\"}";
                }
                this.log.debug((Object)("wire Log added to the log holder, phase - " + logHolder.getPhase().toString() + ", mediatorId - " + mediatorId));
                logHolder.appendBackEndWireLog(SynapseWireLogHolder.RequestType.RESPONSE, synapseBuffer.toString(), mediatorId);
            } else if (logHolder.getPhase().equals((Object)SynapseWireLogHolder.PHASE.SOURCE_RESPONSE_READY)) {
                this.log.debug((Object)("source response wire Log added to the log holder, phase - " + logHolder.getPhase().toString()));
                logHolder.appendResponseWireLog(synapseBuffer.toString());
            }
            this.session.setAttribute("synapse.wire.log.holder", (Object)logHolder);
        }
    }

    public boolean isEnabled() {
        return this.log.isDebugEnabled();
    }

    public void output(byte[] b, int pos, int off) {
        this.wire("<< ", b, pos, off);
    }

    public void input(byte[] b, int pos, int off) {
        this.wire(">> ", b, pos, off);
    }

    public void output(byte[] b) {
        this.output(b, 0, b.length);
    }

    public void input(byte[] b) {
        this.input(b, 0, b.length);
    }

    public void output(int b) {
        this.output(new byte[]{(byte)b});
    }

    public void input(int b) {
        this.input(new byte[]{(byte)b});
    }

    public void output(ByteBuffer b) {
        if (b.hasArray()) {
            this.output(b.array(), b.arrayOffset() + b.position(), b.remaining());
        } else {
            byte[] tmp = new byte[b.remaining()];
            b.get(tmp);
            this.output(tmp);
        }
    }

    public void input(ByteBuffer b) {
        if (b.hasArray()) {
            this.input(b.array(), b.arrayOffset() + b.position(), b.remaining());
        } else {
            byte[] tmp = new byte[b.remaining()];
            b.get(tmp);
            this.input(tmp);
        }
    }

    public void setSession(IOSession session) {
        this.session = session;
    }
}

