/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.transport.http.conn.SynapseBackEndWireLogs;

public class SynapseWireLogHolder
implements Serializable {
    private String proxyName = null;
    private String apiName = null;
    private String resourceUrlString = null;
    private StringBuilder requestWireLog;
    private StringBuilder responseWireLog;
    private Map<String, SynapseBackEndWireLogs> backEndRequestResponse = new HashMap<String, SynapseBackEndWireLogs>(1);
    private PHASE phase = PHASE.SOURCE_REQUEST_READY;

    public SynapseWireLogHolder() {
        this.requestWireLog = new StringBuilder();
        this.responseWireLog = new StringBuilder();
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public String getApiName() {
        return this.apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getResourceUrlString() {
        return this.resourceUrlString;
    }

    public void setResourceUrlString(String resourceUrlString) {
        this.resourceUrlString = resourceUrlString;
    }

    public String getRequestWireLog() {
        return this.requestWireLog.toString();
    }

    public void appendRequestWireLog(String requestWireLog) {
        this.requestWireLog.append(requestWireLog);
    }

    public String getResponseWireLog() {
        return this.responseWireLog.toString();
    }

    public void appendResponseWireLog(String responseWireLog) {
        this.responseWireLog.append(responseWireLog);
    }

    public PHASE getPhase() {
        return this.phase;
    }

    public synchronized void setPhase(PHASE phase) {
        this.phase = phase;
    }

    public synchronized void appendBackEndWireLog(RequestType type, String wireLog, String mediatorId) {
        SynapseBackEndWireLogs backEndWireLogs = this.backEndRequestResponse.get(mediatorId);
        if (backEndWireLogs == null) {
            backEndWireLogs = new SynapseBackEndWireLogs();
            backEndWireLogs.setMediatorID(mediatorId);
        }
        if (type.equals((Object)RequestType.REQUEST)) {
            backEndWireLogs.appendRequestWireLog(wireLog);
        } else if (type.equals((Object)RequestType.RESPONSE)) {
            backEndWireLogs.appendResponseWireLog(wireLog);
        }
        this.backEndRequestResponse.put(mediatorId, backEndWireLogs);
    }

    public Map<String, SynapseBackEndWireLogs> getBackEndRequestResponse() {
        return this.backEndRequestResponse;
    }

    public synchronized void clear() {
        this.requestWireLog.setLength(0);
        this.responseWireLog.setLength(0);
        this.backEndRequestResponse.clear();
        this.phase = PHASE.SOURCE_REQUEST_READY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynapseWireLogHolder deepClone() throws IOException, ClassNotFoundException {
        ObjectOutputStream wireLogHolderOutputStream = null;
        ObjectInputStream wireLogHolderInputStream = null;
        try {
            ByteArrayOutputStream binaryOutputStream = new ByteArrayOutputStream();
            wireLogHolderOutputStream = new ObjectOutputStream(binaryOutputStream);
            wireLogHolderOutputStream.writeObject(this);
            wireLogHolderOutputStream.flush();
            ByteArrayInputStream binaryInputStream = new ByteArrayInputStream(binaryOutputStream.toByteArray());
            wireLogHolderInputStream = new ObjectInputStream(binaryInputStream);
            SynapseWireLogHolder synapseWireLogHolder = (SynapseWireLogHolder)wireLogHolderInputStream.readObject();
            return synapseWireLogHolder;
        }
        finally {
            wireLogHolderOutputStream.close();
            wireLogHolderInputStream.close();
        }
    }

    public static enum RequestType {
        REQUEST,
        RESPONSE;

    }

    public static enum PHASE {
        SOURCE_REQUEST_READY,
        SOURCE_REQUEST_DONE,
        TARGET_REQUEST_READY,
        TARGET_REQUEST_DONE,
        TARGET_RESPONSE_READY,
        TARGET_RESPONSE_DONE,
        SOURCE_RESPONSE_READY,
        SOURCE_RESPONSE_DONE;

    }
}

