/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.io.IOException;
import java.util.Observable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.http.conn.SynapseWireLogHolder;

public class SynapseDebugInfoHolder
extends Observable {
    private final Log log = LogFactory.getLog(SynapseDebugInfoHolder.class);
    public static final String SYNAPSE_WIRE_LOG_HOLDER_PROPERTY = "synapse.wire.log.holder";
    public static final String SYNAPSE_WIRE_LOG_MEDIATOR_ID_PROPERTY = "synapse.wire.log.mediator.id";
    public static final String DUMMY_MEDIATOR_ID = "{ \"dummyID\" : \"dummy\"}";
    private boolean isDebuggerEnabled = false;
    private static SynapseDebugInfoHolder debugInfoHolder;

    private SynapseDebugInfoHolder() {
    }

    public static synchronized SynapseDebugInfoHolder getInstance() {
        if (debugInfoHolder == null) {
            debugInfoHolder = new SynapseDebugInfoHolder();
        }
        return debugInfoHolder;
    }

    public void setDebuggerEnabled(boolean isDebuggerEnabled) {
        this.isDebuggerEnabled = isDebuggerEnabled;
    }

    public boolean isDebuggerEnabled() {
        return this.isDebuggerEnabled;
    }

    public synchronized void setWireLogHolder(SynapseWireLogHolder wireLogHolder) {
        try {
            SynapseWireLogHolder clonedHolder = wireLogHolder.deepClone();
            wireLogHolder.clear();
            this.setChanged();
            this.notifyObservers(clonedHolder);
        }
        catch (IOException e) {
            this.log.debug((Object)("Error cloning the wirelog holder object - " + e.getMessage()), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.log.debug((Object)("Error cloning the wirelog holder object - " + e.getMessage()), (Throwable)e);
        }
    }
}

