/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.synapse.transport.certificatevalidation.CertificateVerificationException;
import org.apache.synapse.transport.certificatevalidation.RevocationVerificationManager;
import org.apache.synapse.transport.http.conn.SSLClientAuth;

public class ServerSSLSetupHandler
implements SSLSetupHandler {
    private final SSLClientAuth clientAuth;
    private final String[] httpsProtocols;
    private RevocationVerificationManager verificationManager;
    private final String[] preferredCiphers;

    public ServerSSLSetupHandler(SSLClientAuth clientAuth, String[] httpsProtocols, RevocationVerificationManager verificationManager, String[] preferredCiphers) {
        this.clientAuth = clientAuth;
        this.httpsProtocols = httpsProtocols;
        this.verificationManager = verificationManager;
        this.preferredCiphers = preferredCiphers;
    }

    public void initalize(SSLEngine sslengine) throws SSLException {
        if (this.clientAuth != null) {
            switch (this.clientAuth) {
                case OPTIONAL: {
                    sslengine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    sslengine.setNeedClientAuth(true);
                }
            }
        }
        if (this.httpsProtocols != null) {
            sslengine.setEnabledProtocols(this.httpsProtocols);
        }
        if (this.preferredCiphers != null) {
            sslengine.setEnabledCipherSuites(this.preferredCiphers);
        }
    }

    public void verify(IOSession iosession, SSLSession sslsession) throws SSLException {
        if (this.verificationManager != null) {
            try {
                this.verificationManager.verifyRevocationStatus(sslsession.getPeerCertificateChain());
            }
            catch (CertificateVerificationException e) {
                InetSocketAddress inetSocketAddress;
                InetAddress internetAddress;
                SocketAddress remoteAddress = iosession.getRemoteAddress();
                String address = remoteAddress instanceof InetSocketAddress ? ((internetAddress = (inetSocketAddress = (InetSocketAddress)remoteAddress).getAddress()) != null ? internetAddress.getHostAddress() : inetSocketAddress.getHostName()) : remoteAddress.toString();
                throw new SSLException("Certificate Chain Validation failed for host : " + address, e);
            }
        }
    }
}

