/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpRequestFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.http.conn.LoggingUtils;
import org.apache.synapse.transport.http.conn.SSLContextDetails;
import org.apache.synapse.transport.http.conn.SynapseHTTPRequestFactory;

public class ServerConnFactory {
    private final HttpRequestFactory requestFactory;
    private final ByteBufferAllocator allocator;
    private final SSLContextDetails ssl;
    private final Map<InetSocketAddress, SSLContextDetails> sslByIPMap;
    private final HttpParams params;
    public static final String ALL_NETWORK = "0.0.0.0";
    InetSocketAddress allNetworkAddress;

    public ServerConnFactory(HttpRequestFactory requestFactory, ByteBufferAllocator allocator, SSLContextDetails ssl, Map<InetSocketAddress, SSLContextDetails> sslByIPMap, HttpParams params) {
        this.requestFactory = requestFactory != null ? requestFactory : new SynapseHTTPRequestFactory();
        this.allocator = allocator != null ? allocator : new HeapByteBufferAllocator();
        this.ssl = ssl;
        this.sslByIPMap = sslByIPMap != null ? new ConcurrentHashMap<InetSocketAddress, SSLContextDetails>(sslByIPMap) : null;
        this.params = params != null ? params : new BasicHttpParams();
    }

    public ServerConnFactory(SSLContextDetails ssl, Map<InetSocketAddress, SSLContextDetails> sslByIPMap, HttpParams params) {
        this(null, null, ssl, sslByIPMap, params);
    }

    public ServerConnFactory(SSLContextDetails ssl, Map<InetSocketAddress, SSLContextDetails> sslByIPMap, HttpParams params, int port) {
        this(null, null, ssl, sslByIPMap, params);
        this.allNetworkAddress = new InetSocketAddress(ALL_NETWORK, port);
    }

    public ServerConnFactory(HttpParams params) {
        this(null, null, null, null, params);
    }

    public DefaultNHttpServerConnection createConnection(IOSession iosession) {
        IOSession customSession;
        SSLContextDetails customSSL = null;
        if (this.sslByIPMap != null && (customSSL = this.sslByIPMap.get(iosession.getLocalAddress())) == null && this.allNetworkAddress != null) {
            customSSL = this.sslByIPMap.get(this.allNetworkAddress);
        }
        if (customSSL == null) {
            customSSL = this.ssl;
        }
        if (customSSL != null) {
            customSession = new SSLIOSession(iosession, SSLMode.SERVER, customSSL.getContext(), customSSL.getHandler());
            iosession.setAttribute("http.session.ssl", (Object)customSession);
        } else {
            customSession = iosession;
        }
        DefaultNHttpServerConnection conn = LoggingUtils.createServerConnection(customSession, this.requestFactory, this.allocator, this.params);
        int timeout = HttpConnectionParams.getSoTimeout((HttpParams)this.params);
        conn.setSocketTimeout(timeout);
        return conn;
    }

    public Set<InetSocketAddress> getBindAddresses() {
        return this.sslByIPMap != null ? this.sslByIPMap.keySet() : Collections.emptySet();
    }
}

