/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.synapse.transport.http.conn.ClientConnFactory;
import org.apache.synapse.transport.http.conn.UpgradableNHttpConnection;

public class ProxyTunnelHandler {
    private final HttpRoute route;
    private final ClientConnFactory connFactory;
    private final HttpProcessor httpProcessor;
    private volatile boolean requested;
    private volatile boolean completed;
    private volatile boolean successful;

    public ProxyTunnelHandler(HttpRoute route, ClientConnFactory connFactory) {
        this.route = route;
        this.connFactory = connFactory;
        this.httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestClientConnControl()});
    }

    public HttpRequest generateRequest(HttpContext context) throws IOException, HttpException {
        HttpHost target = this.route.getTargetHost();
        BasicHttpRequest connect = new BasicHttpRequest("CONNECT", target.toHostString(), (ProtocolVersion)HttpVersion.HTTP_1_1);
        connect.setHeader("Host", target.toHostString());
        this.httpProcessor.process((HttpRequest)connect, context);
        context.setAttribute("endPointURI", (Object)target.toString());
        return connect;
    }

    public void setRequested() {
        this.requested = true;
    }

    public boolean isRequested() {
        return this.requested;
    }

    public void handleResponse(HttpResponse response, NHttpClientConnection conn) {
        this.completed = true;
        int code = response.getStatusLine().getStatusCode();
        if (code >= 200 && code < 300) {
            this.successful = true;
            if (this.route.isLayered() && conn instanceof UpgradableNHttpConnection) {
                this.connFactory.upgrade((UpgradableNHttpConnection)conn, this.route);
            }
        } else {
            this.successful = false;
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public HttpHost getProxy() {
        return this.route.getProxyHost();
    }
}

