/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.synapse.transport.http.conn.DefaultProxyAuthenticator;
import org.apache.synapse.transport.http.conn.ProfileProxyAuthenticator;
import org.apache.synapse.transport.http.conn.ProxyAuthenticator;
import org.apache.synapse.transport.http.conn.ProxyProfileConfig;

public class ProxyConfig {
    private static final Log log = LogFactory.getLog(ProxyConfig.class);
    private final HttpHost proxy;
    private final UsernamePasswordCredentials creds;
    private final Set<String> proxyBypass;
    private Set<String> knownDirectHosts = new HashSet<String>();
    private Set<String> knownProxyHosts = new HashSet<String>();
    private Map<String, ProxyProfileConfig> knownProxyConfigMap = new HashMap<String, ProxyProfileConfig>();
    private Map<String, ProxyProfileConfig> proxyProfileMap = new HashMap<String, ProxyProfileConfig>();

    public ProxyConfig(HttpHost proxy, UsernamePasswordCredentials creds, String[] proxyBypass, Map<String, ProxyProfileConfig> proxyProfileMap) {
        this.proxy = proxy;
        this.creds = creds;
        if (proxyBypass != null) {
            this.proxyBypass = new LinkedHashSet<String>(proxyBypass.length);
            for (String s : proxyBypass) {
                this.proxyBypass.add(s.trim().toLowerCase(Locale.US));
            }
        } else {
            this.proxyBypass = Collections.emptySet();
        }
        this.proxyProfileMap = proxyProfileMap != null ? proxyProfileMap : Collections.emptyMap();
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public UsernamePasswordCredentials getCreds() {
        return this.creds;
    }

    public Set<String> getProxyBypass() {
        return this.proxyBypass;
    }

    public HttpHost selectProxy(HttpHost target) {
        if (this.isProxyProfileConfigured()) {
            return this.getProxyForTargetHost(target.getHostName());
        }
        if (this.proxy != null) {
            if (this.knownProxyHosts.contains(target.getHostName().toLowerCase(Locale.US))) {
                return this.proxy;
            }
            if (this.knownDirectHosts.contains(target.getHostName().toLowerCase(Locale.US))) {
                return null;
            }
            if (this.isBypass(target.getHostName().toLowerCase(Locale.US))) {
                return null;
            }
            return this.proxy;
        }
        return this.proxy;
    }

    public boolean isProxyProfileConfigured() {
        return !this.proxyProfileMap.isEmpty();
    }

    private HttpHost getProxyForTargetHost(String targetHost) {
        HttpHost proxy = null;
        ProxyProfileConfig proxyProfileForTargetHost = this.getProxyProfileForTargetHost(targetHost);
        if (proxyProfileForTargetHost != null) {
            proxy = proxyProfileForTargetHost.getProxy();
        }
        return proxy;
    }

    private ProxyProfileConfig getProxyProfileForTargetHost(String targetHost) {
        if (this.knownProxyConfigMap.containsKey(targetHost)) {
            return this.knownProxyConfigMap.get(targetHost);
        }
        if (this.knownDirectHosts.contains(targetHost)) {
            return null;
        }
        boolean defaultProfile = false;
        for (String key : this.proxyProfileMap.keySet()) {
            if ("*".equals(key)) {
                log.debug((Object)"Default proxy profile found");
                defaultProfile = true;
                continue;
            }
            if (!targetHost.matches(key)) continue;
            return this.getProxyProfileConfig(targetHost, key);
        }
        if (defaultProfile) {
            return this.getProxyProfileConfig(targetHost, "*");
        }
        return null;
    }

    private ProxyProfileConfig getProxyProfileConfig(String targetHost, String key) {
        ProxyProfileConfig proxyProfileConfig = this.proxyProfileMap.get(key);
        Set<String> proxyByPass = proxyProfileConfig.getProxyByPass();
        for (String bypass : proxyByPass) {
            if (!targetHost.matches(bypass)) continue;
            this.knownDirectHosts.add(targetHost);
            return null;
        }
        this.knownProxyConfigMap.put(targetHost, proxyProfileConfig);
        return proxyProfileConfig;
    }

    public UsernamePasswordCredentials getCredentialsForTargetHost(String targetHost) {
        UsernamePasswordCredentials credentials = null;
        ProxyProfileConfig proxyProfileForTargetHost = this.getProxyProfileForTargetHost(targetHost);
        if (proxyProfileForTargetHost != null) {
            credentials = proxyProfileForTargetHost.getCredentials();
        }
        return credentials;
    }

    public String logProxyConfig() {
        if (this.isProxyProfileConfigured()) {
            return "HTTP Sender using proxy profile";
        }
        if (this.proxy != null) {
            return "HTTP Sender using Proxy " + this.getProxy() + " and  bypassing " + this.getProxyBypass();
        }
        return "No proxy configuration found";
    }

    private boolean isProxyConfigured() {
        return this.proxy != null || this.isProxyProfileConfigured();
    }

    private boolean isProxyHasCredential() {
        if (!this.isProxyConfigured()) {
            return false;
        }
        if (!this.isProxyProfileConfigured()) {
            return this.getCreds() != null;
        }
        for (Map.Entry<String, ProxyProfileConfig> proxyProfile : this.proxyProfileMap.entrySet()) {
            if (proxyProfile.getValue().getCredentials() == null) continue;
            return true;
        }
        return false;
    }

    public ProxyAuthenticator createProxyAuthenticator() throws AxisFault {
        ProxyAuthenticator proxyAuthenticator;
        if (!this.isProxyHasCredential()) {
            return null;
        }
        try {
            proxyAuthenticator = this.isProxyProfileConfigured() ? new ProfileProxyAuthenticator(this) : new DefaultProxyAuthenticator((Credentials)this.getCreds());
        }
        catch (MalformedChallengeException e) {
            throw new AxisFault("Error while creating proxy authenticator", (Throwable)e);
        }
        return proxyAuthenticator;
    }

    public String toString() {
        return "[proxy=" + this.proxy + ", proxyCredential=" + this.creds + ", proxyBypass=" + this.proxyBypass + ", proxyProfileMap=" + this.proxyProfileMap + "]";
    }

    private boolean isBypass(String hostName) {
        for (String entry : this.proxyBypass) {
            if (!hostName.matches(entry)) continue;
            this.knownDirectHosts.add(hostName);
            return true;
        }
        this.knownProxyHosts.add(hostName);
        return false;
    }
}

