/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.http.conn.ProxyAuthenticator;
import org.apache.synapse.transport.http.conn.ProxyConfig;

public class ProfileProxyAuthenticator
implements ProxyAuthenticator {
    private ProxyConfig proxyConfig;
    private BasicScheme basicScheme;

    public ProfileProxyAuthenticator(ProxyConfig proxyConfig) throws MalformedChallengeException {
        this.proxyConfig = proxyConfig;
        this.basicScheme = new BasicScheme();
        this.basicScheme.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=\"proxy\""));
    }

    @Override
    public void authenticatePreemptively(HttpRequest request, HttpContext context) throws AuthenticationException {
        String targetHost = (String)context.getAttribute("PROXY_PROFILE_TARGET_HOST");
        UsernamePasswordCredentials proxyCredentials = this.proxyConfig.getCredentialsForTargetHost(targetHost);
        if (proxyCredentials != null) {
            Header authHeader = this.basicScheme.authenticate((Credentials)proxyCredentials, request, context);
            request.addHeader(authHeader);
        }
    }
}

