/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.http.conn.LoggingNHttpClientConnection;
import org.apache.synapse.transport.http.conn.LoggingNHttpClientHandler;
import org.apache.synapse.transport.http.conn.LoggingNHttpServerConnection;
import org.apache.synapse.transport.http.conn.LoggingNHttpServiceHandler;

public class LoggingUtils {
    public static final String HEADER_LOG_ID = "org.apache.synapse.transport.http.headers";
    public static final String WIRE_LOG_ID = "org.apache.synapse.transport.http.wire";
    public static final String ACCESS_LOG_ID = "org.apache.synapse.transport.http.access";
    private static final Pattern SKIP_LOGGING_PATTERN = System.getProperty("skip.logging.pattern") != null ? Pattern.compile(System.getProperty("skip.logging.pattern")) : null;

    public static NHttpClientEventHandler decorate(NHttpClientEventHandler handler) {
        Log log = LogFactory.getLog(handler.getClass());
        if (log.isDebugEnabled()) {
            handler = new LoggingNHttpClientHandler(log, handler);
        }
        return handler;
    }

    public static NHttpServerEventHandler decorate(NHttpServerEventHandler handler) {
        Log log = LogFactory.getLog(handler.getClass());
        if (log.isDebugEnabled()) {
            handler = new LoggingNHttpServiceHandler(log, handler);
        }
        return handler;
    }

    public static DefaultNHttpClientConnection createClientConnection(IOSession iosession, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new LoggingNHttpClientConnection(iosession, responseFactory, allocator, params);
    }

    public static Pattern getSkipLoggingMatcher() {
        return SKIP_LOGGING_PATTERN;
    }

    public static DefaultNHttpServerConnection createServerConnection(IOSession iosession, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new LoggingNHttpServerConnection(iosession, requestFactory, allocator, params);
    }
}

