/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;

class LoggingNHttpServiceHandler
implements NHttpServerEventHandler {
    private final Log log;
    private final NHttpServerEventHandler handler;

    public LoggingNHttpServiceHandler(Log log, NHttpServerEventHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP service handler may not be null");
        }
        this.handler = handler;
        this.log = LogFactory.getLog(handler.getClass());
    }

    public void connected(NHttpServerConnection conn) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Connected"));
        }
        this.handler.connected(conn);
    }

    public void closed(NHttpServerConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Closed"));
        }
        this.handler.closed(conn);
    }

    public void exception(NHttpServerConnection conn, Exception ex) {
        String msg = ex.getMessage();
        if (msg == null) {
            msg = "";
        }
        if (ex instanceof ConnectionClosedException || ex.getMessage().contains("Connection reset by peer") || ex.getMessage().contains("forcibly closed")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(conn + ": " + ex.getMessage() + " (Probably the keepalive connection was closed)"));
            }
        } else {
            this.log.error((Object)(conn + ": " + msg), (Throwable)ex);
        }
        this.handler.exception(conn, ex);
    }

    public void requestReceived(NHttpServerConnection conn) throws IOException, HttpException {
        HttpRequest request = conn.getHttpRequest();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": " + request.getRequestLine()));
        }
        this.handler.requestReceived(conn);
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Output ready"));
        }
        this.handler.outputReady(conn, encoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Content encoder " + encoder));
        }
    }

    public void responseReady(NHttpServerConnection conn) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Response ready"));
        }
        this.handler.responseReady(conn);
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Input ready"));
        }
        this.handler.inputReady(conn, decoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Content decoder " + decoder));
        }
    }

    public void timeout(NHttpServerConnection conn) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Timeout"));
        }
        this.handler.timeout(conn);
    }

    public void endOfInput(NHttpServerConnection conn) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": End of input"));
        }
        this.handler.endOfInput(conn);
    }
}

