/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.http.access.AccessHandler;
import org.apache.synapse.transport.http.conn.LoggingIOSession;
import org.apache.synapse.transport.http.conn.LoggingUtils;
import org.apache.synapse.transport.http.conn.SynapseDebugInfoHolder;
import org.apache.synapse.transport.http.conn.SynapseWireLogHolder;
import org.apache.synapse.transport.http.conn.UpgradableNHttpConnection;

public class LoggingNHttpServerConnection
extends DefaultNHttpServerConnection
implements UpgradableNHttpConnection {
    private static final AtomicLong COUNT = new AtomicLong();
    private final Log log = LogFactory.getLog(this.getClass());
    private final Log iolog;
    private final Log headerlog;
    private final Log accesslog;
    private final Log wirelog;
    private final String id;
    private IOSession original;

    public LoggingNHttpServerConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(session, requestFactory, allocator, params);
        this.iolog = LogFactory.getLog(session.getClass());
        this.headerlog = LogFactory.getLog((String)"org.apache.synapse.transport.http.headers");
        this.wirelog = LogFactory.getLog((String)"org.apache.synapse.transport.http.wire");
        this.accesslog = LogFactory.getLog((String)"org.apache.synapse.transport.http.access");
        this.id = "http-incoming-" + COUNT.incrementAndGet();
        this.original = session;
        if (this.iolog.isDebugEnabled() || this.wirelog.isDebugEnabled() || SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            super.bind((IOSession)new LoggingIOSession(session, this.id, this.iolog, this.wirelog));
        }
    }

    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Close connection"));
        }
        super.close();
    }

    public void shutdown() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Shutdown connection"));
        }
        super.shutdown();
    }

    public void submitResponse(HttpResponse response) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": " + response.getStatusLine().toString()));
        }
        super.submitResponse(response);
    }

    public void consumeInput(NHttpServerEventHandler handler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Consume input"));
        }
        if (!SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            super.consumeInput(handler);
        } else {
            this.consumeInputWire(handler);
        }
    }

    public void produceOutput(NHttpServerEventHandler handler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Produce output"));
        }
        if (!SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            super.produceOutput(handler);
            if (!this.outbuf.hasData() && this.contentEncoder == null && this.status != 2) {
                this.session.clearEvent(4);
            }
        } else {
            this.produceOutputWire(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeInputWire(NHttpServerEventHandler handler) {
        if (this.getContext() == null) {
            return;
        }
        SynapseWireLogHolder logHolder = null;
        logHolder = this.getContext().getAttribute("synapse.wire.log.holder") != null ? (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder") : new SynapseWireLogHolder();
        SynapseWireLogHolder synapseWireLogHolder = logHolder;
        synchronized (synapseWireLogHolder) {
            logHolder.setPhase(SynapseWireLogHolder.PHASE.SOURCE_REQUEST_READY);
            this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
            if (this.status != 0) {
                this.session.clearEvent(1);
                return;
            }
            try {
                if (this.request == null) {
                    int bytesRead;
                    do {
                        if ((bytesRead = this.requestParser.fillBuffer((ReadableByteChannel)this.session.channel())) > 0) {
                            this.inTransportMetrics.incrementBytesTransferred((long)bytesRead);
                        }
                        this.request = (HttpRequest)this.requestParser.parse();
                    } while (bytesRead > 0 && this.request == null);
                    if (this.request != null) {
                        if (this.request instanceof HttpEntityEnclosingRequest) {
                            HttpEntity entity = this.prepareDecoder((HttpMessage)this.request);
                            ((HttpEntityEnclosingRequest)this.request).setEntity(entity);
                        }
                        this.connMetrics.incrementRequestCount();
                        this.hasBufferedInput = this.inbuf.hasData();
                        this.onRequestReceived(this.request);
                        handler.requestReceived((NHttpServerConnection)this);
                        if (this.contentDecoder == null) {
                            this.resetInput();
                        }
                    }
                    if (bytesRead == -1 && !this.inbuf.hasData()) {
                        handler.endOfInput((NHttpServerConnection)this);
                    }
                }
                if (this.contentDecoder != null && (this.session.getEventMask() & 1) > 0) {
                    handler.inputReady((NHttpServerConnection)this, this.contentDecoder);
                    if (this.contentDecoder.isCompleted()) {
                        if (this.getContext().getAttribute("synapse.wire.log.holder") != null) {
                            logHolder = (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder");
                            logHolder.setPhase(SynapseWireLogHolder.PHASE.SOURCE_REQUEST_DONE);
                            this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
                        }
                        this.resetInput();
                    }
                }
            }
            catch (HttpException ex) {
                handler.exception((NHttpServerConnection)this, (Exception)((Object)ex));
            }
            catch (Exception ex) {
                handler.exception((NHttpServerConnection)this, ex);
            }
            finally {
                if (this.getContext().getAttribute("synapse.wire.log.holder") != null) {
                    logHolder = (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder");
                    logHolder.setPhase(SynapseWireLogHolder.PHASE.SOURCE_REQUEST_DONE);
                    this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
                }
                this.hasBufferedInput = this.inbuf.hasData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceOutputWire(NHttpServerEventHandler handler) {
        if (this.getContext() == null) {
            return;
        }
        SynapseWireLogHolder logHolder = null;
        logHolder = this.getContext().getAttribute("synapse.wire.log.holder") != null ? (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder") : new SynapseWireLogHolder();
        SynapseWireLogHolder synapseWireLogHolder = logHolder;
        synchronized (synapseWireLogHolder) {
            logHolder.setPhase(SynapseWireLogHolder.PHASE.SOURCE_RESPONSE_READY);
            this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
            try {
                int bytesWritten;
                if (this.status == 0) {
                    if (this.contentEncoder == null && !this.outbuf.hasData()) {
                        handler.responseReady((NHttpServerConnection)this);
                    }
                    if (this.contentEncoder != null) {
                        handler.outputReady((NHttpServerConnection)this, this.contentEncoder);
                        if (this.contentEncoder.isCompleted()) {
                            this.resetOutput();
                        }
                    }
                }
                if (this.outbuf.hasData() && (bytesWritten = this.outbuf.flush((WritableByteChannel)this.session.channel())) > 0) {
                    this.outTransportMetrics.incrementBytesTransferred((long)bytesWritten);
                }
                if (!this.outbuf.hasData()) {
                    if (this.status == 1) {
                        this.session.close();
                        this.status = 2;
                        this.resetOutput();
                    }
                    if (this.contentEncoder == null && this.status != 2) {
                        if (this.getContext().getAttribute("synapse.wire.log.holder") != null) {
                            logHolder = (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder");
                            logHolder.setPhase(SynapseWireLogHolder.PHASE.SOURCE_RESPONSE_DONE);
                            SynapseDebugInfoHolder.getInstance().setWireLogHolder(logHolder);
                            this.getContext().removeAttribute("synapse.wire.log.holder");
                        }
                        this.session.clearEvent(4);
                    }
                }
            }
            catch (Exception ex) {
                handler.exception((NHttpServerConnection)this, ex);
            }
            finally {
                if (this.getContext().getAttribute("synapse.wire.log.holder") != null) {
                    logHolder = (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder");
                    logHolder.setPhase(SynapseWireLogHolder.PHASE.SOURCE_RESPONSE_DONE);
                    this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
                }
                this.hasBufferedOutput = this.outbuf.hasData();
            }
        }
    }

    protected NHttpMessageWriter<HttpResponse> createResponseWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new LoggingNHttpMessageWriter((NHttpMessageWriter<HttpResponse>)super.createResponseWriter(buffer, params));
    }

    protected NHttpMessageParser<HttpRequest> createRequestParser(SessionInputBuffer buffer, HttpRequestFactory requestFactory, HttpParams params) {
        return new LoggingNHttpMessageParser((NHttpMessageParser<HttpRequest>)super.createRequestParser(buffer, requestFactory, params));
    }

    public String toString() {
        return this.id;
    }

    @Override
    public IOSession getIOSession() {
        return this.original;
    }

    @Override
    public void bind(IOSession session) {
        this.original = session;
        if (this.iolog.isDebugEnabled() || this.wirelog.isDebugEnabled() || SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            super.bind((IOSession)new LoggingIOSession(session, this.id, this.iolog, this.wirelog));
        } else {
            super.bind(session);
        }
    }

    class LoggingNHttpMessageParser
    implements NHttpMessageParser<HttpRequest> {
        private final NHttpMessageParser<HttpRequest> parser;

        public LoggingNHttpMessageParser(NHttpMessageParser<HttpRequest> parser) {
            this.parser = parser;
        }

        private void printLog(HttpRequest message) {
            Header[] headers;
            LoggingNHttpServerConnection.this.headerlog.debug((Object)(LoggingNHttpServerConnection.this.id + " >> " + message.getRequestLine().toString()));
            for (Header header : headers = message.getAllHeaders()) {
                LoggingNHttpServerConnection.this.headerlog.debug((Object)(LoggingNHttpServerConnection.this.id + " >> " + header.toString()));
            }
        }

        public void reset() {
            this.parser.reset();
        }

        public int fillBuffer(ReadableByteChannel channel) throws IOException {
            return this.parser.fillBuffer(channel);
        }

        public HttpRequest parse() throws IOException, HttpException {
            HttpRequest message = (HttpRequest)this.parser.parse();
            if (message != null && LoggingNHttpServerConnection.this.headerlog.isDebugEnabled()) {
                String skipLogging = System.getProperty("skip.logging");
                if ("true".equals(skipLogging)) {
                    String uri = message.getRequestLine().toString();
                    Pattern pattern = LoggingUtils.getSkipLoggingMatcher();
                    if (pattern != null && !pattern.matcher(uri).find()) {
                        this.printLog(message);
                    }
                } else {
                    this.printLog(message);
                }
            }
            if (message != null && LoggingNHttpServerConnection.this.accesslog.isInfoEnabled()) {
                HttpRequest request = message;
                HttpParams params = request.getParams();
                SocketAddress remoteAddress = LoggingNHttpServerConnection.this.session.getRemoteAddress();
                if (remoteAddress instanceof InetSocketAddress) {
                    InetSocketAddress remote = (InetSocketAddress)remoteAddress;
                    params.setParameter("http.remote.addr", (Object)remote.getAddress().getHostAddress());
                }
                AccessHandler.getAccess().addAccessToQueue(message);
            }
            return message;
        }
    }

    class LoggingNHttpMessageWriter
    implements NHttpMessageWriter<HttpResponse> {
        private final NHttpMessageWriter<HttpResponse> writer;

        public LoggingNHttpMessageWriter(NHttpMessageWriter<HttpResponse> writer) {
            this.writer = writer;
        }

        public void reset() {
            this.writer.reset();
        }

        private void printLog(HttpResponse message) {
            Header[] headers;
            LoggingNHttpServerConnection.this.headerlog.debug((Object)(LoggingNHttpServerConnection.this.id + " << " + message.getStatusLine().toString()));
            for (Header header : headers = message.getAllHeaders()) {
                LoggingNHttpServerConnection.this.headerlog.debug((Object)(LoggingNHttpServerConnection.this.id + " << " + header.toString()));
            }
        }

        public void write(HttpResponse message) throws IOException, HttpException {
            if (message != null && LoggingNHttpServerConnection.this.headerlog.isDebugEnabled()) {
                String skipLogging = System.getProperty("skip.logging");
                Object request = LoggingNHttpServerConnection.this.session.getAttribute("http.request");
                if ("true".equals(skipLogging) && request != null) {
                    String uri = ((HttpRequest)request).getRequestLine().toString();
                    Pattern pattern = LoggingUtils.getSkipLoggingMatcher();
                    if (pattern != null && !pattern.matcher(uri).find()) {
                        this.printLog(message);
                    }
                } else {
                    this.printLog(message);
                }
            }
            if (message != null && LoggingNHttpServerConnection.this.accesslog.isInfoEnabled()) {
                HttpResponse response = message;
                HttpParams params = response.getParams();
                SocketAddress remoteAddress = LoggingNHttpServerConnection.this.session.getRemoteAddress();
                if (remoteAddress instanceof InetSocketAddress) {
                    InetSocketAddress remote = (InetSocketAddress)remoteAddress;
                    params.setParameter("http.remote.addr", (Object)remote.getAddress().getHostAddress());
                }
                AccessHandler.getAccess().addAccessToQueue(message);
            }
            this.writer.write((HttpMessage)message);
        }
    }
}

