/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;

class LoggingNHttpClientHandler
implements NHttpClientEventHandler {
    private final Log log;
    private final NHttpClientEventHandler handler;

    public LoggingNHttpClientHandler(Log log, NHttpClientEventHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        this.handler = handler;
        this.log = LogFactory.getLog(handler.getClass());
    }

    public void connected(NHttpClientConnection conn, Object attachment) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Connected (" + attachment + ")"));
        }
        this.handler.connected(conn, attachment);
    }

    public void closed(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Closed"));
        }
        this.handler.closed(conn);
    }

    public void exception(NHttpClientConnection conn, Exception ex) {
        this.log.error((Object)(conn + ": " + ex.getMessage()), (Throwable)ex);
        this.handler.exception(conn, ex);
    }

    public void requestReady(NHttpClientConnection conn) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Request ready" + LoggingNHttpClientHandler.getRequestMessageID(conn)));
        }
        this.handler.requestReady(conn);
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Output ready" + LoggingNHttpClientHandler.getRequestMessageID(conn)));
        }
        this.handler.outputReady(conn, encoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Content encoder " + encoder));
        }
    }

    public void responseReceived(NHttpClientConnection conn) throws IOException, HttpException {
        HttpResponse response = conn.getHttpResponse();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": " + response.getStatusLine() + LoggingNHttpClientHandler.getRequestMessageID(conn)));
        }
        this.handler.responseReceived(conn);
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Input ready" + LoggingNHttpClientHandler.getRequestMessageID(conn)));
        }
        this.handler.inputReady(conn, decoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Content decoder " + decoder));
        }
    }

    public void timeout(NHttpClientConnection conn) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Timeout" + LoggingNHttpClientHandler.getRequestMessageID(conn)));
        }
        this.handler.timeout(conn);
    }

    public void endOfInput(NHttpClientConnection conn) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": End of input" + LoggingNHttpClientHandler.getRequestMessageID(conn)));
        }
        this.handler.endOfInput(conn);
    }

    private static String getRequestMessageID(NHttpClientConnection conn) {
        Axis2HttpRequest axis2Request = (Axis2HttpRequest)conn.getContext().getAttribute("synapse.axis2-http-request");
        if (axis2Request != null) {
            return " [Request Message ID : " + axis2Request.getMsgContext().getMessageID() + "]";
        }
        return "";
    }
}

