/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.http.access.AccessHandler;
import org.apache.synapse.transport.http.conn.LoggingIOSession;
import org.apache.synapse.transport.http.conn.LoggingUtils;
import org.apache.synapse.transport.http.conn.SynapseDebugInfoHolder;
import org.apache.synapse.transport.http.conn.SynapseWireLogHolder;
import org.apache.synapse.transport.http.conn.UpgradableNHttpConnection;
import org.apache.synapse.transport.passthru.TargetHandler;

public class LoggingNHttpClientConnection
extends DefaultNHttpClientConnection
implements UpgradableNHttpConnection {
    private static final AtomicLong COUNT = new AtomicLong();
    private final Log log = LogFactory.getLog(this.getClass());
    private final Log iolog;
    private final Log headerlog;
    private final Log wirelog;
    private final Log accesslog;
    private final String id;
    private IOSession original;
    private boolean releaseConn = false;

    public LoggingNHttpClientConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(session, responseFactory, allocator, params);
        this.iolog = LogFactory.getLog(session.getClass());
        this.headerlog = LogFactory.getLog((String)"org.apache.synapse.transport.http.headers");
        this.wirelog = LogFactory.getLog((String)"org.apache.synapse.transport.http.wire");
        this.accesslog = LogFactory.getLog((String)"org.apache.synapse.transport.http.access");
        this.id = "http-outgoing-" + COUNT.incrementAndGet();
        this.original = session;
        if (this.iolog.isDebugEnabled() || this.wirelog.isDebugEnabled() || SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            super.bind((IOSession)new LoggingIOSession(session, this.id, this.iolog, this.wirelog));
        }
    }

    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Close connection"));
        }
        super.close();
    }

    public void shutdown() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Shutdown connection"));
        }
        super.shutdown();
    }

    public void submitRequest(HttpRequest request) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": " + request.getRequestLine().toString()));
        }
        super.submitRequest(request);
    }

    public void consumeInput(NHttpClientEventHandler handler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Consume input"));
        }
        if (!SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            super.consumeInput(handler);
        } else {
            this.consumeInputWire(handler);
        }
        if (this.isReleaseConn() && handler instanceof TargetHandler) {
            ((TargetHandler)handler).getTargetConfiguration().getConnections().releaseConnection((NHttpClientConnection)this);
            this.setReleaseConn(false);
        }
    }

    public void produceOutput(NHttpClientEventHandler handler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Produce output"));
        }
        if (!SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            super.produceOutput(handler);
            if (!this.outbuf.hasData() && this.contentEncoder == null && this.status != 2) {
                this.session.clearEvent(4);
            }
        } else {
            this.produceOutputWire(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeInputWire(NHttpClientEventHandler handler) {
        if (this.getContext() == null) {
            return;
        }
        SynapseWireLogHolder logHolder = null;
        logHolder = this.getContext().getAttribute("synapse.wire.log.holder") != null ? (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder") : new SynapseWireLogHolder();
        SynapseWireLogHolder synapseWireLogHolder = logHolder;
        synchronized (synapseWireLogHolder) {
            logHolder.setPhase(SynapseWireLogHolder.PHASE.TARGET_RESPONSE_READY);
            this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
            if (this.status != 0) {
                this.session.clearEvent(1);
                return;
            }
            try {
                if (this.response == null) {
                    int bytesRead;
                    do {
                        if ((bytesRead = this.responseParser.fillBuffer((ReadableByteChannel)this.session.channel())) > 0) {
                            this.inTransportMetrics.incrementBytesTransferred((long)bytesRead);
                        }
                        this.response = (HttpResponse)this.responseParser.parse();
                    } while (bytesRead > 0 && this.response == null);
                    if (this.response != null) {
                        if (this.response.getStatusLine().getStatusCode() >= 200) {
                            HttpEntity entity = this.prepareDecoder((HttpMessage)this.response);
                            this.response.setEntity(entity);
                            this.connMetrics.incrementResponseCount();
                        }
                        this.hasBufferedInput = this.inbuf.hasData();
                        this.onResponseReceived(this.response);
                        handler.responseReceived((NHttpClientConnection)this);
                        if (this.contentDecoder == null) {
                            this.resetInput();
                        }
                    }
                    if (bytesRead == -1 && !this.inbuf.hasData()) {
                        handler.endOfInput((NHttpClientConnection)this);
                    }
                }
                if (this.contentDecoder != null && (this.session.getEventMask() & 1) > 0) {
                    handler.inputReady((NHttpClientConnection)this, this.contentDecoder);
                    if (this.contentDecoder.isCompleted()) {
                        if (this.getContext().getAttribute("synapse.wire.log.holder") != null) {
                            logHolder = (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder");
                            logHolder.setPhase(SynapseWireLogHolder.PHASE.TARGET_RESPONSE_DONE);
                            this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
                        }
                        this.resetInput();
                    }
                }
            }
            catch (HttpException ex) {
                this.resetInput();
                handler.exception((NHttpClientConnection)this, (Exception)((Object)ex));
            }
            catch (Exception ex) {
                handler.exception((NHttpClientConnection)this, ex);
            }
            finally {
                if (this.getContext().getAttribute("synapse.wire.log.holder") != null) {
                    logHolder = (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder");
                    logHolder.setPhase(SynapseWireLogHolder.PHASE.TARGET_RESPONSE_DONE);
                    this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
                }
                this.hasBufferedInput = this.inbuf.hasData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceOutputWire(NHttpClientEventHandler handler) {
        if (this.getContext() == null) {
            return;
        }
        SynapseWireLogHolder logHolder = null;
        logHolder = this.getContext().getAttribute("synapse.wire.log.holder") != null ? (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder") : new SynapseWireLogHolder();
        SynapseWireLogHolder synapseWireLogHolder = logHolder;
        synchronized (synapseWireLogHolder) {
            logHolder.setPhase(SynapseWireLogHolder.PHASE.TARGET_REQUEST_READY);
            this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
            try {
                int bytesWritten;
                if (this.status == 0) {
                    if (this.contentEncoder == null) {
                        handler.requestReady((NHttpClientConnection)this);
                    }
                    if (this.contentEncoder != null) {
                        handler.outputReady((NHttpClientConnection)this, this.contentEncoder);
                        if (this.contentEncoder.isCompleted()) {
                            this.resetOutput();
                        }
                    }
                }
                if (this.outbuf.hasData() && (bytesWritten = this.outbuf.flush((WritableByteChannel)this.session.channel())) > 0) {
                    this.outTransportMetrics.incrementBytesTransferred((long)bytesWritten);
                }
                if (!this.outbuf.hasData()) {
                    if (this.status == 1) {
                        this.session.close();
                        this.status = 2;
                        this.resetOutput();
                    }
                    if (this.contentEncoder == null && this.status != 2) {
                        if (this.getContext().getAttribute("synapse.wire.log.holder") != null) {
                            logHolder = (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder");
                            logHolder.setPhase(SynapseWireLogHolder.PHASE.TARGET_REQUEST_DONE);
                            this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
                        }
                        this.session.clearEvent(4);
                    }
                }
            }
            catch (Exception ex) {
                handler.exception((NHttpClientConnection)this, ex);
            }
            finally {
                if (this.getContext().getAttribute("synapse.wire.log.holder") != null) {
                    logHolder = (SynapseWireLogHolder)this.getContext().getAttribute("synapse.wire.log.holder");
                    logHolder.setPhase(SynapseWireLogHolder.PHASE.TARGET_REQUEST_DONE);
                    this.getContext().setAttribute("synapse.wire.log.holder", (Object)logHolder);
                }
                this.hasBufferedOutput = this.outbuf.hasData();
            }
        }
    }

    protected NHttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new LoggingNHttpMessageWriter((NHttpMessageWriter<HttpRequest>)super.createRequestWriter(buffer, params));
    }

    protected NHttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new LoggingNHttpMessageParser((NHttpMessageParser<HttpResponse>)super.createResponseParser(buffer, responseFactory, params));
    }

    @Override
    public IOSession getIOSession() {
        return this.original;
    }

    @Override
    public void bind(IOSession session) {
        this.original = session;
        if (this.iolog.isDebugEnabled() || this.wirelog.isDebugEnabled() || SynapseDebugInfoHolder.getInstance().isDebuggerEnabled()) {
            super.bind((IOSession)new LoggingIOSession(session, this.id, this.iolog, this.wirelog));
        } else {
            super.bind(session);
        }
    }

    public String toString() {
        return this.id;
    }

    public boolean isReleaseConn() {
        return this.releaseConn;
    }

    public void setReleaseConn(boolean releaseConn) {
        this.releaseConn = releaseConn;
    }

    class LoggingNHttpMessageParser
    implements NHttpMessageParser<HttpResponse> {
        private final NHttpMessageParser<HttpResponse> parser;

        public LoggingNHttpMessageParser(NHttpMessageParser<HttpResponse> parser) {
            this.parser = parser;
        }

        private void printLog(HttpResponse message) {
            Header[] headers;
            LoggingNHttpClientConnection.this.headerlog.debug((Object)(LoggingNHttpClientConnection.this.id + " << " + message.getStatusLine().toString()));
            for (Header header : headers = message.getAllHeaders()) {
                LoggingNHttpClientConnection.this.headerlog.debug((Object)(LoggingNHttpClientConnection.this.id + " << " + header.toString()));
            }
        }

        public void reset() {
            this.parser.reset();
        }

        public int fillBuffer(ReadableByteChannel channel) throws IOException {
            return this.parser.fillBuffer(channel);
        }

        public HttpResponse parse() throws IOException, HttpException {
            HttpResponse message = (HttpResponse)this.parser.parse();
            if (message != null && LoggingNHttpClientConnection.this.headerlog.isDebugEnabled()) {
                String skipLogging = System.getProperty("skip.logging");
                Object request = LoggingNHttpClientConnection.this.session.getAttribute("http.request");
                if ("true".equals(skipLogging) && request != null) {
                    String uri = ((HttpRequest)request).getRequestLine().toString();
                    Pattern pattern = LoggingUtils.getSkipLoggingMatcher();
                    if (pattern != null && !pattern.matcher(uri).find()) {
                        this.printLog(message);
                    }
                } else {
                    this.printLog(message);
                }
            }
            if (message != null && LoggingNHttpClientConnection.this.accesslog.isInfoEnabled()) {
                HttpResponse response = message;
                HttpParams params = response.getParams();
                SocketAddress remoteAddress = LoggingNHttpClientConnection.this.session.getRemoteAddress();
                if (remoteAddress instanceof InetSocketAddress) {
                    InetSocketAddress remote = (InetSocketAddress)remoteAddress;
                    params.setParameter("http.remote.addr", (Object)remote.getAddress().getHostAddress());
                }
                AccessHandler.getAccess().addAccessToQueue(message);
            }
            return message;
        }
    }

    class LoggingNHttpMessageWriter
    implements NHttpMessageWriter<HttpRequest> {
        private final NHttpMessageWriter<HttpRequest> writer;

        public LoggingNHttpMessageWriter(NHttpMessageWriter<HttpRequest> writer) {
            this.writer = writer;
        }

        public void reset() {
            this.writer.reset();
        }

        private void printLog(HttpRequest message) {
            Header[] headers;
            LoggingNHttpClientConnection.this.headerlog.debug((Object)(LoggingNHttpClientConnection.this.id + " >> " + message.getRequestLine().toString()));
            for (Header header : headers = message.getAllHeaders()) {
                LoggingNHttpClientConnection.this.headerlog.debug((Object)(LoggingNHttpClientConnection.this.id + " >> " + header.toString()));
            }
        }

        public void write(HttpRequest message) throws IOException, HttpException {
            if (message != null && LoggingNHttpClientConnection.this.headerlog.isDebugEnabled()) {
                String skipLogging = System.getProperty("skip.logging");
                Object request = LoggingNHttpClientConnection.this.session.getAttribute("http.request");
                if ("true".equals(skipLogging) && request != null) {
                    String uri = ((HttpRequest)request).getRequestLine().toString();
                    Pattern pattern = LoggingUtils.getSkipLoggingMatcher();
                    if (pattern != null && !pattern.matcher(uri).find()) {
                        this.printLog(message);
                    }
                } else {
                    this.printLog(message);
                }
            }
            if (message != null && LoggingNHttpClientConnection.this.accesslog.isInfoEnabled()) {
                HttpRequest request = message;
                HttpParams params = request.getParams();
                SocketAddress remoteAddress = LoggingNHttpClientConnection.this.session.getRemoteAddress();
                if (remoteAddress instanceof InetSocketAddress) {
                    InetSocketAddress remote = (InetSocketAddress)remoteAddress;
                    params.setParameter("http.remote.addr", (Object)remote.getAddress().getHostAddress());
                }
                AccessHandler.getAccess().addAccessToQueue(message);
            }
            this.writer.write((HttpMessage)message);
        }
    }
}

