/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;
import org.apache.synapse.transport.http.conn.LoggingUtils;
import org.apache.synapse.transport.http.conn.SynapseDebugInfoHolder;
import org.apache.synapse.transport.http.conn.Wire;

class LoggingIOSession
implements IOSession {
    private static AtomicLong COUNT = new AtomicLong(0L);
    private final Log log;
    private final Wire wirelog;
    private final IOSession session;
    private final ByteChannel channel;
    private final String id;

    public LoggingIOSession(IOSession session, String id, Log log, Log wirelog) {
        if (session == null) {
            throw new IllegalArgumentException("I/O session may not be null");
        }
        this.session = session;
        this.channel = new LoggingByteChannel();
        this.id = id + "-" + COUNT.incrementAndGet();
        this.log = LogFactory.getLog(session.getClass());
        this.wirelog = new Wire(wirelog);
    }

    public int getStatus() {
        return this.session.getStatus();
    }

    public ByteChannel channel() {
        return this.channel;
    }

    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public int getEventMask() {
        return this.session.getEventMask();
    }

    private static String formatOps(int ops) {
        StringBuffer buffer = new StringBuffer(6);
        buffer.append('[');
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
        if ((ops & 0x10) > 0) {
            buffer.append('a');
        }
        if ((ops & 8) > 0) {
            buffer.append('c');
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void setEventMask(int ops) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("I/O session " + this.id + " " + this.session + ": Set event mask " + LoggingIOSession.formatOps(ops)));
        }
        this.session.setEventMask(ops);
    }

    public void setEvent(int op) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("I/O session " + this.id + " " + this.session + ": Set event " + LoggingIOSession.formatOps(op)));
        }
        this.session.setEvent(op);
    }

    public void clearEvent(int op) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("I/O session " + this.id + " " + this.session + ": Clear event " + LoggingIOSession.formatOps(op)));
        }
        this.session.clearEvent(op);
    }

    public void close() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("I/O session " + this.id + " " + this.session + ": Close"));
        }
        this.session.close();
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public void shutdown() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("I/O session " + this.id + " " + this.session + ": Shutdown"));
        }
        this.session.shutdown();
    }

    public int getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    public void setSocketTimeout(int timeout) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("I/O session " + this.id + " " + this.session + ": Set timeout " + timeout));
        }
        this.session.setSocketTimeout(timeout);
    }

    public void setBufferStatus(SessionBufferStatus status) {
        this.session.setBufferStatus(status);
    }

    public boolean hasBufferedInput() {
        return this.session.hasBufferedInput();
    }

    public boolean hasBufferedOutput() {
        return this.session.hasBufferedOutput();
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public void setAttribute(String name, Object obj) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("I/O session " + this.id + " " + this.session + ": Set attribute " + name));
        }
        this.session.setAttribute(name, obj);
    }

    public Object removeAttribute(String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("I/O session " + this.id + " " + this.session + ": Remove attribute " + name));
        }
        return this.session.removeAttribute(name);
    }

    class LoggingByteChannel
    implements ByteChannel {
        LoggingByteChannel() {
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int bytesRead = LoggingIOSession.this.session.channel().read(dst);
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug((Object)("I/O session " + LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": " + bytesRead + " bytes read"));
            }
            if (bytesRead > 0 && (LoggingIOSession.this.wirelog.isEnabled() || SynapseDebugInfoHolder.getInstance().isDebuggerEnabled())) {
                Object request;
                String skipLogging = System.getProperty("skip.logging");
                if ("true".equals(skipLogging) && (request = LoggingIOSession.this.session.getAttribute("http.request")) != null) {
                    String uri = ((HttpRequest)request).getRequestLine().toString();
                    Pattern pattern = LoggingUtils.getSkipLoggingMatcher();
                    if (pattern != null && pattern.matcher(uri).find()) {
                        return bytesRead;
                    }
                }
                ByteBuffer b = dst.duplicate();
                int p = b.position();
                b.limit(p);
                b.position(p - bytesRead);
                LoggingIOSession.this.wirelog.setSession(LoggingIOSession.this.session);
                LoggingIOSession.this.wirelog.input(b);
            }
            return bytesRead;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int byteWritten = LoggingIOSession.this.session.channel().write(src);
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug((Object)("I/O session " + LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": " + byteWritten + " bytes written"));
            }
            if (byteWritten > 0 && (LoggingIOSession.this.wirelog.isEnabled() || SynapseDebugInfoHolder.getInstance().isDebuggerEnabled())) {
                Object request;
                String skipLogging = System.getProperty("skip.logging");
                if ("true".equals(skipLogging) && (request = LoggingIOSession.this.session.getAttribute("http.request")) != null) {
                    String uri = ((HttpRequest)request).getRequestLine().toString();
                    Pattern pattern = LoggingUtils.getSkipLoggingMatcher();
                    if (pattern != null && pattern.matcher(uri).find()) {
                        return byteWritten;
                    }
                }
                ByteBuffer b = src.duplicate();
                int p = b.position();
                b.limit(p);
                b.position(p - byteWritten);
                LoggingIOSession.this.wirelog.setSession(LoggingIOSession.this.session);
                LoggingIOSession.this.wirelog.output(b);
            }
            return byteWritten;
        }

        @Override
        public void close() throws IOException {
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug((Object)("I/O session " + LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": Channel close"));
            }
            LoggingIOSession.this.session.channel().close();
        }

        @Override
        public boolean isOpen() {
            return LoggingIOSession.this.session.channel().isOpen();
        }
    }
}

