/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.http.conn.ProxyAuthenticator;

public class DefaultProxyAuthenticator
implements ProxyAuthenticator {
    private Credentials proxyCredentials;
    private BasicScheme basicScheme;

    public DefaultProxyAuthenticator(Credentials credentials) throws MalformedChallengeException {
        this.proxyCredentials = credentials;
        this.basicScheme = new BasicScheme();
        this.basicScheme.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=\"proxy\""));
    }

    @Override
    public void authenticatePreemptively(HttpRequest request, HttpContext context) throws AuthenticationException {
        Header authHeader = this.basicScheme.authenticate(this.proxyCredentials, request, context);
        request.addHeader(authHeader);
    }
}

