/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.http.conn.ssl.AbstractVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.synapse.transport.certificatevalidation.CertificateVerificationException;
import org.apache.synapse.transport.certificatevalidation.RevocationVerificationManager;

public class ClientSSLSetupHandler
implements SSLSetupHandler {
    private static final String[] LOCALHOSTS = new String[]{"::1", "127.0.0.1", "localhost", "localhost.localdomain"};
    private String[] httpsProtocols;
    private String[] preferredCiphers;
    public static final X509HostnameVerifier DEFAULT;
    public static final X509HostnameVerifier DEFAULT_AND_LOCALHOST;
    public static final X509HostnameVerifier STRICT;
    public static final X509HostnameVerifier ALLOW_ALL;
    private final X509HostnameVerifier hostnameVerifier;
    private final RevocationVerificationManager verificationManager;

    static boolean isLocalhost(String host) {
        int x;
        String string = host = host != null ? host.trim().toLowerCase() : "";
        if (host.startsWith("::1") && (x = host.lastIndexOf(37)) >= 0) {
            host = host.substring(0, x);
        }
        return (x = Arrays.binarySearch(LOCALHOSTS, host)) >= 0;
    }

    public ClientSSLSetupHandler(X509HostnameVerifier hostnameVerifier, RevocationVerificationManager verificationManager) {
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : DEFAULT;
        this.verificationManager = verificationManager;
    }

    public void initalize(SSLEngine sslengine) {
        if (null != this.httpsProtocols) {
            sslengine.setEnabledProtocols(this.httpsProtocols);
        }
        if (this.preferredCiphers != null) {
            sslengine.setEnabledCipherSuites(this.preferredCiphers);
        }
    }

    public void verify(IOSession iosession, SSLSession sslsession) throws SSLException {
        String address;
        SocketAddress remoteAddress = iosession.getRemoteAddress();
        String endpoint = (String)iosession.getAttribute("endPointURI");
        if (endpoint != null && !endpoint.isEmpty()) {
            try {
                URI endpointURI = new URI(endpoint);
                address = endpointURI.getHost();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid endpointURI: " + endpoint, e);
            }
        } else {
            address = remoteAddress instanceof InetSocketAddress ? ((InetSocketAddress)remoteAddress).getHostName() : remoteAddress.toString();
        }
        if (!this.hostnameVerifier.verify(address, sslsession)) {
            throw new SSLException("Host name verification failed for host : " + address);
        }
        if (this.verificationManager != null) {
            try {
                this.verificationManager.verifyRevocationStatus(sslsession.getPeerCertificateChain());
            }
            catch (CertificateVerificationException e) {
                throw new SSLException("Certificate Chain Validation failed for host : " + address, e);
            }
        }
    }

    public void setHttpsProtocols(String[] httpsProtocols) {
        this.httpsProtocols = httpsProtocols;
    }

    public void setPreferredCiphers(String[] enabledCiphers) {
        this.preferredCiphers = enabledCiphers;
    }

    static {
        Arrays.sort(LOCALHOSTS);
        DEFAULT = new AbstractVerifier(){

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                this.verify(host, cns, subjectAlts, false);
            }
        };
        DEFAULT_AND_LOCALHOST = new AbstractVerifier(){

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                if (ClientSSLSetupHandler.isLocalhost(host)) {
                    return;
                }
                this.verify(host, cns, subjectAlts, false);
            }
        };
        STRICT = new AbstractVerifier(){

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                this.verify(host, cns, subjectAlts, true);
            }
        };
        ALLOW_ALL = new AbstractVerifier(){

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }
        };
    }
}

