/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.conn;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponseFactory;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.http.conn.LoggingUtils;
import org.apache.synapse.transport.http.conn.SSLContextDetails;
import org.apache.synapse.transport.http.conn.UpgradableNHttpConnection;

public class ClientConnFactory {
    private final HttpResponseFactory responseFactory;
    private final ByteBufferAllocator allocator;
    private final SSLContextDetails ssl;
    private final ConcurrentMap<String, SSLContext> sslByHostMap;
    private final HttpParams params;
    private static final String ALL_HOSTS = "*";

    public ClientConnFactory(HttpResponseFactory responseFactory, ByteBufferAllocator allocator, SSLContextDetails ssl, Map<String, SSLContext> sslByHostMap, HttpParams params) {
        this.responseFactory = responseFactory != null ? responseFactory : new DefaultHttpResponseFactory();
        this.allocator = allocator != null ? allocator : new HeapByteBufferAllocator();
        this.ssl = ssl;
        this.sslByHostMap = sslByHostMap != null ? new ConcurrentHashMap<String, SSLContext>(sslByHostMap) : null;
        this.params = params != null ? params : new BasicHttpParams();
    }

    public ClientConnFactory(SSLContextDetails ssl, Map<String, SSLContext> sslByHostMap, HttpParams params) {
        this(null, null, ssl, sslByHostMap, params);
    }

    public ClientConnFactory(HttpParams params) {
        this(null, null, null, null, params);
    }

    private SSLContext getSSLContext(IOSession iosession) {
        String host;
        InetSocketAddress address = (InetSocketAddress)iosession.getRemoteAddress();
        SSLContext customContext = null;
        if (this.sslByHostMap != null && (customContext = (SSLContext)this.sslByHostMap.get(host = address.getHostName() + ":" + address.getPort())) == null) {
            customContext = (SSLContext)this.sslByHostMap.get(ALL_HOSTS);
        }
        if (customContext != null) {
            return customContext;
        }
        return this.ssl != null ? this.ssl.getContext() : null;
    }

    private SSLContext getSSLContext(HttpHost httpHost) {
        String host = httpHost.getHostName() + ":" + httpHost.getPort();
        return this.getSSLContextForHost(host);
    }

    private SSLContext getSSLContextForHost(String host) {
        SSLContext customContext = null;
        if (this.sslByHostMap != null) {
            customContext = (SSLContext)this.sslByHostMap.get(host);
        }
        if (customContext != null) {
            return customContext;
        }
        return this.ssl != null ? this.ssl.getContext() : null;
    }

    public DefaultNHttpClientConnection createConnection(IOSession iosession, HttpRoute route) {
        IOSession customSession;
        if (this.ssl != null && route.isSecure() && !route.isTunnelled()) {
            SSLContext customContext = this.getSSLContext(iosession);
            SSLIOSession ssliosession = this.createClientModeSSLsession(iosession, customContext);
            iosession.setAttribute("http.session.ssl", (Object)ssliosession);
            customSession = ssliosession;
        } else {
            customSession = iosession;
        }
        DefaultNHttpClientConnection conn = LoggingUtils.createClientConnection(customSession, this.responseFactory, this.allocator, this.params);
        int timeout = HttpConnectionParams.getSoTimeout((HttpParams)this.params);
        conn.setSocketTimeout(timeout);
        return conn;
    }

    public void upgrade(UpgradableNHttpConnection conn) {
        IOSession iosession;
        if (this.ssl != null && !((iosession = conn.getIOSession()) instanceof SSLIOSession)) {
            SSLContext customContext = this.getSSLContext(iosession);
            SSLIOSession ssliosession = this.createClientModeSSLsession(iosession, customContext);
            iosession.setAttribute("http.session.ssl", (Object)ssliosession);
            conn.bind((IOSession)ssliosession);
        }
    }

    public void upgrade(UpgradableNHttpConnection conn, HttpRoute route) {
        IOSession iosession;
        HttpHost targetHost = route.getTargetHost();
        if (this.ssl != null && !((iosession = conn.getIOSession()) instanceof SSLIOSession)) {
            SSLContext customContext = this.getSSLContext(targetHost);
            SSLIOSession ssliosession = this.createClientModeSSLsession(iosession, customContext);
            iosession.setAttribute("http.session.ssl", (Object)ssliosession);
            conn.bind((IOSession)ssliosession);
        }
    }

    public Set<String> getHostList() {
        return this.sslByHostMap.keySet();
    }

    private SSLIOSession createClientModeSSLsession(IOSession iosession, SSLContext customContext) {
        SSLIOSession ssliosession;
        SocketAddress address = iosession.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            int port;
            String hostname;
            String endpoint = (String)iosession.getAttribute("endPointURI");
            if (endpoint != null && !endpoint.isEmpty()) {
                URI endpointURI;
                try {
                    endpointURI = new URI(endpoint);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid endpointURI");
                }
                hostname = endpointURI.getHost();
                port = endpointURI.getPort();
            } else {
                hostname = ((InetSocketAddress)address).getHostName();
                port = ((InetSocketAddress)address).getPort();
            }
            ssliosession = new SSLIOSession(iosession, SSLMode.CLIENT, new HttpHost(hostname, port), customContext, this.ssl.getHandler());
        } else {
            ssliosession = new SSLIOSession(iosession, SSLMode.CLIENT, customContext, this.ssl.getHandler());
        }
        return ssliosession;
    }
}

