/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.access;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.apache.synapse.transport.http.access.AccessConstants;

public class AccessLogger {
    private static final String ACCESS_LOG_PROPERTIES = "access-log.properties";
    public static final String NHTTP_LOG_DIRECTORY = "nhttp.log.directory";
    public static final String ACCESS_LOG_ID = "org.apache.synapse.transport.nhttp.access";
    private static final String DATE_EXTRACT_REGEX = "\\[([^]]+)\\]";
    private static final String DATE_FORMAT_STRING = "dd/MMM/yyyy:HH:mm:ss.SSS Z";
    private static final String IS_LOG_ROTATABLE = "nhttp.is.log.rotatable";
    private static Log log = LogFactory.getLog((String)"org.apache.synapse.transport.nhttp.access");
    protected SimpleDateFormat fileDateFormatter = new SimpleDateFormat(AccessConstants.getFileDateFormat());
    protected PrintWriter writer;
    private volatile String dateStamp = "";
    private volatile long rotationLastChecked = 0L;
    private boolean buffered = true;
    private boolean checkExists = false;
    protected File currentLogFile = null;
    private boolean isRotatable = this.getBooleanValue("nhttp.is.log.rotatable", true);

    public AccessLogger(Log log) {
        this.initOpen();
        AccessLogger.log = log;
        this.buffered = true;
        this.checkExists = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message) {
        long systime;
        if (this.isRotatable && (systime = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            AccessLogger accessLogger = this;
            synchronized (accessLogger) {
                if (systime - this.rotationLastChecked > 1000L) {
                    this.rotationLastChecked = systime;
                    String tsDate = this.fileDateFormatter.format(new Date(systime));
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close();
                        this.dateStamp = tsDate;
                        this.open();
                    }
                }
            }
        }
        if (this.checkExists) {
            AccessLogger accessLogger = this;
            synchronized (accessLogger) {
                if (this.currentLogFile != null && !this.currentLogFile.exists()) {
                    try {
                        this.close();
                    }
                    catch (Throwable e) {
                        AccessLogger.handleThrowable(e);
                        log.info((Object)"Access Log file Close failed");
                    }
                    this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
                    this.open();
                }
            }
        }
        AccessLogger accessLogger = this;
        synchronized (accessLogger) {
            if (this.writer != null) {
                this.writer.println(message);
                if (!this.buffered) {
                    this.writer.flush();
                }
            }
        }
    }

    private boolean getBooleanValue(String name, boolean def) {
        Properties props = MiscellaneousUtil.loadProperties((String)ACCESS_LOG_PROPERTIES);
        String val = System.getProperty(name);
        if (val == null) {
            val = props.getProperty(name);
        }
        if (Boolean.parseBoolean(val)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using tuning parameter : " + name));
            }
            return true;
        }
        if (val != null && !Boolean.parseBoolean(val)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using tuning parameter : " + name));
            }
            return false;
        }
        return def;
    }

    protected synchronized void initOpen() {
        this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
        this.open();
    }

    protected synchronized void open() {
        Properties synapseProps = MiscellaneousUtil.loadProperties((String)ACCESS_LOG_PROPERTIES);
        String nhttpLogDir = synapseProps.getProperty(NHTTP_LOG_DIRECTORY);
        File dir = nhttpLogDir != null ? new File(nhttpLogDir) : new File(AccessConstants.getDirectory());
        if (!dir.exists() && !dir.mkdirs()) {
            log.error((Object)"Access Log Open Directory Failed");
        }
        try {
            Date today = new Date(System.currentTimeMillis());
            String pathname = dir.getAbsolutePath() + File.separator + AccessConstants.getPrefix() + AccessConstants.getSuffix();
            if (this.isRotatable) {
                File existing = new File(pathname);
                if (existing.exists()) {
                    try {
                        BufferedReader input = new BufferedReader(new FileReader(existing));
                        Pattern pattern = Pattern.compile(DATE_EXTRACT_REGEX);
                        String line = input.readLine();
                        if (StringUtils.isNotEmpty((String)line)) {
                            Matcher matcher = pattern.matcher(line);
                            if (matcher.find()) {
                                String date = matcher.group(1);
                                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING, Locale.ENGLISH);
                                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                                Date lastDateFromLog = dateFormat.parse(date);
                                if (!DateUtils.isSameDay((Date)today, (Date)lastDateFromLog)) {
                                    String oldDateStamp = this.fileDateFormatter.format(lastDateFromLog);
                                    String oldPathname = dir.getAbsolutePath() + File.separator + AccessConstants.getPrefix() + oldDateStamp + AccessConstants.getSuffix();
                                    File oldFile = new File(oldPathname);
                                    existing.renameTo(oldFile);
                                    existing.delete();
                                }
                            } else {
                                this.createFileInError(dir, existing);
                            }
                        }
                    }
                    catch (ParseException e) {
                        log.error((Object)"Error occurred when parsing the date from existing log file", (Throwable)e);
                        this.createFileInError(dir, existing);
                    }
                }
                pathname = dir.getAbsolutePath() + File.separator + AccessConstants.getPrefix() + this.dateStamp + AccessConstants.getSuffix();
            }
            this.writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(pathname, true), 128000), true);
            this.currentLogFile = new File(pathname);
        }
        catch (IOException e) {
            log.warn((Object)"Unable to open the print writer", (Throwable)e);
            this.writer = null;
            this.currentLogFile = null;
        }
    }

    private void createFileInError(File dir, File existing) {
        Date today = new Date(System.currentTimeMillis());
        Calendar calender = Calendar.getInstance();
        calender.setTime(today);
        calender.add(5, -1);
        Date dayBefore = calender.getTime();
        String pathName = dir.getAbsolutePath() + File.separator + AccessConstants.getPrefix() + this.fileDateFormatter.format(dayBefore) + AccessConstants.getSuffix();
        File oldFile = new File(pathName);
        if (oldFile.exists()) {
            pathName = dir.getAbsolutePath() + File.separator + AccessConstants.getPrefix() + this.fileDateFormatter.format(dayBefore) + "_" + this.fileDateFormatter.format(today) + AccessConstants.getSuffix();
            oldFile = new File(pathName);
        }
        existing.renameTo(oldFile);
        existing.delete();
    }

    synchronized void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.dateStamp = "";
        this.currentLogFile = null;
    }

    public static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }
}

