/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.access;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessConfiguration {
    private static final Log log = LogFactory.getLog(AccessConfiguration.class);
    private static String CONF_LOCATION = "conf.location";
    private static AccessConfiguration instance = new AccessConfiguration();
    private Properties props;

    private AccessConfiguration() {
        try {
            this.props = AccessConfiguration.loadProperties("access-log.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static AccessConfiguration getInstance() {
        return instance;
    }

    public Integer getIntProperty(String name, Integer def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            int intVal;
            try {
                intVal = Integer.valueOf(val);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid access configuration property value. " + name + " must be an integer"));
                return def;
            }
            if (log.isTraceEnabled()) {
                log.debug((Object)("Using access configuration parameter : " + name + " = " + val));
            }
            return intVal;
        }
        return def;
    }

    public Integer getIntProperty(String name) {
        return this.getIntProperty(name, null);
    }

    public Boolean getBooleanProperty(String name, Boolean def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null) {
            if (log.isTraceEnabled()) {
                log.debug((Object)("Using access configuration parameter : " + name + " = " + val));
            }
            return Boolean.valueOf(val);
        }
        return def;
    }

    public Boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, null);
    }

    public String getStringProperty(String name, String def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        return val == null ? def : val;
    }

    private static Properties loadProperties(String filePath) {
        String msg;
        Properties properties = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (log.isTraceEnabled()) {
            log.debug((Object)("Loading the file '" + filePath + "' from classpath"));
        }
        InputStream in = null;
        if (System.getProperty(CONF_LOCATION) != null) {
            try {
                in = new FileInputStream(System.getProperty(CONF_LOCATION) + File.separator + filePath);
            }
            catch (FileNotFoundException e) {
                msg = "Error loading properties from file: " + filePath;
                log.warn((Object)msg);
            }
        }
        if (in == null) {
            in = cl.getResourceAsStream(filePath);
            if (log.isTraceEnabled()) {
                log.debug((Object)("Unable to load file  '" + filePath + "'"));
            }
            filePath = "conf" + File.separatorChar + filePath;
            if (log.isTraceEnabled()) {
                log.debug((Object)("Loading the file '" + filePath + "'"));
            }
            if ((in = cl.getResourceAsStream(filePath)) == null && log.isTraceEnabled()) {
                log.debug((Object)("Unable to load file  '" + filePath + "'"));
            }
        }
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
                msg = "Error loading properties from a file at : " + filePath;
                log.error((Object)msg, (Throwable)e);
            }
        }
        return properties;
    }
}

