/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.http.access;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.http.access.AccessConstants;
import org.apache.synapse.transport.http.access.AccessLogger;
import org.apache.synapse.transport.http.access.AccessTimeUtil;
import org.apache.synapse.transport.http.wrapper.HttpRequestWrapper;
import org.apache.synapse.transport.http.wrapper.HttpResponseWrapper;

public class Access {
    private static Log log = LogFactory.getLog(Access.class);
    protected AccessLogElement[] logElements = null;
    protected String pattern = AccessConstants.getLogPattern();
    private static AccessLogger accessLogger;
    private static ConcurrentLinkedQueue<HttpRequestWrapper> requestQueue;
    private static ConcurrentLinkedQueue<HttpResponseWrapper> responseQueue;
    private static final int LOG_FREQUENCY_IN_SECONDS = 30;
    private Date date;

    public Access(Log log, AccessLogger accessLogger) {
        Access.log = log;
        Access.accessLogger = accessLogger;
        requestQueue = new ConcurrentLinkedQueue();
        responseQueue = new ConcurrentLinkedQueue();
        this.logElements = this.createLogElements();
        this.logAccesses();
    }

    public void addAccessToQueue(HttpRequest request) {
        HttpRequestWrapper requestWrapper = new HttpRequestWrapper();
        requestWrapper.setHttpRequest(request);
        requestWrapper.setDate(new Date(AccessTimeUtil.getDate().getTime()));
        requestQueue.add(requestWrapper);
    }

    public void addAccessToQueue(HttpResponse response) {
        HttpResponseWrapper responseWrapper = new HttpResponseWrapper();
        responseWrapper.setHttpResponse(response);
        responseWrapper.setDate(new Date(AccessTimeUtil.getDate().getTime()));
        responseQueue.add(responseWrapper);
    }

    public void logAccesses() {
        LogRequests logRequests = new LogRequests();
        LogResponses logResponses = new LogResponses();
        Timer requestTimer = new Timer();
        Timer responseTimer = new Timer();
        long retryIn = 30000L;
        requestTimer.schedule((TimerTask)logRequests, 0L, retryIn);
        responseTimer.schedule((TimerTask)logResponses, 0L, retryIn);
    }

    public void log(HttpRequest request, HttpResponse response) {
        this.date = AccessTimeUtil.getDate();
        StringBuilder result = new StringBuilder(128);
        for (AccessLogElement logElement : this.logElements) {
            logElement.addElement(result, this.date, request, response);
        }
        String logString = result.toString();
        log.debug((Object)logString);
        accessLogger.log(logString);
    }

    protected static String getHeaderValues(HttpMessage message, String name) {
        int length = 0;
        Header[] header = new Header[]{};
        StringBuffer headerValue = new StringBuffer();
        try {
            header = message.getHeaders(name);
            length = header.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (length == 0) {
            return "-";
        }
        if (length == 1) {
            return header[0].getValue();
        }
        headerValue.append(header[0].getValue());
        for (int i = 1; i < length; ++i) {
            headerValue.append(" - ").append(header[i].getValue());
        }
        return headerValue.toString();
    }

    protected static String getParam(HttpMessage message, String paramName) {
        HttpParams params = message.getParams();
        String param = (String)params.getParameter(paramName);
        if (param == null) {
            param = "-";
        }
        return param;
    }

    public static String getHostElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Host");
    }

    public static String getLogicalUserNameElement(HttpMessage message) {
        if (message != null) {
            return "-";
        }
        return "";
    }

    public static String getUserNameElement(HttpMessage message) {
        return Access.getHeaderValues(message, "From");
    }

    public static String getCookieElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Cookie");
    }

    public static String getRefererElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Referer");
    }

    public static String getUserAgentElement(HttpMessage message) {
        return Access.getHeaderValues(message, "User-Agent");
    }

    public static String getAcceptElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Accept");
    }

    public static String getAcceptLanguageElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Accept-Language");
    }

    public static String getAcceptEncodingElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Accept-Encoding");
    }

    public static String getAcceptCharSetElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Accept-Charset");
    }

    public static String getConnectionElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Connection");
    }

    public static String getContentTypeElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Content-Type");
    }

    public static String getKeepAliveElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Keep-Alive");
    }

    public static String getTransferEncodingElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Transfer-Encoding");
    }

    public static String getContentEncodingElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Content-Encoding");
    }

    public static String getVaryElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Vary");
    }

    public static String getServerElement(HttpMessage message) {
        return Access.getHeaderValues(message, "Server");
    }

    public static String getRemoteAddr(HttpMessage message) {
        return Access.getParam(message, "http.remote.addr");
    }

    protected AccessLogElement[] createLogElements() {
        ArrayList<AccessLogElement> list = new ArrayList<AccessLogElement>();
        boolean replace = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.pattern.length(); ++i) {
            char ch = this.pattern.charAt(i);
            if (replace) {
                if ('{' == ch) {
                    int j;
                    StringBuilder name = new StringBuilder();
                    for (j = i + 1; j < this.pattern.length() && '}' != this.pattern.charAt(j); ++j) {
                        name.append(this.pattern.charAt(j));
                    }
                    if (j + 1 < this.pattern.length()) {
                        list.add(this.createAccessLogElement(name.toString(), this.pattern.charAt(++j)));
                        i = j;
                    } else {
                        list.add(this.createAccessLogElement(ch));
                    }
                } else {
                    list.add(this.createAccessLogElement(ch));
                }
                replace = false;
                continue;
            }
            if (ch == '%') {
                replace = true;
                list.add(new StringElement(buf.toString()));
                buf = new StringBuilder();
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            list.add(new StringElement(buf.toString()));
        }
        return list.toArray(new AccessLogElement[list.size()]);
    }

    private AccessLogElement createAccessLogElement(String header, char pattern) {
        switch (pattern) {
            case 'i': {
                return new HeaderElement(header);
            }
            case 'o': {
                return new ResponseHeaderElement(header);
            }
            case 'R': {
                return new RequestAttributeElement();
            }
        }
        return new StringElement("???");
    }

    private AccessLogElement createAccessLogElement(char pattern) {
        switch (pattern) {
            case 'A': {
                return new LocalAddrElement();
            }
            case 'a': {
                return new UserAgentElement();
            }
            case 'b': {
                return new ByteSentElement(true);
            }
            case 'B': {
                return new ByteSentElement(false);
            }
            case 'c': {
                return new CookieElement();
            }
            case 'C': {
                return new AcceptElement();
            }
            case 'e': {
                return new AcceptEncodingElement();
            }
            case 'E': {
                return new TransferEncodingElement();
            }
            case 'f': {
                return new RefererElement();
            }
            case 'h': {
                return new HostElement();
            }
            case 'k': {
                return new KeepAliveElement();
            }
            case 'l': {
                return new LogicalUserNameElement();
            }
            case 'L': {
                return new AcceptLanguageElement();
            }
            case 'm': {
                return new MethodElement();
            }
            case 'n': {
                return new ContentEncodingElement();
            }
            case 'r': {
                return new RequestElement();
            }
            case 'S': {
                return new AcceptCharSetElement();
            }
            case 's': {
                return new HttpStatusCodeElement();
            }
            case 'T': {
                return new ContentTypeElement();
            }
            case 't': {
                return new DateAndTimeElement();
            }
            case 'u': {
                return new UserElement();
            }
            case 'U': {
                return new RequestURIElement();
            }
            case 'V': {
                return new VaryElement();
            }
            case 'v': {
                return new LocalServerNameElement();
            }
            case 'x': {
                return new ConnectionElement();
            }
            case 'Z': {
                return new ServerElement();
            }
        }
        return new StringElement("???" + pattern + "???");
    }

    public void log(HttpRequestWrapper request, HttpResponseWrapper response) {
        Date actualDateOfOperation = null;
        if (request != null) {
            actualDateOfOperation = request.getDate();
        } else if (response != null) {
            actualDateOfOperation = response.getDate();
        }
        StringBuilder result = new StringBuilder(128);
        for (AccessLogElement logElement : this.logElements) {
            if (request != null) {
                logElement.addElement(result, actualDateOfOperation, request.getHttpRequest(), null);
                continue;
            }
            if (response == null) continue;
            logElement.addElement(result, actualDateOfOperation, null, response.getHttpResponse());
        }
        String logString = result.toString();
        log.debug((Object)logString);
        accessLogger.log(logString);
    }

    protected static class RequestAttributeElement
    implements AccessLogElement {
        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String value = request != null ? request.getLastHeader(buf.toString()) : "??";
            if (value != null) {
                if (value instanceof String) {
                    buf.append(value);
                } else {
                    buf.append(value.toString());
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected static class ResponseHeaderElement
    implements AccessLogElement {
        private String header;

        public ResponseHeaderElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (null != response) {
                buf.append(Access.getHeaderValues((HttpMessage)response, this.header));
            }
            buf.append("-");
        }
    }

    protected static class ServerElement
    implements AccessLogElement {
        protected ServerElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getServerElement((HttpMessage)request));
        }
    }

    protected static class VaryElement
    implements AccessLogElement {
        protected VaryElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getVaryElement((HttpMessage)request));
        }
    }

    protected static class ContentEncodingElement
    implements AccessLogElement {
        protected ContentEncodingElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getContentEncodingElement((HttpMessage)request));
        }
    }

    protected static class TransferEncodingElement
    implements AccessLogElement {
        protected TransferEncodingElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getTransferEncodingElement((HttpMessage)request));
        }
    }

    protected static class KeepAliveElement
    implements AccessLogElement {
        protected KeepAliveElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getKeepAliveElement((HttpMessage)request));
        }
    }

    protected static class ContentTypeElement
    implements AccessLogElement {
        protected ContentTypeElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getContentTypeElement((HttpMessage)request));
        }
    }

    protected static class ConnectionElement
    implements AccessLogElement {
        protected ConnectionElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getConnectionElement((HttpMessage)request));
        }
    }

    protected static class AcceptCharSetElement
    implements AccessLogElement {
        protected AcceptCharSetElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getAcceptCharSetElement((HttpMessage)request));
        }
    }

    protected static class AcceptEncodingElement
    implements AccessLogElement {
        protected AcceptEncodingElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getAcceptEncodingElement((HttpMessage)request));
        }
    }

    protected static class AcceptLanguageElement
    implements AccessLogElement {
        protected AcceptLanguageElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getAcceptLanguageElement((HttpMessage)request));
        }
    }

    protected static class AcceptElement
    implements AccessLogElement {
        protected AcceptElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getAcceptElement((HttpMessage)request));
        }
    }

    protected static class UserAgentElement
    implements AccessLogElement {
        protected UserAgentElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getUserAgentElement((HttpMessage)request));
        }
    }

    protected static class RefererElement
    implements AccessLogElement {
        protected RefererElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getRefererElement((HttpMessage)request));
        }
    }

    protected static class CookieElement
    implements AccessLogElement {
        protected CookieElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getCookieElement((HttpMessage)request));
        }
    }

    protected static class HeaderElement
    implements AccessLogElement {
        private String header;

        public HeaderElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            try {
                String value = Access.getHeaderValues((HttpMessage)request, this.header);
                if (value == null) {
                    buf.append('-');
                } else {
                    buf.append(value);
                }
            }
            catch (Exception e) {
                buf.append('-');
            }
        }
    }

    protected static class StringElement
    implements AccessLogElement {
        private String str;

        public StringElement(String str) {
            this.str = str;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(this.str);
        }
    }

    protected static class LocalServerNameElement
    implements AccessLogElement {
        protected LocalServerNameElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(Access.getHeaderValues((HttpMessage)request, "server"));
        }
    }

    protected static class RequestURIElement
    implements AccessLogElement {
        protected RequestURIElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (request != null) {
                String uri = request.getRequestLine().getUri().split("\\?")[0];
                buf.append(uri);
            } else {
                buf.append('-');
            }
        }
    }

    protected static class MethodElement
    implements AccessLogElement {
        protected MethodElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (request != null) {
                buf.append(request.getRequestLine().getMethod());
            }
        }
    }

    protected static class ByteSentElement
    implements AccessLogElement {
        private boolean conversion;

        public ByteSentElement(boolean conversion) {
            this.conversion = conversion;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            long length = -1L;
            try {
                if (request != null) {
                    String sLength = Access.getHeaderValues((HttpMessage)request, "Content-Length");
                    if (null != sLength && !"".equals(sLength)) {
                        length = Long.valueOf(sLength);
                    }
                } else if (response != null) {
                    length = response.getEntity().getContentLength();
                }
                if (length <= 0L && this.conversion) {
                    buf.append('-');
                } else {
                    buf.append(length);
                }
            }
            catch (Exception e) {
                buf.append('-');
            }
        }
    }

    protected static class HttpStatusCodeElement
    implements AccessLogElement {
        protected HttpStatusCodeElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (response != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                buf.append(statusCode);
            } else {
                buf.append('-');
            }
        }
    }

    protected static class RequestElement
    implements AccessLogElement {
        protected RequestElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            if (request != null) {
                String requestLine = request.getRequestLine().toString();
                buf.append(requestLine);
            } else {
                buf.append("- - ");
            }
        }
    }

    protected class DateAndTimeElement
    implements AccessLogElement {
        protected DateAndTimeElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String currentDate = AccessTimeUtil.getAccessDate(date);
            buf.append(currentDate);
        }
    }

    protected static class UserElement
    implements AccessLogElement {
        protected UserElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String userElement = "";
            try {
                userElement = Access.getUserNameElement((HttpMessage)request);
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.append(userElement);
        }
    }

    protected static class LogicalUserNameElement
    implements AccessLogElement {
        protected LogicalUserNameElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String logicalUserName = "";
            try {
                logicalUserName = Access.getLogicalUserNameElement((HttpMessage)request);
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.append(logicalUserName);
        }
    }

    protected static class HostElement
    implements AccessLogElement {
        protected HostElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            String remoteHost = "-";
            try {
                if (request != null) {
                    remoteHost = Access.getRemoteAddr((HttpMessage)request);
                } else if (response != null) {
                    remoteHost = Access.getRemoteAddr((HttpMessage)response);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.append(remoteHost);
        }
    }

    protected static class LocalAddrElement
    implements AccessLogElement {
        private static final String LOCAL_ADDR_VALUE;

        protected LocalAddrElement() {
        }

        @Override
        public void addElement(StringBuilder buf, Date date, HttpRequest request, HttpResponse response) {
            buf.append(LOCAL_ADDR_VALUE);
        }

        static {
            String init;
            try {
                init = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable e) {
                AccessTimeUtil.handleThrowable(e);
                init = "127.0.0.1";
            }
            LOCAL_ADDR_VALUE = init;
        }
    }

    protected static interface AccessLogElement {
        public void addElement(StringBuilder var1, Date var2, HttpRequest var3, HttpResponse var4);
    }

    private class LogResponses
    extends TimerTask {
        private LogResponses() {
        }

        @Override
        public void run() {
            while (!responseQueue.isEmpty()) {
                HttpResponseWrapper res = (HttpResponseWrapper)responseQueue.poll();
                Access.this.log(null, res);
            }
        }
    }

    private class LogRequests
    extends TimerTask {
        private LogRequests() {
        }

        @Override
        public void run() {
            while (!requestQueue.isEmpty()) {
                HttpRequestWrapper req = (HttpRequestWrapper)requestQueue.poll();
                Access.this.log(req, null);
            }
        }
    }
}

