/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.dynamicconfigurations;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.ParameterInclude;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.dynamicconfigurations.DynamicProfileReloader;
import org.apache.synapse.transport.dynamicconfigurations.SSLProfileLoader;
import org.apache.synapse.transport.dynamicconfigurations.jmx.SSLProfileInvoker;

public class SenderProfileReloader
extends DynamicProfileReloader {
    private static final Log LOG = LogFactory.getLog(SenderProfileReloader.class);
    private SSLProfileLoader sslProfileLoader;
    private ParameterInclude transportOutDescription;
    private SSLProfileInvoker sslProfileInvoker;

    public SenderProfileReloader(SSLProfileLoader profileLoader, ParameterInclude transportOutDescription) {
        this.sslProfileLoader = profileLoader;
        this.transportOutDescription = transportOutDescription;
        if (this.registerListener(this.transportOutDescription)) {
            this.sslProfileInvoker = new SSLProfileInvoker(this);
            MBeanRegistrar.getInstance().registerMBean((Object)this.sslProfileInvoker, "SenderSSLProfileReloader", this.getClassName(this.sslProfileLoader.getClass().getName()));
        }
    }

    @Override
    public void notifyFileUpdate(boolean isScheduled) {
        this.setInvokedFromSchedule(isScheduled);
        try {
            this.sslProfileLoader.reloadConfig(this.transportOutDescription);
        }
        catch (AxisFault axisFault) {
            LOG.error((Object)("Error reloading dynamic SSL configurations for Senders : New Configurations will not be applied  " + axisFault.getMessage()));
        }
    }
}

