/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.dynamicconfigurations;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.ParameterInclude;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.dynamicconfigurations.DynamicProfileReloader;
import org.apache.synapse.transport.dynamicconfigurations.SSLProfileLoader;
import org.apache.synapse.transport.dynamicconfigurations.jmx.SSLProfileInvoker;

public class ListenerProfileReloader
extends DynamicProfileReloader {
    private static final Log LOG = LogFactory.getLog(ListenerProfileReloader.class);
    private SSLProfileLoader sslProfileLoader;
    private ParameterInclude transportInDescription;
    private SSLProfileInvoker sslProfileInvoker;

    public ListenerProfileReloader(SSLProfileLoader profileLoader, ParameterInclude transportInDescription) {
        this.sslProfileLoader = profileLoader;
        this.transportInDescription = transportInDescription;
        if (this.registerListener(this.transportInDescription)) {
            this.sslProfileInvoker = new SSLProfileInvoker(this);
            MBeanRegistrar.getInstance().registerMBean((Object)this.sslProfileInvoker, "ListenerSSLProfileReloader", this.getClassName(this.sslProfileLoader.getClass().getName()));
        }
    }

    @Override
    public void notifyFileUpdate(boolean isScheduled) {
        this.setInvokedFromSchedule(isScheduled);
        try {
            this.sslProfileLoader.reloadConfig(this.transportInDescription);
        }
        catch (AxisFault axisFault) {
            LOG.error((Object)("Error reloading dynamic SSL configurations for Listeners : New Configurations will not be applied " + axisFault.getMessage()));
        }
    }
}

