/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.dynamicconfigurations;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.dynamicconfigurations.DynamicProfileReloader;

public class FileUpdateNotificationHandler
extends TimerTask {
    private static final Log log = LogFactory.getLog(FileUpdateNotificationHandler.class);
    private long fileReadInterval = 60000L;
    private List<DynamicProfileReloader> profileReloaders;

    public FileUpdateNotificationHandler(long sleepInterval) {
        if (sleepInterval > this.fileReadInterval) {
            this.fileReadInterval = sleepInterval;
        }
        this.profileReloaders = new ArrayList<DynamicProfileReloader>();
        this.scheduleTimer(this.fileReadInterval);
    }

    @Override
    public void run() {
        for (DynamicProfileReloader profileLoader : this.profileReloaders) {
            long recordedLastUpdatedTime = profileLoader.getLastUpdatedtime();
            String filePath = profileLoader.getFilePath();
            if (filePath == null) continue;
            if (!profileLoader.isInvokedFromSchedule()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Bypass the scheduled loading cycle of SSL profile since already loaded from JMX invocation : file path - " + filePath));
                }
                profileLoader.setInvokedFromSchedule(true);
                profileLoader.setLastUpdatedtime(System.currentTimeMillis());
                continue;
            }
            File configFile = new File(filePath);
            try {
                long latestLastUpdatedTime = configFile.lastModified();
                if (latestLastUpdatedTime <= recordedLastUpdatedTime) continue;
                profileLoader.setLastUpdatedtime(latestLastUpdatedTime);
                profileLoader.notifyFileUpdate(true);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Error loading last modified time for the SSL config file. Updates will not be loaded from " + filePath));
            }
        }
    }

    public void registerListener(DynamicProfileReloader dynamicProfileReloader) {
        this.profileReloaders.add(dynamicProfileReloader);
    }

    private void scheduleTimer(long interval) {
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)this, interval, interval);
    }
}

