/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.dynamicconfigurations;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.dynamicconfigurations.DynamicProfileReloaderHolder;
import org.apache.synapse.transport.dynamicconfigurations.FileUpdateNotificationHandler;

public abstract class DynamicProfileReloader {
    private static final Log log = LogFactory.getLog(DynamicProfileReloader.class);
    private final String PROFILE_CONFIG_NAME = "dynamicSSLProfilesConfig";
    private final String PATH_CONFIG_NAME = "filePath";
    private final String INTERVAL_CONFIG_NAME = "fileReadInterval";
    private boolean invokedFromSchedule = true;
    private long lastUpdatedtime;
    private String filePath;
    protected FileUpdateNotificationHandler fileUpdateNotificationHandler;

    public abstract void notifyFileUpdate(boolean var1);

    public long getLastUpdatedtime() {
        return this.lastUpdatedtime;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setLastUpdatedtime(long lastUpdatedtime) {
        this.lastUpdatedtime = lastUpdatedtime;
    }

    public boolean isInvokedFromSchedule() {
        return this.invokedFromSchedule;
    }

    public void setInvokedFromSchedule(boolean invokedFromSchedule) {
        this.invokedFromSchedule = invokedFromSchedule;
    }

    protected String extractConfigurationFilePath(ParameterInclude transportOut) {
        String path = null;
        Parameter profileParam = transportOut.getParameter("dynamicSSLProfilesConfig");
        if (profileParam != null) {
            OMElement profileParamElem = profileParam.getParameterElement();
            path = profileParamElem.getFirstChildWithName(new QName("filePath")).getText();
        }
        return path;
    }

    protected long extractSleepInterval(ParameterInclude transportOut) {
        OMElement profileParamElem;
        String interval;
        long fileReadInterval = -1L;
        Parameter profileParam = transportOut.getParameter("dynamicSSLProfilesConfig");
        if (profileParam != null && (interval = (profileParamElem = profileParam.getParameterElement()).getFirstChildWithName(new QName("fileReadInterval")).getText()) != null) {
            fileReadInterval = Long.parseLong(interval);
        }
        return fileReadInterval;
    }

    protected boolean registerListener(ParameterInclude transportDescription) {
        boolean notificationHandlerStarted = false;
        long configurationLoadingInterval = this.extractSleepInterval(transportDescription);
        String filePath = this.extractConfigurationFilePath(transportDescription);
        if (filePath != null) {
            this.fileUpdateNotificationHandler = new FileUpdateNotificationHandler(configurationLoadingInterval);
            this.setFilePath(filePath);
            this.setLastUpdatedtime(System.currentTimeMillis());
            this.fileUpdateNotificationHandler.registerListener(this);
            DynamicProfileReloaderHolder.getInstance().addNotificationHandler(this.fileUpdateNotificationHandler);
            notificationHandlerStarted = true;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Configuration File path is not configured and SSL Profiles will not be loaded dynamically in " + this.getClass().getName()));
        }
        return notificationHandlerStarted;
    }

    public String getClassName(String completeClassName) {
        String absoluteClassName = null;
        if (completeClassName != null) {
            absoluteClassName = completeClassName.substring(completeClassName.lastIndexOf(".") + 1);
        }
        return absoluteClassName;
    }
}

