/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.certificatevalidation.ocsp;

import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.certificatevalidation.CertificateVerificationException;
import org.apache.synapse.transport.certificatevalidation.cache.CacheController;
import org.apache.synapse.transport.certificatevalidation.cache.CacheManager;
import org.apache.synapse.transport.certificatevalidation.cache.ManageableCache;
import org.apache.synapse.transport.certificatevalidation.cache.ManageableCacheValue;
import org.apache.synapse.transport.certificatevalidation.ocsp.OCSPVerifier;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;

public class OCSPCache
implements ManageableCache {
    private static volatile OCSPCache cache;
    private static volatile Map<BigInteger, OCSPCacheValue> hashMap;
    private static volatile Iterator<Map.Entry<BigInteger, OCSPCacheValue>> iterator;
    private static volatile CacheManager cacheManager;
    private static OCSPVerifier ocspVerifier;
    private static final Log log;

    private OCSPCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OCSPCache getCache() {
        if (cache != null) return cache;
        Class<OCSPCache> clazz = OCSPCache.class;
        synchronized (OCSPCache.class) {
            if (cache != null) return cache;
            cache = new OCSPCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(int size, int delay) {
        if (cacheManager != null) return;
        Class<OCSPCache> clazz = OCSPCache.class;
        synchronized (OCSPCache.class) {
            if (cacheManager != null) return;
            cacheManager = new CacheManager(cache, size, delay);
            CacheController mbean = new CacheController(cache, cacheManager);
            MBeanRegistrar.getInstance().registerMBean((Object)mbean, "CacheController", "OCSPCacheController");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ManageableCacheValue getNextCacheValue() {
        if (iterator.hasNext()) {
            return hashMap.get(iterator.next().getKey());
        }
        this.resetIterator();
        return null;
    }

    @Override
    public int getCacheSize() {
        return hashMap.size();
    }

    @Override
    public void resetIterator() {
        iterator = hashMap.entrySet().iterator();
    }

    private synchronized void replaceNewCacheValue(OCSPCacheValue cacheValue) {
        if (cacheValue.isValid()) {
            return;
        }
        try {
            SingleResp[] responses;
            String serviceUrl = cacheValue.serviceUrl;
            OCSPReq request = cacheValue.request;
            OCSPResp response = ocspVerifier.getOCSPResponce(serviceUrl, request);
            if (0 != response.getStatus()) {
                throw new CertificateVerificationException("OCSP response status not SUCCESSFUL");
            }
            BasicOCSPResp basicResponse = (BasicOCSPResp)response.getResponseObject();
            SingleResp[] singleRespArray = responses = basicResponse == null ? null : basicResponse.getResponses();
            if (responses == null) {
                throw new CertificateVerificationException("Cant get OCSP response");
            }
            SingleResp resp = responses[0];
            this.setCacheValue(cacheValue.serialNumber, resp, request, serviceUrl);
        }
        catch (Exception e) {
            log.info((Object)"Cant replace old CacheValue with new CacheValue. So remove", (Throwable)e);
            cacheValue.removeThisCacheValue();
        }
    }

    public synchronized SingleResp getCacheValue(BigInteger serialNumber) {
        OCSPCacheValue cacheValue = hashMap.get(serialNumber);
        if (cacheValue != null) {
            if (!cacheValue.isValid()) {
                cacheValue.updateCacheWithNewValue();
                OCSPCacheValue ocspCacheValue = hashMap.get(serialNumber);
                return ocspCacheValue != null ? ocspCacheValue.getValue() : null;
            }
            return cacheValue.getValue();
        }
        return null;
    }

    public synchronized void setCacheValue(BigInteger serialNumber, SingleResp singleResp, OCSPReq request, String serviceUrl) {
        OCSPCacheValue cacheValue = new OCSPCacheValue(serialNumber, singleResp, request, serviceUrl);
        log.info((Object)("Before set - HashMap size " + hashMap.size()));
        hashMap.put(serialNumber, cacheValue);
        log.info((Object)("After set - HashMap size " + hashMap.size()));
    }

    public synchronized void removeCacheValue(BigInteger serialNumber) {
        log.info((Object)("Before remove - HashMap size " + hashMap.size()));
        hashMap.remove(serialNumber);
        log.info((Object)("After remove - HashMap size " + hashMap.size()));
    }

    static {
        hashMap = new ConcurrentHashMap<BigInteger, OCSPCacheValue>();
        iterator = hashMap.entrySet().iterator();
        ocspVerifier = new OCSPVerifier(null);
        log = LogFactory.getLog(OCSPCache.class);
    }

    private class OCSPCacheValue
    implements ManageableCacheValue {
        private BigInteger serialNumber;
        private SingleResp singleResp;
        private OCSPReq request;
        private String serviceUrl;
        private long timeStamp = System.currentTimeMillis();

        public OCSPCacheValue(BigInteger serialNumber, SingleResp singleResp, OCSPReq request, String serviceUrl) {
            this.serialNumber = serialNumber;
            this.singleResp = singleResp;
            this.request = request;
            this.serviceUrl = serviceUrl;
        }

        public BigInteger getKey() {
            return this.serialNumber;
        }

        public SingleResp getValue() {
            this.timeStamp = System.currentTimeMillis();
            return this.singleResp;
        }

        @Override
        public boolean isValid() {
            Date now = new Date();
            Date nextUpdate = this.singleResp.getNextUpdate();
            return nextUpdate != null && nextUpdate.after(now);
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public void removeThisCacheValue() {
            OCSPCache.this.removeCacheValue(this.serialNumber);
        }

        @Override
        public void updateCacheWithNewValue() {
            OCSPCache.this.replaceNewCacheValue(this);
        }
    }
}

